<?php
session_start();
require 'conexion.php';

// Validar sesión y rol
if (!isset($_SESSION['user_id']) || $_SESSION['role'] != 7) {
    header('Location: login.php');
    exit;
}

$user_id = $_SESSION['user_id'];

// Helper para obtener valores con trim y valor por defecto
function postv($key, $default = null) {
    return isset($_POST[$key]) ? trim($_POST[$key]) : $default;
}

/* ===========================
   1) Recoger datos del formulario
   =========================== */

// Identificación y datos personales
$Nom              = postv('Nom', '');
$Nom2             = postv('Nom2', '');
$Ape              = postv('Ape', '');
$Ape2             = postv('Ape2', '');
$FechaNacimiento  = postv('FechaNacimiento', null);
$Genero           = postv('Genero', null);
$dni              = postv('dni', null);
$estado_civil     = postv('estado_civil', null);
$edad             = postv('edad', null);
$direccion        = postv('direccion', null);
$telefono         = postv('telefono', null);
$numero_hijos     = postv('numero_hijos', null);
$correo_personal  = postv('correo_personal', null);

// Laboral
$numero_empleado    = postv('numero_empleado', null);
$fecha_ingreso      = postv('fecha_ingreso', null);
$tipo_contrato      = postv('tipo_contrato', null);
$CorreoElectronico  = postv('CorreoElectronico', null); 

// Académico
$nivel_educativo  = postv('nivel_educativo', null);
$profesion        = postv('profesion', null);

// Salud
$tipo_sangre      = postv('tipo_sangre', null);
$enfermedad       = postv('enfermedad', null);

// Contacto de emergencia
$nombre_contacto      = postv('nombre_contacto', null);
$parentesco           = postv('parentesco', null);
$contacto_emergencia  = postv('contacto_emergencia', null);

// Password (opcional)
$password         = postv('password', '');
$confirm_password = postv('confirm_password', '');


/* ===========================
   2) Validaciones básicas
   =========================== */

// Catálogos permitidos (CORREGIDOS PARA COINCIDIR CON HTML)
$valid_genero = ['M','F','O']; // Ajustado a los values del HTML
$valid_estado_civil = ['Soltero','Casado','Divorciado','Viudo']; // Agregado Viudo
$valid_tipo_contrato = ['Acuerdo','Contrato'];
$valid_nivel_educativo = [
    'Primaria','Secundaria','Pregrado',
    'Universidad Incompleta','Posgrado'
];
// Ajustado para coincidir con "Hermano/a" y "Esposo/a" del HTML
$valid_parentesco = ['Padre','Madre','Hermano/a','Esposo/a','Pareja']; 
$valid_tipo_sangre = ['A+','A-','B+','B-','AB+','AB-','O+','O-'];

// Normalizar/validar selects (si vienen nulos, se dejan nulos)
if ($Genero !== null && !in_array($Genero, $valid_genero, true))             $Genero = null;
if ($estado_civil !== null && !in_array($estado_civil, $valid_estado_civil, true)) $estado_civil = null;
if ($tipo_contrato !== null && !in_array($tipo_contrato, $valid_tipo_contrato, true)) $tipo_contrato = null;
if ($nivel_educativo !== null && !in_array($nivel_educativo, $valid_nivel_educativo, true)) $nivel_educativo = null;
if ($parentesco !== null && !in_array($parentesco, $valid_parentesco, true)) $parentesco = null;
if ($tipo_sangre !== null && !in_array($tipo_sangre, $valid_tipo_sangre, true)) $tipo_sangre = null;

// Validaciones simples de números (permiten vacío/nulo)
if ($edad !== null && $edad !== '' && !ctype_digit((string)$edad)) $edad = null;
if ($numero_hijos !== null && $numero_hijos !== '' && !ctype_digit((string)$numero_hijos)) $numero_hijos = null;


/* ===========================
   3) Construir UPDATE
   =========================== */

$campos = [
    'Nom' => $Nom,
    'Nom2' => $Nom2,
    'Ape' => $Ape,
    'Ape2' => $Ape2,
    'FechaNacimiento' => $FechaNacimiento,
    'Genero' => $Genero,

    // personales
    'dni' => $dni,
    'estado_civil' => $estado_civil,
    'edad' => ($edad === '' ? null : $edad),
    'direccion' => $direccion,
    'telefono' => $telefono,
    'numero_hijos' => ($numero_hijos === '' ? null : $numero_hijos),
    'correo_personal' => $correo_personal,

    // laboral
    'numero_empleado' => $numero_empleado,
    'fecha_ingreso' => $fecha_ingreso,
    'tipo_contrato' => $tipo_contrato,
    'CorreoElectronico' => $CorreoElectronico,

    // académico
    'nivel_educativo' => $nivel_educativo,
    'profesion' => $profesion,

    // salud
    'tipo_sangre' => $tipo_sangre,
    'enfermedad' => $enfermedad,

    // contacto emergencia
    'nombre_contacto' => $nombre_contacto,
    'parentesco' => $parentesco,
    'contacto_emergencia' => $contacto_emergencia,
];

// Manejo de contraseña si aplica
if ($password !== '' || $confirm_password !== '') {
    if ($password !== $confirm_password) {
        echo "Las contraseñas no coinciden.";
        exit;
    }
    if (strlen($password) < 6) {
        echo "La contraseña debe tener al menos 6 caracteres.";
        exit;
    }
    $hashedPassword = password_hash($password, PASSWORD_DEFAULT);
    $campos['password'] = $hashedPassword;
}

// Armar query dinámica
$set_parts = [];
$values = [];

foreach ($campos as $col => $val) {
    $set_parts[] = "$col = ?";
    $values[] = $val;
}

$query = "UPDATE accounts SET " . implode(', ', $set_parts) . " WHERE id = ?";
$values[] = (int)$user_id; // Agregar ID al final

// Preparar statement
$stmt = $conn->prepare($query);
if (!$stmt) {
    echo "Error en la preparación de la consulta: " . $conn->error;
    $conn->close();
    exit;
}

/*
 * Estrategia de Bind:
 * Usaremos 's' (string) para todos los campos para permitir NULLs fácilmente 
 * y evitar problemas de casteo, excepto el ID final que trataremos como 'i'.
 */
$types = str_repeat('s', count($values) - 1) . 'i';

// Construir arreglo de parámetros por referencia para call_user_func_array
$params = [];
$params[] = $types;
foreach ($values as $idx => $v) { 
    $params[] = &$values[$idx]; 
}

// Ejecutar bind
call_user_func_array([$stmt, 'bind_param'], $params);

// Ejecutar query
if ($stmt->execute()) {
    $stmt->close();
    $conn->close();
    header("Location: panel_empleado.php?success=1");
    exit;
} else {
    // IMPORTANTE: Mostrar error SQL real
    echo "Error al actualizar perfil: " . $stmt->error;
    $stmt->close();
    $conn->close();
}
?>