<?php
session_start();
require 'conexion.php';

// Validar que sea un jefe autorizado
if (!isset($_SESSION['user_id']) || !in_array($_SESSION['role'], [8, 9, 12])) {
    header('Location: login.php');
    exit;
}

$user_id = $_SESSION['user_id'];

function postv($key, $default = null) {
    return isset($_POST[$key]) ? trim($_POST[$key]) : $default;
}

// 1. Recoger datos
$campos = [
    'Nom' => postv('Nom'),
    'Nom2' => postv('Nom2'),
    'Ape' => postv('Ape'),
    'Ape2' => postv('Ape2'),
    'dni' => postv('dni'),
    'estado_civil' => postv('estado_civil'),
    'numero_hijos' => postv('numero_hijos'),
    'edad' => postv('edad'),
    'FechaNacimiento' => postv('FechaNacimiento'),
    'direccion' => postv('direccion'),
    'telefono' => postv('telefono'),
    'correo_personal' => postv('correo_personal'),
    'Genero' => postv('Genero'),
    'numero_empleado' => postv('numero_empleado'),
    'fecha_ingreso' => postv('fecha_ingreso'),
    'tipo_contrato' => postv('tipo_contrato'),
    'nivel_educativo' => postv('nivel_educativo'),
    'profesion' => postv('profesion'),
    'tipo_sangre' => postv('tipo_sangre'),
    'enfermedad' => postv('enfermedad'),
    'nombre_contacto' => postv('nombre_contacto'),
    'parentesco' => postv('parentesco'),
    'contacto_emergencia' => postv('contacto_emergencia')
];

// 2. Validaciones de catálogo (Sincronizadas con HTML)
$valid_genero = ['M', 'F', 'O'];
$valid_estado_civil = ['Soltero', 'Casado', 'Divorciado', 'Viudo'];
$valid_parentesco = ['Padre', 'Madre', 'Hermano/a', 'Esposo/a', 'Pareja'];

if ($campos['Genero'] && !in_array($campos['Genero'], $valid_genero)) $campos['Genero'] = null;
if ($campos['estado_civil'] && !in_array($campos['estado_civil'], $valid_estado_civil)) $campos['estado_civil'] = null;
if ($campos['parentesco'] && !in_array($campos['parentesco'], $valid_parentesco)) $campos['parentesco'] = null;

// Limpiar números
if ($campos['edad'] === '') $campos['edad'] = null;
if ($campos['numero_hijos'] === '') $campos['numero_hijos'] = null;

// 3. Construir Query
$set_parts = [];
$values = [];
foreach ($campos as $col => $val) {
    $set_parts[] = "$col = ?";
    $values[] = $val;
}

$query = "UPDATE accounts SET " . implode(', ', $set_parts) . " WHERE id = ?";
$values[] = $user_id;

$stmt = $conn->prepare($query);
if (!$stmt) {
    die("Error en la preparación: " . $conn->error);
}

// Bind dinámico (tratamos casi todo como string 's' para manejar NULLs de MySQL)
$types = str_repeat('s', count($values) - 1) . 'i';
$stmt->bind_param($types, ...$values);

if ($stmt->execute()) {
    $stmt->close();
    $conn->close();
    header("Location: panel_jefe_user.php?success=1");
    exit;
} else {
    echo "Error al ejecutar la actualización: " . $stmt->error;
}
?>