<?php
session_start();
require 'conexion.php';

if (!isset($_SESSION['user_id']) || ($_SESSION['role'] != 11 && $_SESSION['role'] != 9)) {
    header('Location: login.php');
    exit;
}

$user_id = $_SESSION['user_id'];

function postv($key, $default = null) {
    return (isset($_POST[$key]) && $_POST[$key] !== '') ? trim($_POST[$key]) : $default;
}

/* 1) Recoger datos */
$campos = [
    'Nom' => postv('Nom'),
    'Nom2' => postv('Nom2'),
    'Ape' => postv('Ape'),
    'Ape2' => postv('Ape2'),
    'FechaNacimiento' => postv('FechaNacimiento'),
    'Genero' => postv('Genero'),
    'dni' => postv('dni'),
    'estado_civil' => postv('estado_civil'),
    'edad' => postv('edad'),
    'direccion' => postv('direccion'),
    'telefono' => postv('telefono'),
    'numero_hijos' => postv('numero_hijos'),
    'correo_personal' => postv('correo_personal'),
    'numero_empleado' => postv('numero_empleado'),
    'fecha_ingreso' => postv('fecha_ingreso'),
    'tipo_contrato' => postv('tipo_contrato'),
    'nivel_educativo' => postv('nivel_educativo'),
    'profesion' => postv('profesion'),
    'tipo_sangre' => postv('tipo_sangre'),
    'enfermedad' => postv('enfermedad'),
    'nombre_contacto' => postv('nombre_contacto'),
    'parentesco' => postv('parentesco'),
    'contacto_emergencia' => postv('contacto_emergencia')
];

/* 2) Manejo de contraseña */
$password = postv('password');
$confirm = postv('confirm_password');

if ($password) {
    if ($password !== $confirm) {
        die("Las contraseñas no coinciden.");
    }
    if (strlen($password) < 6) {
        die("Contraseña demasiado corta.");
    }
    $campos['password'] = password_hash($password, PASSWORD_DEFAULT);
}

/* 3) Construcción de Query Dinámica */
$set_query = [];
$types = "";
$values = [];

foreach ($campos as $columna => $valor) {
    $set_query[] = "$columna = ?";
    $types .= "s"; // Usamos string para casi todo para manejar NULLs fácilmente
    $values[] = $valor;
}

$sql = "UPDATE accounts SET " . implode(', ', $set_query) . " WHERE id = ?";
$types .= "i";
$values[] = $user_id;

$stmt = $conn->prepare($sql);

// El sistema de binding dinámico requiere referencias en versiones antiguas de PHP
$stmt->bind_param($types, ...$values);

if ($stmt->execute()) {
    header("Location: panel_rrhh_user.php?success=1");
} else {
    echo "Error al actualizar: " . $stmt->error;
}

$stmt->close();
$conn->close();
?>