<?php
session_start();
require 'conexion.php';

// Verificar autenticación
if (!isset($_SESSION['user_id']) || $_SESSION['role'] != 9) { // Asumiendo rol 9 para RRHH
    $_SESSION['error'] = 'Acceso no autorizado.';
    header("Location: login.php");
    exit;
}

// Procesar formulario si se envía
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['asignar'])) {
    $cod_unidad = $_POST['cod_unidad'];
    $cod_jefe = $_POST['cod_jefe'];
    $fecha_inicio = $_POST['fecha_inicio'];
    $fecha_fin = $_POST['fecha_fin'];
    $motivo = $_POST['motivo'];

    $sql = "INSERT INTO asignaciones_temporales (cod_unidad, cod_jefe, fecha_inicio, fecha_fin, motivo) 
            VALUES (?, ?, ?, ?, ?)";
    if ($stmt = $conn->prepare($sql)) {
        $stmt->bind_param('iisss', $cod_unidad, $cod_jefe, $fecha_inicio, $fecha_fin, $motivo);
        $stmt->execute();
        $stmt->close();
        $_SESSION['success'] = 'Asignación temporal registrada con éxito.';
    } else {
        $_SESSION['error'] = 'Error al registrar la asignación.';
    }
}

// Obtener unidades y sus jefes actuales
$sql_unidades = "SELECT u.cod_unidad, u.nombre_unidad, j.nombre_jefe AS jefe_actual 
                 FROM unidad u 
                 LEFT JOIN jefes j ON u.cod_jefe = j.cod_jefe";
$result_unidades = $conn->query($sql_unidades);

// Obtener lista de todos los jefes con su cod_unidad
$sql_jefes = "SELECT cod_jefe, nombre_jefe, cod_unidad 
              FROM jefes";
$result_jefes = $conn->query($sql_jefes);

$conn->close();
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Asignar Jefes Temporales</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        body {
            background-color: #f4f7fa;
            color: #333;
        }

        .container {
            display: flex;
            min-height: 100vh;
        }

        .sidebar {
            width: 250px;
            background-color: #2c3e50;
            color: white;
            padding: 20px;
            position: fixed;
            height: 100%;
            box-shadow: 2px 0 5px rgba(0, 0, 0, 0.1);
        }

        .sidebar h2 {
            font-size: 20px;
            margin-bottom: 30px;
            text-align: center;
            color: #68c8d8;
        }

        .sidebar ul {
            list-style: none;
        }

        .sidebar ul li {
            margin-bottom: 15px;
        }

        .sidebar ul li a {
            color: #ecf0f1;
            text-decoration: none;
            font-size: 16px;
            display: block;
            padding: 10px;
            border-radius: 5px;
            transition: background 0.3s;
        }

        .sidebar ul li a:hover {
            background-color: #34495e;
        }

        .main-content {
            margin-left: 250px;
            padding: 40px;
            width: calc(100% - 250px);
            background-color: #f4f7fa;
        }

        h1 {
            color: #2c3e50;
            text-align: center;
            margin-bottom: 20px;
        }

        .form-group {
            margin-bottom: 15px;
        }

        label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
        }

        select, input[type="date"], textarea {
            width: 100%;
            padding: 8px;
            border: 1px solid #ddd;
            border-radius: 4px;
            box-sizing: border-box;
        }

        textarea {
            height: 100px;
        }

        button {
            padding: 10px 20px;
            background-color: #27ae60;
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            transition: background 0.3s;
        }

        button:hover {
            background-color: #219653;
        }

        .message {
            margin-top: 10px;
            padding: 10px;
            border-radius: 4px;
        }

        .success {
            background-color: #dff0d8;
            color: #3c763d;
        }

        .error {
            background-color: #f2dede;
            color: #a94442;
        }

        @media (max-width: 768px) {
            .sidebar {
                width: 200px;
            }
            .main-content {
                margin-left: 200px;
                width: calc(100% - 200px);
                padding: 20px;
            }
        }

        @media (max-width: 480px) {
            .sidebar {
                width: 100%;
                height: auto;
                position: static;
                padding: 10px;
            }
            .sidebar h2 {
                font-size: 18px;
            }
            .sidebar ul li a {
                font-size: 14px;
                padding: 8px;
            }
            .main-content {
                margin-left: 0;
                width: 100%;
                padding: 15px;
            }
            h1 {
                font-size: 18px;
            }
            select, input[type="date"], textarea {
                font-size: 14px;
            }
        }
    </style>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const unidadSelect = document.getElementById('cod_unidad');
            const jefeSelect = document.getElementById('cod_jefe');
            let jefeOptions = [];

            // Guardar todas las opciones de jefes como JSON
            <?php
            $jefe_data = [];
            while ($row = $result_jefes->fetch_assoc()) {
                $jefe_data[] = $row;
            }
            echo 'jefeOptions = ' . json_encode($jefe_data) . ';';
            $result_jefes->data_seek(0); // Reset pointer
            ?>

            // Filtrar jefes cuando cambie la unidad
            unidadSelect.addEventListener('change', function() {
                const selectedUnidad = this.value;
                jefeSelect.innerHTML = '<option value="">Seleccione un jefe</option>';

                jefeOptions.forEach(option => {
                    if (option.cod_unidad == selectedUnidad || !selectedUnidad) {
                        const opt = document.createElement('option');
                        opt.value = option.cod_jefe;
                        opt.textContent = option.nombre_jefe;
                        jefeSelect.appendChild(opt);
                    }
                });
            });
        });
    </script>
</head>
<body>
    <div class="container">
        <div class="sidebar">
            <h2>Panel Recursos Humanos</h2>
            <ul>
                <li><a href="dashboard_rrhh.php">Inicio</a></li>
                <li><a href="gestionar_solicitudes_rrhh.php">Gestionar Solicitudes</a></li>
                <li><a href="estadisticas_rrhh.php">Estadísticas</a></li>
                <li><a href="ver_solicitudes.php">Ver Solicitudes</a></li>
                <li><a href="#">Configuración</a></li>
                <li><a href="logout.php">Cerrar Sesión</a></li>
            </ul>
        </div>

        <div class="main-content">
            <h1>Asignar Jefes Temporales</h1>
            <?php if (isset($_SESSION['success'])): ?>
                <div class="message success"><?= $_SESSION['success'] ?></div>
                <?php unset($_SESSION['success']); ?>
            <?php endif; ?>
            <?php if (isset($_SESSION['error'])): ?>
                <div class="message error"><?= $_SESSION['error'] ?></div>
                <?php unset($_SESSION['error']); ?>
            <?php endif; ?>

            <form method="POST" action="">
                <div class="form-group">
                    <label for="cod_unidad">Unidad:</label>
                    <select id="cod_unidad" name="cod_unidad" required>
                        <option value="">Seleccione una unidad</option>
                        <?php while ($row = $result_unidades->fetch_assoc()): ?>
                            <option value="<?= $row['cod_unidad'] ?>"><?= htmlspecialchars($row['nombre_unidad']) ?> (Jefe actual: <?= htmlspecialchars($row['jefe_actual'] ?? 'Sin jefe') ?>)</option>
                        <?php endwhile; ?>
                        <?php $result_unidades->data_seek(0); // Reset pointer for potential reuse ?>
                    </select>
                </div>

                <div class="form-group">
                    <label for="cod_jefe">Jefe Sustituto:</label>
                    <select id="cod_jefe" name="cod_jefe" required>
                        <option value="">Seleccione un jefe</option>
                    </select>
                </div>

                <div class="form-group">
                    <label for="fecha_inicio">Fecha de Inicio:</label>
                    <input type="date" id="fecha_inicio" name="fecha_inicio" required min="<?= date('Y-m-d') ?>">
                </div>

                <div class="form-group">
                    <label for="fecha_fin">Fecha de Fin:</label>
                    <input type="date" id="fecha_fin" name="fecha_fin" required>
                </div>

                <div class="form-group">
                    <label for="motivo">Motivo:</label>
                    <textarea id="motivo" name="motivo" required></textarea>
                </div>

                <button type="submit" name="asignar">Asignar Jefe Temporal</button>
            </form>
        </div>
    </div>
</body>
</html>