<?php
session_start();
require_once 'conexion.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] != 9) {
    header("Location: login.php");
    exit;
}

$conn = new mysqli($servername, $username, $password, $dbname);
if ($conn->connect_error) die("Conexión fallida: " . $conn->connect_error);

if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['user_id'])) {
    $uid = intval($_POST['user_id']);
    $stmt = $conn->prepare("UPDATE accounts SET cod_rol = 9 WHERE ID = ? AND cod_rol = 11 AND cod_unidad = 2");
    $stmt->bind_param("i", $uid);
    $stmt->execute();
    $stmt->close();
}

$sql = "SELECT ID, Nom, Nom2, Ape, Ape2 FROM accounts WHERE cod_rol = 11 AND cod_unidad = 2";
$result = $conn->query($sql);
$conn->close();
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Asignar Privilegios RRHH</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        body { margin: 0; font-family: Arial, sans-serif; background: #f4f7fa; }
        .container { display: flex; min-height: 100vh; }

        .sidebar {
            width: 250px;
            background: linear-gradient(135deg, #2c3e50, #34495e);
            color: white;
            padding: 20px 15px;
            position: fixed;
            height: 100%;
            top: 0;
            left: 0;
            box-shadow: 2px 0 5px rgba(0, 0, 0, 0.1);
            transition: transform 0.3s ease;
            z-index: 1000;
        }

        .sidebar h2 { 
            font-size: 24px;
            margin-bottom: 30px;
            text-align: center;
            color: #68c8d8;
            font-weight: 700;
        }

        .sidebar ul { list-style: none; padding: 0; }
        .sidebar li { margin-bottom: 15px; }

        .sidebar a {
            display: flex;
            align-items: center;
            color: #ecf0f1;
            padding: 10px 15px;
            text-decoration: none;
            border-radius: 4px;
            transition: background 0.3s, color 0.3s;
        }

        .sidebar a:hover { 
            background: #465c71;
            color: #68c8d8;
        }

        .sidebar a i {
            margin-right: 10px;
            font-size: 16px;
        }

        .toggle-btn {
            display: none;
            position: fixed;
            left: 15px;
            top: 15px;
            background: #68c8d8;
            color: white;
            border: none;
            padding: 10px 12px;
            border-radius: 5px;
            cursor: pointer;
            z-index: 1100;
            font-size: 18px;
        }

        .toggle-btn:hover { background: #5dade2; }

        .main-content {
            flex-grow: 1;
            padding: 40px;
            margin-left: 250px;
            transition: margin-left 0.3s ease;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            background: white;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
            border-radius: 5px;
        }

        th, td {
            padding: 12px;
            text-align: left;
            border-bottom: 1px solid #ddd;
        }

        th { background: #2c3e50; color: white; }

        button {
            background: #27ae60;
            color: white;
            border: none;
            padding: 8px 12px;
            border-radius: 4px;
            cursor: pointer;
        }

        button:hover { background: #219653; }

        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-100%);
                width: 250px;
            }

            .sidebar.open {
                transform: translateX(0);
            }

            .toggle-btn {
                display: block;
            }

            .main-content {
                margin-left: 0;
                padding: 20px;
            }
        }
    </style>
</head>
<body>
<div class="container">
<div class="sidebar" id="sidebar">
    <h2>Panel RRHH</h2>
    <ul>
        <li><a href="dashboard_rrhh.php"><i class="fas fa-home"></i> Inicio</a></li>
        <?php if ($_SESSION['role'] != 11): ?>
            <li><a href="gestionar_solicitudes_rrhh.php"><i class="fas fa-tasks"></i> Gestionar Solicitudes</a></li>
        <?php endif; ?>
        <li><a href="panel_jefe_rrhh.php"><i class="fas fa-chart-bar"></i>Solicitudes Unidad RRHH</a></li>
         <li><a href="panel_rrhh_vacaciones.php"><i class="fas fa-chart-bar"></i>Solicitudes Vacaciones RRHH</a></li>
        <li><a href="estadisticas_rrhh.php"><i class="fas fa-chart-bar"></i> Estadísticas</a></li>
        <li><a href="solicitudes_aprobadas_rrhh.php"><i class="fas fa-check"></i> Historial de Solicitudes Aprobadas</a></li>
        <li><a href="ver_solicitudes.php"><i class="fas fa-eye"></i> Más Solicitudes</a></li>
        <?php if ($_SESSION['role'] != 11): ?>
            <li><a href="gestionar_empleados.php"><i class="fas fa-users"></i> Gestión de Empleados</a></li>
        <?php endif; ?>
        <li><a href="panel_vacaciones_rrhh.php"><i class="fas fa-umbrella-beach"></i> Gestión de Vacaciones</a></li>
        <?php if ($_SESSION['role'] != 11): ?>
            <li><a href="gestionar_unidades_puestos.php"><i class="fas fa-building"></i> Unidades y Puestos</a></li>
            <li><a href="asignar_privilegios_rrhh.php"><i class="fas fa-user-shield"></i> Asignar Rol</a></li>
        <?php endif; ?>

        <!-- ✅ NUEVO: acceso directo al Portal de Denuncias -->
        <li>
            <a href="https://sistemas.proasol.gob.hn/denuncias_proasol/index.html?src=rrhh_sidebar"
               target="_blank" rel="noopener">
               <i class="fas fa-shield-alt"></i> Denuncia-CPEP
            </a>
        </li>

        <li><a href="panel_rrhh_user.php"><i class="fas fa-user"></i> Perfil</a></li>
        <li><a href="logout.php"><i class="fas fa-sign-out-alt"></i> Cerrar Sesión</a></li>
    </ul>
</div>


    <div class="main-content">
        <h1>Asignar privilegios a personal de RRHH</h1>

        <?php if ($result->num_rows === 0): ?>
            <p>No hay usuarios con rol RRHH_Consulta (11) en la unidad 2.</p>
        <?php else: ?>
            <table>
                <thead>
                    <tr>
                        <th>Nombre</th>
                        <th>Apellido</th>
                        <th>Acción</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($user = $result->fetch_assoc()): ?>
                        <tr>
                            <td><?= htmlspecialchars($user['Nom'] . ' ' . $user['Nom2']) ?></td>
                            <td><?= htmlspecialchars($user['Ape'] . ' ' . $user['Ape2']) ?></td>
                            <td>
                                <form method="POST" onsubmit="return confirm('¿Seguro que deseas asignar rol completo RRHH (9) a este usuario?');">
                                    <input type="hidden" name="user_id" value="<?= $user['ID'] ?>">
                                    <button type="submit">Asignar Privilegios</button>
                                </form>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        <?php endif; ?>
    </div>
</div>

<script>
    function toggleSidebar() {
        const sidebar = document.getElementById('sidebar');
        sidebar.classList.toggle('open');
    }
</script>
</body>
</html>
