<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
session_start();

// Conexión a la base de datos
require_once 'conexion.php';

// Crear conexión
$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die("Conexión fallida: " . $conn->connect_error);
}

// Validar que se haya enviado el formulario con datos de usuario y contraseña
if (!isset($_POST['username'], $_POST['PASSWORD'])) {
    header('Location: login.php'); // Cambiado de index.php a login.php
    exit();
}

// Preparar y ejecutar consulta para obtener los datos del usuario, incluyendo cod_rol
if ($stmt = $conn->prepare('SELECT ID, PASSWORD, cod_rol, EstadoCuenta, theme, Nom 
                           FROM accounts 
                           WHERE username = ?')) {
    $stmt->bind_param('s', $_POST['username']);
    $stmt->execute();
    $stmt->store_result();
    
    if ($stmt->num_rows > 0) {
        $stmt->bind_result($id, $stored_password, $cod_rol, $EstadoCuenta, $theme, $Nom);
        if ($stmt->fetch()) {
            // Verificar si la contraseña ingresada coincide con la almacenada
            if (password_verify($_POST['PASSWORD'], $stored_password)) {
                // Contraseña correcta (cuando la contraseña está en formato hash)
                // Verificar el estado de la cuenta
                if ($EstadoCuenta !== 'Activa') {
                    $_SESSION['error'] = 'Su cuenta no está activa. Estado actual: ' . $EstadoCuenta . '. Por favor, contacte al administrador.';
                    header('Location: login.php'); // Cambiado de index.php a login.php
                    exit();
                }

                // La conexión fue exitosa, se crea la sesión
                session_regenerate_id();
                $_SESSION['loggedin'] = TRUE;
                $_SESSION['Nom'] = $Nom;
                $_SESSION['name'] = $_POST['username'];
                $_SESSION['id'] = $id;
                $_SESSION['user_id'] = $id;
                $_SESSION['role'] = $cod_rol;
                $_SESSION['EstadoCuenta'] = $EstadoCuenta;
                $_SESSION['theme'] = $theme;

                // Redirigir según el cod_rol
                if ($cod_rol == 7) {
                    header('Location: dashboard_usuario.php');
                } elseif ($cod_rol == 8) {
                    header('Location: dashboard_jefe.php');
                }  elseif ($cod_rol == 9 || $cod_rol == 11) {
                    header('Location: dashboard_rrhh.php');
                } elseif ($cod_rol == 12) {
                    header('Location: dashboard_directora.php');
                }
                 else {
                    $_SESSION['error'] = 'Rol no reconocido. Contacte al administrador.';
                    header('Location: login.php'); // Cambiado de index.php a login.php
                    exit();
                }
                exit();
            } else {
                // Intentar con contraseña en texto plano
                if ($_POST['PASSWORD'] === $stored_password) {
                    // Contraseña correcta (cuando la contraseña está en texto plano)
                    // Verificar el estado de la cuenta
                    if ($EstadoCuenta !== 'Activa') {
                        $_SESSION['error'] = 'Su cuenta no está activa. Estado actual: ' . $EstadoCuenta . '. Por favor, contacte al administrador.';
                        header('Location: login.php'); // Cambiado de index.php a login.php
                        exit();
                    }

                    // La conexión fue exitosa, se crea la sesión
                    session_regenerate_id();
                    $_SESSION['loggedin'] = TRUE;
                    $_SESSION['Nom'] = $Nom;
                    $_SESSION['name'] = $_POST['username'];
                    $_SESSION['id'] = $id;
                    $_SESSION['user_id'] = $id;
                    $_SESSION['role'] = $cod_rol;
                    $_SESSION['EstadoCuenta'] = $EstadoCuenta;
                    $_SESSION['theme'] = $theme;

                    // Redirigir según el cod_rol
                    if ($cod_rol == 7) {
                        header('Location: dashboard_usuario.php');
                    } elseif ($cod_rol == 8) {
                        header('Location: dashboard_jefe.php');
                    } elseif ($cod_rol == 9 || $cod_rol == 11) {
                        header('Location: dashboard_rrhh.php');
                    } elseif ($cod_rol == 12) {
                        header('Location: dashboard_directora.php');
                    } 
                    else {
                        $_SESSION['error'] = 'Rol no reconocido. Contacte al administrador.';
                        header('Location: login.php'); // Cambiado de index.php a login.php
                        exit();
                    }
                    exit();
                } else {
                    // Contraseña incorrecta (ambos formatos)
                    $_SESSION['error'] = 'Contraseña incorrecta';
                    header('Location: login.php'); // Cambiado de index.php a login.php
                    exit();
                }
            }
        } else {
            // Usuario no encontrado
            $_SESSION['error'] = 'Usuario no encontrado';
            header('Location: login.php'); // Cambiado de index.php a login.php
            exit();
        }
    } else {
        // Usuario no encontrado
        $_SESSION['error'] = 'Usuario no encontrado';
        header('Location: login.php'); // Cambiado de index.php a login.php
        exit();
    }
} else {
    // Error en la consulta SQL
    $_SESSION['error'] = 'Error al procesar la consulta';
    header('Location: login.php'); // Cambiado de index.php a login.php
    exit();
}

$stmt->close();
$conn->close();
?>