<?php
session_start();
require 'conexion.php';

// Verificar autenticación
if (!isset($_SESSION['user_id'])) {
    $_SESSION['error'] = 'Debes iniciar sesión para ver tu perfil.';
    header("Location: login.php");
    exit;
}

// Obtener datos del usuario con JOIN a unidad
$user_id = $_SESSION['user_id'];
$sql = "SELECT a.Nom, a.Nom2, a.Ape, a.Ape2, a.CorreoElectronico, a.Avatar, a.cod_unidad, u.nombre_unidad 
        FROM accounts a 
        LEFT JOIN unidad u ON a.cod_unidad = u.cod_unidad 
        WHERE a.ID = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param('i', $user_id);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();
$stmt->close();
$conn->close();

if (!$user) {
    $_SESSION['error'] = 'Usuario no encontrado.';
    header("Location: login.php");
    exit;
}

$nombre_completo = trim("{$user['Nom']} {$user['Nom2']} {$user['Ape']} {$user['Ape2']}");
$nombre_completo = preg_replace('/\s+/', ' ', $nombre_completo); // Eliminar espacios múltiples
$avatar_value = $user['Avatar'] ?: 'default_' . $user_id; // Usar ID si no hay Avatar
$avatar_params = explode('|', $avatar_value); // Separar parámetros si existen
$seed = $avatar_params[0] ?? 'default_' . $user_id;
$color = $avatar_params[1] ?? 'blue';
$shape = $avatar_params[2] ?? 'circle';
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Perfil de Usuario</title>
    <style>
        body {
            font-family: sans-serif;
            display: flex;
            flex-direction: column;
            align-items: center;
            margin-top: 50px;
            background-color: #f4f7fa;
        }
        .profile-card {
            border: 1px solid #ccc;
            padding: 30px;
            border-radius: 12px;
            text-align: center;
            width: 300px;
            background-color: white;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }
        .avatar {
            width: 150px;
            height: 150px;
            border-radius: 50%;
            margin-bottom: 15px;
            border: 2px solid #4CAF50;
            transition: transform 0.3s;
        }
        .avatar:hover {
            transform: scale(1.05);
        }
        button {
            margin-top: 10px;
            padding: 8px 16px;
            border: none;
            border-radius: 6px;
            background-color: #4CAF50;
            color: white;
            cursor: pointer;
            transition: background 0.3s;
        }
        button:hover {
            background-color: #45a049;
        }
        .custom-seed {
            margin-top: 10px;
            padding: 8px;
            width: 100%;
            border: 1px solid #ddd;
            border-radius: 6px;
        }
        .custom-options {
            margin-top: 10px;
            text-align: left;
        }
        .custom-options select {
            margin: 5px 0;
            padding: 5px;
            width: 100%;
            border: 1px solid #ddd;
            border-radius: 6px;
        }
        .message {
            margin-top: 10px;
            padding: 10px;
            border-radius: 4px;
            display: none;
        }
        .success { background-color: #dff0d8; color: #3c763d; }
        .error { background-color: #f2dede; color: #a94442; }
    </style>
</head>
<body>
    <div class="profile-card">
        <img id="avatar" class="avatar" alt="Avatar de <?= htmlspecialchars($nombre_completo) ?>">
        <h2 id="username"><?= htmlspecialchars($nombre_completo) ?></h2>
        <p>Email: <span id="email"><?= htmlspecialchars($user['CorreoElectronico']) ?></span></p>
        <p>Unidad: <span id="unidad"><?= htmlspecialchars($user['nombre_unidad'] ?? 'Sin unidad asignada') ?></span></p>
        <div class="custom-options">
            <label for="customSeed">Seed Personalizada:</label>
            <input type="text" id="customSeed" class="custom-seed" value="<?= htmlspecialchars($seed) ?>">
            <label for="color">Color:</label>
            <select id="color">
                <option value="blue" <?= $color == 'blue' ? 'selected' : '' ?>>Azul</option>
                <option value="red" <?= $color == 'red' ? 'selected' : '' ?>>Rojo</option>
                <option value="green" <?= $color == 'green' ? 'selected' : '' ?>>Verde</option>
                <option value="yellow" <?= $color == 'yellow' ? 'selected' : '' ?>>Amarillo</option>
            </select>
            <label for="shape">Forma:</label>
            <select id="shape">
                <option value="circle" <?= $shape == 'circle' ? 'selected' : '' ?>>Círculo</option>
                <option value="square" <?= $shape == 'square' ? 'selected' : '' ?>>Cuadrado</option>
                <option value="triangle" <?= $shape == 'triangle' ? 'selected' : '' ?>>Triángulo</option>
            </select>
        </div>
        <button onclick="guardarAvatar()">Guardar Avatar</button>
        <button onclick="generarNuevoAvatar()">Generar Nuevo Avatar</button>
        <div id="message" class="message"></div>
    </div>

    <script>
        const avatarImg = document.getElementById("avatar");
        const avatarBaseUrl = "https://api.dicebear.com/7.x/bottts/svg?seed=";
        const messageDiv = document.getElementById("message");
        const customSeedInput = document.getElementById("customSeed");
        const colorSelect = document.getElementById("color");
        const shapeSelect = document.getElementById("shape");

        function mostrarMensaje(type, text) {
            messageDiv.textContent = text;
            messageDiv.className = `message ${type}`;
            messageDiv.style.display = 'block';
            setTimeout(() => messageDiv.style.display = 'none', 3000);
        }

        function actualizarAvatar(seed, color, shape) {
            const fullUrl = `${avatarBaseUrl}${encodeURIComponent(seed)}&color=${color}&shape=${shape}&t=${Date.now()}`;
            avatarImg.src = fullUrl;
        }

        function generarNuevoAvatar() {
            const nuevaSeed = Math.random().toString(36).substring(2, 10);
            const color = colorSelect.value;
            const shape = shapeSelect.value;
            actualizarAvatar(nuevaSeed, color, shape);
            customSeedInput.value = nuevaSeed; // Sugiere la nueva seed
        }

        function guardarAvatar() {
            const seed = customSeedInput.value.trim();
            const color = colorSelect.value;
            const shape = shapeSelect.value;

            if (!seed) {
                mostrarMensaje('error', 'Por favor, ingresa una seed.');
                return;
            }

            const avatarData = `${seed}|${color}|${shape}`;
            fetch('guardar_avatar.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: `user_id=<?= $_SESSION['user_id'] ?>&avatar=${encodeURIComponent(avatarData)}`
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    actualizarAvatar(seed, color, shape);
                    mostrarMensaje('success', 'Avatar guardado con éxito.');
                } else {
                    mostrarMensaje('error', data.error || 'Error al guardar el avatar.');
                }
            })
            .catch(() => mostrarMensaje('error', 'Error de conexión.'));
        }

        // Inicializar con la seed del usuario
        actualizarAvatar('<?= htmlspecialchars($seed) ?>', '<?= htmlspecialchars($color) ?>', '<?= htmlspecialchars($shape) ?>');
    </script>
</body>
</html>