<?php
session_start();
require 'conexion.php';

if (!isset($_SESSION['user_id']) || !isset($_SESSION['role'])) {
    header('Location: login.php');
    exit;
}

$user_id = $_SESSION['user_id'];
$role    = $_SESSION['role'];

$password = trim($_POST['password'] ?? '');
$confirm  = trim($_POST['confirm_password'] ?? '');

if ($password !== $confirm) {
    redirigirSegunRol($role, "error=nomatch");
}

if (strlen($password) < 6) {
    redirigirSegunRol($role, "error=short");
}

$hashedPassword = password_hash($password, PASSWORD_DEFAULT);

$sql = "UPDATE accounts SET password=? WHERE id=?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("si", $hashedPassword, $user_id);

if ($stmt->execute()) {
    redirigirSegunRol($role, "success=password");
} else {
    redirigirSegunRol($role, "error=fail");
}

$stmt->close();
$conn->close();

/**
 * Función que redirige al dashboard correcto según el rol
 */
function redirigirSegunRol($role, $query)
{
    switch ($role) {
        case 7: // Usuario normal
            header("Location: dashboard_usuario.php?$query");
            break;
        case 8: // Jefe
            header("Location: dashboard_jefe.php?$query");
            break;
        case 9: // RRHH
        case 11: // Otro rol de RRHH
            header("Location: dashboard_rrhh.php?$query");
            break;
        default: // Rol no esperado
            header("Location: login.php");
            break;
    }
    exit;
}
