<?php
session_start();
require 'conexion.php';

if (!isset($_SESSION['user_id']) || ($_SESSION['role'] != 9 && $_SESSION['role'] != 11)) {
    header("Location: login.php");
    exit;
}

$nombre_usuario = $_SESSION['Nom'];
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard RRHH</title>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        * { box-sizing: border-box; }
        body {
            margin: 0;
            font-family: 'Roboto', sans-serif;
            background: #ecf0f1;
            color: #2c3e50;
        }
        .container { display: flex; min-height: 100vh; }

        /* Menú lateral */
        .sidebar {
            width: 250px; background: linear-gradient(135deg, #2c3e50, #34495e);
            color: white; padding: 20px 15px; position: fixed; height: 100%;
            box-shadow: 2px 0 5px rgba(0, 0, 0, 0.1); transition: transform 0.3s ease; z-index: 1000;
        }
        .sidebar.collapsed { transform: translateX(-250px); width: 0; }
        .sidebar h2 { font-size: 24px; margin-bottom: 30px; text-align: center; color: #68c8d8; font-weight: 700; }
        .sidebar ul { list-style: none; padding: 0; }
        .sidebar ul li { margin-bottom: 15px; }
        .sidebar ul li a {
            color: #ecf0f1; text-decoration: none; font-size: 16px; display: flex; align-items: center;
            padding: 10px 15px; border-radius: 5px; transition: background 0.3s, color 0.3s;
        }
        .sidebar ul li a:hover { background: #465c71; color: #68c8d8; }
        .sidebar ul li a i { margin-right: 10px; font-size: 16px; }

        .toggle-btn {
            display: none; position: fixed; left: 10px; top: 10px; background: #68c8d8; color: white;
            border: none; padding: 10px; border-radius: 5px; cursor: pointer; z-index: 1001; transition: background 0.3s;
        }
        .toggle-btn:hover { background: #5dade2; }

        @media (max-width: 1024px) {
            .sidebar { width: 220px; }
            .main { margin-left: 220px; padding: 25px; }
        }
        @media (max-width: 768px) {
            .toggle-btn { display: block; }
            .sidebar { transform: translateX(-250px); width: 250px; }
            .sidebar.open { transform: translateX(0); }
            .main { margin-left: 0; padding: 20px; }
        }

        .main { flex: 1; padding: 40px; margin-left: 250px; transition: margin-left 0.3s ease; }
        h1 { font-size: 28px; margin-bottom: 30px; }

        form {
            display: flex; flex-wrap: wrap; gap: 15px; margin-bottom: 20px; align-items: center;
        }
        select, input[type="date"], button {
            padding: 8px 12px; border: 1px solid #ccc; border-radius: 6px; font-size: 14px;
        }
        button { background-color: #3498db; color: white; border: none; cursor: pointer; transition: background 0.3s; }
        button:hover { background-color: #2980b9; }

        canvas {
            background: #fff; border-radius: 12px; padding: 20px; box-shadow: 0 0 10px rgba(0,0,0,0.1); margin-bottom: 20px;
        }

        table {
            width: 100%; border-collapse: collapse; background: #fff; border-radius: 12px; overflow: hidden;
            box-shadow: 0 0 10px rgba(0,0,0,0.1); max-height: 300px; display: block; overflow-x: auto;
        }
        thead {
            background-color: #3498db; color: white; position: sticky; top: 0; z-index: 1;
        }
        th, td { padding: 12px; text-align: left; border-bottom: 1px solid #ddd; white-space: nowrap; }
        th { background-color: #3498db; color: white; position: sticky; top: 0; }

        tbody { display: block; max-height: 250px; overflow-y: auto; }
        tr { display: table; width: 100%; table-layout: fixed; }

        /* Anchos por columna: ajustados a 8 columnas */
        th:nth-child(1), td:nth-child(1) { width: 20%; } /* Nombre empleado */
        th:nth-child(2), td:nth-child(2) { width: 12%; } /* Fecha solicitud */
        th:nth-child(3), td:nth-child(3) { width: 12%; } /* Tipo permiso */
        th:nth-child(4), td:nth-child(4) { width: 12%; } /* Fecha salida (solicitudes) */
        th:nth-child(5), td:nth-child(5) { width: 12%; } /* Horario Permiso */
        th:nth-child(6), td:nth-child(6) { width: 12%; } /* Fecha Inicio (vacaciones) */
        th:nth-child(7), td:nth-child(7) { width: 12%; } /* Fecha Fin (vacaciones) */
        th:nth-child(8), td:nth-child(8) { width: 8%; }  /* Días (vacaciones) */
        th:nth-child(9), td:nth-child(9) { width: 12%; } /* Estado */

        tr:nth-child(even) { background-color: #f8f9fa; }
        tr:hover { background-color: #e9ecef; }

        @media (max-width: 480px) {
            .main { padding: 15px; }
            h1 { font-size: 22px; }
            form { flex-direction: column; align-items: stretch; }
            select, input[type="date"], button { padding: 6px 10px; font-size: 12px; }
            table { font-size: 12px; }
            th, td { padding: 6px; }
            tbody { max-height: 150px; }
        }
    </style>
</head>
<body>
<div class="container">
    <!-- Menú lateral -->
    <div class="sidebar" id="sidebar">
        <h2>Panel RRHH</h2>
        <ul>
            <li><a href="dashboard_rrhh.php"><i class="fas fa-home"></i> Inicio</a></li>
            <?php if ($_SESSION['role'] != 11): ?>
                <li><a href="gestionar_solicitudes_rrhh.php"><i class="fas fa-tasks"></i> Gestionar Solicitudes</a></li>
            <?php endif; ?>
            <li><a href="panel_jefe_rrhh.php"><i class="fas fa-chart-bar"></i>Solicitudes Unidad RRHH</a></li>
            <li><a href="panel_rrhh_vacaciones.php"><i class="fas fa-chart-bar"></i>Solicitudes Vacaciones RRHH</a></li>
            <li><a href="estadisticas_rrhh.php"><i class="fas fa-chart-bar"></i> Estadísticas</a></li>
            <li><a href="solicitudes_aprobadas_rrhh.php"><i class="fas fa-check"></i> Historial de Solicitudes Aprobadas</a></li>
            <li><a href="ver_solicitudes.php"><i class="fas fa-eye"></i> Más Solicitudes</a></li>
            <?php if ($_SESSION['role'] != 11): ?>
                <li><a href="gestionar_empleados.php"><i class="fas fa-users"></i> Gestión de Empleados</a></li>
            <?php endif; ?>
            <li><a href="panel_vacaciones_rrhh.php"><i class="fas fa-umbrella-beach"></i> Gestión de Vacaciones</a></li>
            <?php if ($_SESSION['role'] != 11): ?>
                <li><a href="gestionar_unidades_puestos.php"><i class="fas fa-building"></i> Unidades y Puestos</a></li>
                <li><a href="asignar_privilegios_rrhh.php"><i class="fas fa-user-shield"></i> Asignar Rol</a></li>
            <?php endif; ?>

            <!-- ✅ NUEVO: acceso directo al Portal de Denuncias -->
            <li>
                <a href="https://sistemas.proasol.gob.hn/denuncias_proasol/index.html?src=rrhh_sidebar"
                   target="_blank" rel="noopener">
                   <i class="fas fa-shield-alt"></i> Denuncia-CPEP
                </a>
            </li>

            <li><a href="panel_rrhh_user.php"><i class="fas fa-user"></i> Perfil</a></li>
            <li><a href="logout.php"><i class="fas fa-sign-out-alt"></i> Cerrar Sesión</a></li>
        </ul>
    </div>

    <div class="main">
        <h1>Dashboard Dinámico</h1>

        <form id="filtroForm">
            <label>Unidad:
                <select id="unidad" name="unidad">
                    <option value="">Todas</option>
                    <?php
                    $q = $conn->query("SELECT cod_unidad, nombre_unidad FROM unidad ORDER BY nombre_unidad");
                    while ($row = $q->fetch_assoc()) {
                        echo "<option value='{$row['cod_unidad']}'>{$row['nombre_unidad']}</option>";
                    }
                    ?>
                </select>
            </label>
            <label>Empleado:
                <select id="empleado" name="empleado">
                    <option value="">Todos</option>
                </select>
            </label>
            <label>Fecha Inicio:
                <input type="date" name="fecha_inicio" id="fecha_inicio">
            </label>
            <label>Fecha Fin:
                <input type="date" name="fecha_fin" id="fecha_fin">
            </label>
            <button type="submit">Aplicar Filtros</button>
        </form>

        <button id="exportExcel" style="margin-bottom: 20px;">Exportar a Excel</button>

        <canvas id="filtroChart" width="400" height="140"></canvas>

        <table id="solicitudesTable">
            <thead>
                <tr>
                    <th>Nombre del Empleado</th>
                    <th>Fecha Solicitud</th>
                    <th>Tipo Permiso</th>
                    <th>Fecha Salida</th>
                    <th>Horario Permiso</th>
                    <th>Fecha Inicio</th>
                    <th>Fecha Fin</th>
                    <th>Días</th>
                    <th>Estado</th>
                </tr>
            </thead>
            <tbody></tbody>
        </table>

    </div>
</div>

<script>
let filtroChart;

function cargarTotalesIniciales() {
    fetch('get_datos_filtrados.php')
        .then(r => r.json())
        .then(res => {
            renderChart(res.labels, res.data);
            actualizarTabla();
        });
}

function renderChart(labels, data) {
    if (filtroChart) filtroChart.destroy();
    const ctx = document.getElementById('filtroChart').getContext('2d');
    filtroChart = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: labels,
            datasets: [{
                label: 'Aprobadas por RRHH',
                data: data,
                backgroundColor: ['#3498db', '#27ae60'],
                borderRadius: 6,
                borderSkipped: false
            }]
        },
        options: {
            responsive: true,
            scales: { y: { beginAtZero: true } },
            plugins: { legend: { display: true } }
        }
    });
}

function actualizarTabla() {
    const datos = new FormData(document.getElementById('filtroForm'));
    fetch('get_solicitudes_filtradas.php', {
        method: 'POST',
        body: datos
    })
    .then(r => r.json())
    .then(res => {
        const tbody = document.querySelector('#solicitudesTable tbody');
        tbody.innerHTML = '';
        res.forEach(row => {
            const tr = document.createElement('tr');
            tr.innerHTML = `
                <td>${row.nombre_empleado}</td>
                <td>${row.fecha_solicitud || '---'}</td>
                <td>${row.tipo_permiso || '---'}</td>
                <td>${row.fecha_salida || '---'}</td>
                <td>${row.horario_permiso || '---'}</td>
                <td>${row.fecha_inicio || '---'}</td>
                <td>${row.fecha_fin || '---'}</td>
                <td>${row.dias ?? '---'}</td>
                <td>${row.estado || '---'}</td>
            `;
            tbody.appendChild(tr);
        });
    });
}

document.getElementById('unidad').addEventListener('change', function () {
    let unidad = this.value;
    let empleado = document.getElementById('empleado');
    empleado.innerHTML = '<option value="">Todos</option>';
    if (unidad) {
        fetch('get_empleados_por_unidad.php?cod_unidad=' + unidad)
            .then(res => res.json())
            .then(data => {
                data.forEach(e => {
                    let opt = document.createElement('option');
                    opt.value = e.ID;
                    opt.textContent = e.nombre;
                    empleado.appendChild(opt);
                });
            });
    }
    actualizarTabla();
});

document.getElementById('empleado').addEventListener('change', actualizarTabla);

document.getElementById('filtroForm').addEventListener('submit', function (e) {
    e.preventDefault();
    const datos = new FormData(this);
    fetch('get_datos_filtrados.php', {
        method: 'POST',
        body: datos
    })
    .then(r => r.json())
    .then(res => {
        renderChart(res.labels, res.data);
        actualizarTabla();
    });
});

// ✅ Exportar a Excel sin que se desfasen las fechas (raw:true)
document.getElementById('exportExcel').addEventListener('click', function () {
    const tabla = document.getElementById('solicitudesTable');

    // Crear un libro nuevo
    const wb = XLSX.utils.book_new();
    // Crear hoja desde la tabla, sin interpretación automática de tipos
    const ws = XLSX.utils.table_to_sheet(tabla, { raw: true });

    XLSX.utils.book_append_sheet(wb, ws, "Solicitudes");

    XLSX.writeFile(
        wb,
        'Reporte_Solicitudes_' + new Date().toISOString().slice(0, 10) + '.xlsx'
    );
});

window.addEventListener('DOMContentLoaded', cargarTotalesIniciales);

function toggleSidebar() {
    const sidebar = document.getElementById('sidebar');
    sidebar.classList.toggle('open');
    const main = document.querySelector('.main');
    if (sidebar.classList.contains('open')) {
        main.style.marginLeft = '250px';
    } else {
        main.style.marginLeft = '0';
    }
}
</script>
</body>
</html>
<?php $conn->close(); ?>
