<?php
include 'conexion.php'; // Tu archivo de conexión a la base de datos

function generarPeriodosVacaciones($conexion) {
    $hoy = new DateTime();

    // Obtener empleados activos
    $query = $conexion->query("SELECT id_usuario, fecha_ingreso, tipo_acuerdo FROM empleados");

    while ($empleado = $query->fetch(PDO::FETCH_ASSOC)) {
        $id = $empleado['id_usuario'];
        $fechaIngreso = new DateTime($empleado['fecha_ingreso']);
        $tipo = strtolower($empleado['tipo_acuerdo']);

        if ($tipo === 'acuerdo') {
            // Generar periodo anual de 15 días por cada aniversario no registrado
            $anios = $fechaIngreso->diff($hoy)->y;
            for ($i = 0; $i < $anios; $i++) {
                $inicio = (clone $fechaIngreso)->modify("+$i year");
                $fin = (clone $inicio)->modify("+1 year");
                $vence = (clone $inicio)->modify("+3 year");

                // Verificar si ya existe ese periodo
                $existe = $conexion->prepare("SELECT COUNT(*) FROM vacaciones_periodos WHERE empleado_id = ? AND fecha_inicio = ?");
                $existe->execute([$id, $inicio->format('Y-m-d')]);
                if ($existe->fetchColumn() == 0) {
                    $stmt = $conexion->prepare("INSERT INTO vacaciones_periodos 
                        (empleado_id, fecha_inicio, fecha_fin, dias_generados, fecha_vencimiento, tipo_periodo)
                        VALUES (?, ?, ?, ?, ?, ?)");
                    $stmt->execute([
                        $id,
                        $inicio->format('Y-m-d'),
                        $fin->format('Y-m-d'),
                        15,
                        $vence->format('Y-m-d'),
                        'anual'
                    ]);
                }
            }

        } elseif ($tipo === 'contrato') {
            // Generar periodo semestral de 6 días cada 6 meses
            $mesesTrabajados = $fechaIngreso->diff($hoy)->y * 12 + $fechaIngreso->diff($hoy)->m;
            $periodos = floor($mesesTrabajados / 6);

            for ($i = 0; $i < $periodos; $i++) {
                $inicio = (clone $fechaIngreso)->modify("+" . ($i * 6) . " months");
                $fin = (clone $inicio)->modify("+6 months");

                $existe = $conexion->prepare("SELECT COUNT(*) FROM vacaciones_periodos WHERE empleado_id = ? AND fecha_inicio = ?");
                $existe->execute([$id, $inicio->format('Y-m-d')]);
                if ($existe->fetchColumn() == 0) {
                    $stmt = $conexion->prepare("INSERT INTO vacaciones_periodos 
                        (empleado_id, fecha_inicio, fecha_fin, dias_generados, fecha_vencimiento, tipo_periodo)
                        VALUES (?, ?, ?, ?, ?, ?)");
                    $stmt->execute([
                        $id,
                        $inicio->format('Y-m-d'),
                        $fin->format('Y-m-d'),
                        6,
                        $fin->format('Y-m-d'), // Vence al finalizar el contrato
                        'semestral'
                    ]);
                }
            }
        }
    }

    echo "Periodos generados correctamente.";
}

// Ejecutar
generarPeriodosVacaciones($conexion);
?>
