<?php
session_start();
require 'conexion.php';

/* ===== Depuración útil para ver el error real si aparece 500 ===== */
mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
/* ================================================================= */

if (!isset($_SESSION['user_id']) || $_SESSION['role'] != 9) {
    header("Location: login.php");
    exit;
}

$nombre_usuario = $_SESSION['Nom'];
$mensaje = '';

/* Estado base del empleado (llaves incluidas) */
$empleado = [
    'ID' => '',
    'username' => '',
    'Nom' => '',
    'Nom2' => '',
    'Ape' => '',
    'Ape2' => '',
    'FechaNacimiento' => '',
    'CorreoElectronico' => '',
    'password' => '',
    'genero' => '',
    'role' => '',
    'cod_rol' => '',
    'cod_unidad' => '',
    'cod_jefe' => '',
    'cod_puesto' => '',
    'tipo_contrato' => ''
];

/* ========= CARGAR OPCIONES PARA SELECTS (FKs) ========= */
$unidades = [];
$jefes    = [];
$puestos  = [];

$res = $conn->query("SELECT cod_unidad, nombre_unidad FROM unidad ORDER BY nombre_unidad ASC");
while ($r = $res->fetch_assoc()) { $unidades[] = $r; }
$res->close();

$res = $conn->query("SELECT cod_jefe, nombre_jefe FROM jefes ORDER BY nombre_jefe ASC");
while ($r = $res->fetch_assoc()) { $jefes[] = $r; }
$res->close();

$res = $conn->query("SELECT cod_puesto, nombre_puesto FROM puestos ORDER BY nombre_puesto ASC");
while ($r = $res->fetch_assoc()) { $puestos[] = $r; }
$res->close();
/* ====================================================== */

/* ====== CARGA PARA EDITAR ====== */
if (isset($_GET['id']) && is_numeric($_GET['id'])) {
    $id = (int)$_GET['id'];
    $stmt = $conn->prepare("SELECT * FROM accounts WHERE ID = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($row = $result->fetch_assoc()) {
        $empleado = array_merge($empleado, $row);
        // Compatibilidad: si la BD guarda cod_rol y tu formulario usa 'role'
        if (empty($empleado['role']) && !empty($empleado['cod_rol'])) {
            $empleado['role'] = $empleado['cod_rol'];
        }
    }
    $stmt->close();
}

/* ====== GUARDAR (INSERT/UPDATE) ====== */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = isset($_POST['id']) && is_numeric($_POST['id']) ? (int)$_POST['id'] : null;

    $username        = trim($_POST['username'] ?? '');
    $nom             = trim($_POST['Nom'] ?? '');
    $nom2            = trim($_POST['Nom2'] ?? '');
    $ape             = trim($_POST['Ape'] ?? '');
    $ape2            = trim($_POST['Ape2'] ?? '');
    $FechaNacimiento = trim($_POST['FechaNacimiento'] ?? '');
    $email           = trim($_POST['email'] ?? '');
    $genero          = trim($_POST['genero'] ?? '');
    $role            = (int)($_POST['role'] ?? 0);

    // FKs (INT)
    $cod_unidad     = isset($_POST['cod_unidad']) ? (int)$_POST['cod_unidad'] : 0;
    $cod_jefe       = isset($_POST['cod_jefe']) ? (int)$_POST['cod_jefe'] : 0;
    $cod_puesto     = isset($_POST['cod_puesto']) ? (int)$_POST['cod_puesto'] : 0;

    // Tipo de contrato
    $tipo_contrato  = $_POST['tipo_contrato'] ?? '';

    // Contraseña
    $nuevoPasswordPlano = trim($_POST['password'] ?? '');
    $password = $empleado['password']; // valor actual (si estamos en edición)
    if ($nuevoPasswordPlano !== '') {
        $password = password_hash($nuevoPasswordPlano, PASSWORD_DEFAULT);
    } elseif (!$id) {
        // En creación, contraseña es obligatoria
        $mensaje = "Para crear un empleado debes ingresar una contraseña.";
    }

    // Validación de selects fijos
    $tipoContratoValido = in_array($tipo_contrato, ['Contrato', 'Acuerdo de Permanencia'], true);

    $camposObligatoriosOk =
        empty($mensaje) &&
        $username !== '' && $nom !== '' && $ape !== '' &&
        $email !== '' && $FechaNacimiento !== '' && $genero !== '' &&
        in_array($role, [7, 8, 9], true) &&
        $cod_unidad > 0 && $cod_jefe > 0 && $cod_puesto > 0 &&
        $tipoContratoValido;

    if ($camposObligatoriosOk) {
        // Verificar unicidad de username si es INSERT o si cambió
        if (!$id || $username !== ($empleado['username'] ?? '')) {
            $stmt = $conn->prepare("SELECT ID FROM accounts WHERE username = ? LIMIT 1");
            $stmt->bind_param("s", $username);
            $stmt->execute();
            $stmt->store_result();
            if ($stmt->num_rows > 0) {
                $mensaje = "El nombre de usuario ya está en uso. Elija otro.";
            }
            $stmt->close();
        }

        if (empty($mensaje)) {
            if ($id) {
                // ===== UPDATE =====
                $stmt = $conn->prepare("
                    UPDATE accounts
                    SET username = ?, Nom = ?, Nom2 = ?, Ape = ?, Ape2 = ?,
                        FechaNacimiento = ?, CorreoElectronico = ?, password = ?,
                        genero = ?, cod_rol = ?,
                        cod_unidad = ?, cod_jefe = ?, cod_puesto = ?, tipo_contrato = ?
                    WHERE ID = ?
                ");
                // 9s + 4i + 1s + 1i => "sssssssssiiiisi"
                $stmt->bind_param(
                    "sssssssssiiiisi",
                    $username, $nom, $nom2, $ape, $ape2,
                    $FechaNacimiento, $email, $password,
                    $genero, $role,
                    $cod_unidad, $cod_jefe, $cod_puesto, $tipo_contrato,
                    $id
                );
                $stmt->execute();
                $mensaje = "Empleado actualizado exitosamente.";
                $stmt->close();
            } else {
                // ===== INSERT ===== (requiere password no vacío)
                $stmt = $conn->prepare("
                    INSERT INTO accounts
                    (username, Nom, Nom2, Ape, Ape2, FechaNacimiento, CorreoElectronico, password, genero, cod_rol,
                     cod_unidad, cod_jefe, cod_puesto, tipo_contrato)
                    VALUES
                    (?,?,?,?,?,?,?,?,?,?,?,?,?,?)
                ");
                // 9s + 4i + 1s => "sssssssssiiiis"
                $stmt->bind_param(
                    "sssssssssiiiis",
                    $username, $nom, $nom2, $ape, $ape2,
                    $FechaNacimiento, $email, $password, $genero, $role,
                    $cod_unidad, $cod_jefe, $cod_puesto, $tipo_contrato
                );
                $stmt->execute();
                $mensaje = "Empleado agregado exitosamente.";
                // limpiar formulario
                foreach ($empleado as $k => $_) { $empleado[$k] = ''; }
                $stmt->close();
            }
        }
    } else {
        if (empty($mensaje)) {
            $mensaje = "Complete los campos obligatorios y seleccione opciones válidas (rol, unidad, jefe, puesto y tipo de contrato).";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Gestionar Empleados</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- SweetAlert2 -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        * { box-sizing: border-box; }
        body { margin: 0; font-family: 'Roboto', sans-serif; background: #f4f6f9; color: #333; }
        .container { display: flex; min-height: 100vh; }
        .sidebar { width: 250px; background: linear-gradient(135deg, #2c3e50, #34495e); color: white; padding: 20px 15px; position: fixed; height: 100%; box-shadow: 2px 0 5px rgba(0,0,0,0.1); transition: transform 0.3s ease; z-index: 1000; }
        .sidebar.collapsed { transform: translateX(-250px); width: 0; }
        .sidebar h2 { font-size: 24px; margin-bottom: 30px; text-align: center; color: #68c8d8; font-weight: 700; }
        .sidebar ul { list-style: none; padding: 0; }
        .sidebar ul li { margin-bottom: 15px; }
        .sidebar ul li a { color: #ecf0f1; text-decoration: none; font-size: 16px; display: flex; align-items: center; padding: 10px 15px; border-radius: 5px; transition: background 0.3s, color 0.3s; }
        .sidebar ul li a:hover { background: #465c71; color: #68c8d8; }
        .sidebar ul li a i { margin-right: 10px; font-size: 16px; }
        .toggle-btn { display: none; position: fixed; left: 10px; top: 10px; background: #68c8d8; color: white; border: none; padding: 10px; border-radius: 5px; cursor: pointer; z-index: 1001; transition: background 0.3s; }
        .toggle-btn:hover { background: #5dade2; }
        .main { flex: 1; padding: 40px; margin-left: 250px; transition: margin-left 0.3s ease; }
        h1 { font-size: 28px; margin-bottom: 20px; border-bottom: 2px solid #3498db; padding-bottom: 10px; }
        .form-container { background: #fff; padding: 25px; border-radius: 12px; box-shadow: 0 4px 10px rgba(0,0,0,0.1); max-width: 1000px; display: grid; grid-template-columns: 1fr 1fr; gap: 20px; }
        .form-group { display: flex; flex-direction: column; }
        label { font-weight: 600; margin-bottom: 5px; }
        input[type="text"], input[type="date"], input[type="email"], input[type="password"], select { padding: 10px; border: 1px solid #ddd; border-radius: 6px; font-size: 14px; background: #f9f9f9; }
        button { grid-column: span 2; padding: 12px; background: linear-gradient(90deg, #3498db, #2980b9); color: white; border: none; border-radius: 6px; font-size: 14px; cursor: pointer; margin-top: 10px; }
        @media (max-width: 1024px) { .sidebar { width: 220px; } .main { margin-left: 220px; padding: 25px; } }
        @media (max-width: 768px) {
            .toggle-btn { display: block; } .sidebar { transform: translateX(-250px); width: 250px; } .sidebar.open { transform: translateX(0); }
            .main { margin-left: 0; padding: 20px; } .form-container { grid-template-columns: 1fr; } h1 { font-size: 24px; }
        }
        @media (max-width: 480px) {
            .main { padding: 15px; } h1 { font-size: 20px; } .form-container { padding: 15px; }
            input[type="text"], input[type="date"], input[type="email"], input[type="password"], select { padding: 8px; font-size: 12px; }
            button { padding: 10px; font-size: 12px; }
        }
    </style>
</head>
<body>
<div class="container">
   <div class="sidebar" id="sidebar">
    <h2>Panel RRHH</h2>
    <ul>
        <li><a href="dashboard_rrhh.php"><i class="fas fa-home"></i> Inicio</a></li>
        <?php if ($_SESSION['role'] != 11): ?>
            <li><a href="gestionar_solicitudes_rrhh.php"><i class="fas fa-tasks"></i> Gestionar Solicitudes</a></li>
        <?php endif; ?>
        <li><a href="panel_jefe_rrhh.php"><i class="fas fa-chart-bar"></i>Solicitudes Unidad RRHH</a></li>
        <li><a href="panel_rrhh_vacaciones.php"><i class="fas fa-chart-bar"></i>Solicitudes Vacaciones RRHH</a></li>
        <li><a href="estadisticas_rrhh.php"><i class="fas fa-chart-bar"></i> Estadísticas</a></li>
        <li><a href="solicitudes_aprobadas_rrhh.php"><i class="fas fa-check"></i> Historial de Solicitudes Aprobadas</a></li>
        <li><a href="ver_solicitudes.php"><i class="fas fa-eye"></i> Más Solicitudes</a></li>
        <?php if ($_SESSION['role'] != 11): ?>
            <li><a href="gestionar_empleados.php"><i class="fas fa-users"></i> Gestión de Empleados</a></li>
        <?php endif; ?>
        <li><a href="panel_vacaciones_rrhh.php"><i class="fas fa-umbrella-beach"></i> Gestión de Vacaciones</a></li>
        <?php if ($_SESSION['role'] != 11): ?>
            <li><a href="gestionar_unidades_puestos.php"><i class="fas fa-building"></i> Unidades y Puestos</a></li>
            <li><a href="asignar_privilegios_rrhh.php"><i class="fas fa-user-shield"></i> Asignar Rol</a></li>
        <?php endif; ?>
        <li>
            <a href="https://sistemas.proasol.gob.hn/denuncias_proasol/index.html?src=rrhh_sidebar" target="_blank" rel="noopener">
               <i class="fas fa-shield-alt"></i> Denuncia-CPEP
            </a>
        </li>
        <li><a href="panel_rrhh_user.php"><i class="fas fa-user"></i> Perfil</a></li>
        <li><a href="logout.php"><i class="fas fa-sign-out-alt"></i> Cerrar Sesión</a></li>
    </ul>
</div>

    <div class="main">
        <h1>Gestionar Empleados</h1>
        <form class="form-container" method="POST" action="">
            <input type="hidden" name="id" value="<?= htmlspecialchars($empleado['ID']) ?>">

            <h3 style="grid-column: span 2; color: #3498db;">Datos Personales</h3>

            <div class="form-group">
                <label>Primer Nombre:</label>
                <input type="text" name="Nom" value="<?= htmlspecialchars($empleado['Nom']) ?>" required>
            </div>
            <div class="form-group">
                <label>Segundo Nombre:</label>
                <input type="text" name="Nom2" value="<?= htmlspecialchars($empleado['Nom2']) ?>">
            </div>
            <div class="form-group">
                <label>Primer Apellido:</label>
                <input type="text" name="Ape" value="<?= htmlspecialchars($empleado['Ape']) ?>" required>
            </div>
            <div class="form-group">
                <label>Segundo Apellido:</label>
                <input type="text" name="Ape2" value="<?= htmlspecialchars($empleado['Ape2']) ?>">
            </div>
            <div class="form-group">
                <label>Fecha de Nacimiento:</label>
                <input type="date" name="FechaNacimiento" value="<?= htmlspecialchars($empleado['FechaNacimiento']) ?>" required>
            </div>
            <div class="form-group">
                <label>Género:</label>
                <select name="genero" required>
                    <option value="" disabled <?= empty($empleado['genero']) ? 'selected' : '' ?>>Seleccione</option>
                    <option value="M" <?= ($empleado['genero'] === 'M') ? 'selected' : '' ?>>Masculino</option>
                    <option value="F" <?= ($empleado['genero'] === 'F') ? 'selected' : '' ?>>Femenino</option>
                    <option value="O" <?= ($empleado['genero'] === 'O') ? 'selected' : '' ?>>Otro</option>
                </select>
            </div>

            <h3 style="grid-column: span 2; color: #3498db;">Cuenta</h3>

            <div class="form-group">
                <label>Usuario:</label>
                <input type="text" name="username" value="<?= htmlspecialchars($empleado['username']) ?>" required>
            </div>
            <div class="form-group">
                <label>Email:</label>
                <input type="email" name="email" value="<?= htmlspecialchars($empleado['CorreoElectronico'] ?? '') ?>" required>
            </div>
            <div class="form-group">
                <label>Contraseña:</label>
                <input type="password" name="password" placeholder="Dejar vacío para no cambiar">
            </div>

            <h3 style="grid-column: span 2; color: #3498db;">Rol</h3>

            <div class="form-group">
                <label>Rol:</label>
                <select name="role" required>
                    <option value="" disabled <?= empty($empleado['role']) ? 'selected' : '' ?>>Seleccione un rol</option>
                    <?php
                    $stmt = $conn->prepare("SELECT cod_rol, nombre_rol FROM rol WHERE cod_rol IN (7, 8, 9)");
                    $stmt->execute();
                    $result = $stmt->get_result();
                    while ($row = $result->fetch_assoc()) {
                        $sel = ((string)$empleado['role'] === (string)$row['cod_rol']) ? 'selected' : '';
                        echo "<option value='{$row['cod_rol']}' $sel>".htmlspecialchars($row['nombre_rol'])."</option>";
                    }
                    $stmt->close();
                    ?>
                </select>
            </div>

            <!-- ===================== DATOS LABORALES (FKs) ===================== -->
            <h3 style="grid-column: span 2; color: #3498db;">Datos Laborales</h3>

            <div class="form-group">
                <label>Unidad:</label>
                <select name="cod_unidad" required>
                    <option value="" disabled <?= empty($empleado['cod_unidad']) ? 'selected' : '' ?>>Seleccione la unidad</option>
                    <?php foreach ($unidades as $u): ?>
                        <option value="<?= (int)$u['cod_unidad'] ?>"
                            <?= ((string)$empleado['cod_unidad'] === (string)$u['cod_unidad']) ? 'selected' : '' ?>>
                            <?= htmlspecialchars($u['nombre_unidad']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div class="form-group">
                <label>Jefe Inmediato:</label>
                <select name="cod_jefe" required>
                    <option value="" disabled <?= empty($empleado['cod_jefe']) ? 'selected' : '' ?>>Seleccione el jefe</option>
                    <?php foreach ($jefes as $j): ?>
                        <option value="<?= (int)$j['cod_jefe'] ?>"
                            <?= ((string)$empleado['cod_jefe'] === (string)$j['cod_jefe']) ? 'selected' : '' ?>>
                            <?= htmlspecialchars($j['nombre_jefe']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div class="form-group">
                <label>Puesto:</label>
                <select name="cod_puesto" required>
                    <option value="" disabled <?= empty($empleado['cod_puesto']) ? 'selected' : '' ?>>Seleccione el puesto</option>
                    <?php foreach ($puestos as $p): ?>
                        <option value="<?= (int)$p['cod_puesto'] ?>"
                            <?= ((string)$empleado['cod_puesto'] === (string)$p['cod_puesto']) ? 'selected' : '' ?>>
                            <?= htmlspecialchars($p['nombre_puesto']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div class="form-group">
                <label>Tipo de contrato:</label>
                <select name="tipo_contrato" required>
                    <option value="" disabled <?= empty($empleado['tipo_contrato']) ? 'selected' : '' ?>>Seleccione el tipo</option>
                    <option value="Contrato" <?= ($empleado['tipo_contrato'] === 'Contrato') ? 'selected' : '' ?>>Contrato</option>
                    <option value="Acuerdo de Permanencia" <?= ($empleado['tipo_contrato'] === 'Acuerdo de Permanencia') ? 'selected' : '' ?>>Acuerdo de Permanencia</option>
                </select>
            </div>
            <!-- ================================================================ -->

            <button type="submit"><?= !empty($empleado['ID']) ? 'Actualizar' : 'Guardar' ?></button>
        </form>
    </div>
</div>

<?php if (!empty($mensaje)): ?>
<script>
    Swal.fire({
        icon: '<?= (strpos($mensaje, "exitosamente") !== false) ? "success" : "error" ?>',
        title: '<?= (strpos($mensaje, "exitosamente") !== false) ? "¡Éxito!" : "¡Error!" ?>',
        text: '<?= htmlspecialchars($mensaje) ?>',
        confirmButtonText: 'Aceptar'
    });
</script>
<?php endif; ?>

<script>
function toggleSidebar() {
    const sidebar = document.getElementById('sidebar');
    sidebar.classList.toggle('open');
}
</script>
</body>
</html>
<?php $conn->close(); ?>
