<?php
session_start();
require 'conexion.php';
require 'email_config.php'; // Incluir la configuración de PHPMailer

// Asegurarse de que el usuario esté autenticado y tenga el rol correcto (cod_rol = 9 para RRHH)
if (!isset($_SESSION['user_id']) || !isset($_SESSION['role']) || $_SESSION['role'] != 9) {
    $_SESSION['error'] = 'Acceso no autorizado. Por favor, inicia sesión con una cuenta de Recursos Humanos válida.';
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id'];
$nombre_usuario = $_SESSION['Nom'];

// Obtener solicitudes aprobadas por el jefe, listas para revisión por RRHH
$sql_solicitudes = "SELECT s.id, s.tipo_permiso, s.fecha_solicitud, s.fecha_salida, s.descripcion_motivo, a.Nom, a.Ape, a.cod_unidad, u.nombre_unidad 
                    FROM solicitudes s 
                    JOIN accounts a ON s.id_usuario = a.ID 
                    INNER JOIN unidad u ON a.cod_unidad = u.cod_unidad 
                    WHERE s.estado = 'Aprobada por Jefe Inmediato' 
                    ORDER BY s.fecha_solicitud DESC";

if ($stmt = $conn->prepare($sql_solicitudes)) {
    $stmt->execute();
    $result_solicitudes = $stmt->get_result();
    $stmt->close();
}

// Procesar acciones de aprobar/rechazar
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && isset($_POST['solicitud_id'])) {
    $solicitud_id = (int)$_POST['solicitud_id'];
    $action = $_POST['action'];
    $estado = ($action === 'aprobar') ? 'Aprobada por Recursos Humanos' : 'Rechazada por Recursos Humanos';

    // ✅ NUEVO: comentario final de RRHH (opcional)
    $comentarios_finales = isset($_POST['comentarios_finales']) ? trim($_POST['comentarios_finales']) : null;
    // (Opcional) Limitar longitud para evitar textos excesivos
    if ($comentarios_finales !== null && mb_strlen($comentarios_finales) > 2000) {
        $comentarios_finales = mb_substr($comentarios_finales, 0, 2000);
    }

    // Obtener username y nombre completo de RRHH
    $username_rrhh = '';
    $nombre_rrhh_firma = '';

    $sql_rrhh = "SELECT username, Nom, Nom2, Ape, Ape2 FROM accounts WHERE ID = ?";
    if ($stmt_user = $conn->prepare($sql_rrhh)) {
        $stmt_user->bind_param('i', $_SESSION['user_id']);
        $stmt_user->execute();
        $stmt_user->bind_result($username_rrhh, $nom1, $nom2, $ape1, $ape2);
        $stmt_user->fetch();
        $nombre_rrhh_firma = trim("$nom1 $nom2 $ape1 $ape2");
        $stmt_user->close();
    }

    // Fecha de aprobación por RRHH
    $fecha_aprobacion_rrhh = date('Y-m-d H:i:s');

    // ✅ NUEVO: guardar comentarios_finales junto con el estado
    $sql_update = "UPDATE solicitudes 
                   SET estado = ?, 
                       fecha_aprobacion_rrhh = ?, 
                       firma_rrhh = ?, 
                       nombre_rrhh_firma = ?,
                       comentarios_finales = ?
                   WHERE id = ? AND estado = 'Aprobada por Jefe Inmediato'";

    if ($stmt = $conn->prepare($sql_update)) {
        $stmt->bind_param('sssssi', $estado, $fecha_aprobacion_rrhh, $username_rrhh, $nombre_rrhh_firma, $comentarios_finales, $solicitud_id);
        $stmt->execute();

        // Verificar si la actualización fue exitosa
        if ($stmt->affected_rows > 0) {
            // Obtener información de la solicitud para enviar los correos
            $sql_solicitud = "SELECT s.id_usuario, s.unidad, s.puesto, s.tipo_permiso, s.descripcion_motivo, s.fecha_salida, s.horario_permiso 
                              FROM solicitudes s 
                              WHERE s.id = ?";
            if ($stmt_solicitud = $conn->prepare($sql_solicitud)) {
                $stmt_solicitud->bind_param('i', $solicitud_id);
                $stmt_solicitud->execute();
                $result_solicitud = $stmt_solicitud->get_result();
                $solicitud = $result_solicitud->fetch_assoc();
                $stmt_solicitud->close();

                if ($solicitud) {
                    $id_usuario = $solicitud['id_usuario'];

                    // Obtener el correo y nombre del usuario (solicitante) desde la tabla accounts
                    $sql_usuario = "SELECT CorreoElectronico, Nom, Ape, cod_jefe FROM accounts WHERE ID = ?";
                    if ($stmt_usuario = $conn->prepare($sql_usuario)) {
                        $stmt_usuario->bind_param('i', $id_usuario);
                        $stmt_usuario->execute();
                        $result_usuario = $stmt_usuario->get_result();
                        $solicitante = $result_usuario->fetch_assoc();
                        $stmt_usuario->close();

                        if ($solicitante) {
                            $to_solicitante = $solicitante['CorreoElectronico'];
                            $nombre_solicitante = $solicitante['Nom'] . ' ' . $solicitante['Ape'];
                            $cod_jefe = $solicitante['cod_jefe'];

                            // Enviar correo al solicitante
                            $subject_solicitante = "Actualización de tu Solicitud - ID: {$solicitud_id}";
                            $body_solicitante = "<h2>Hola, {$nombre_solicitante}</h2>
                                                <p>Tu solicitud ha sido revisada por Recursos Humanos.</p>
                                                <p><strong>ID de Solicitud:</strong> {$solicitud_id}</p>
                                                <p><strong>Estado:</strong> {$estado}</p>
                                                <p><strong>Unidad:</strong> {$solicitud['unidad']}</p>
                                                <p><strong>Puesto:</strong> {$solicitud['puesto']}</p>
                                                <p><strong>Tipo de Permiso:</strong> {$solicitud['tipo_permiso']}</p>
                                                <p><strong>Motivo:</strong> {$solicitud['descripcion_motivo']}</p>
                                                <p><strong>Fecha de Salida:</strong> {$solicitud['fecha_salida']}</p>
                                                <p><strong>Horario del Permiso:</strong> {$solicitud['horario_permiso']}</p>
                                                <p>Si tienes alguna pregunta, por favor contacta al equipo de RRHH.</p>
                                                <p>Saludos,<br>El equipo de RRHH - PROASOL</p>";

                            if (!sendEmail($to_solicitante, $subject_solicitante, $body_solicitante)) {
                                $_SESSION['error'] = "Estado actualizado, pero falló el envío del correo al solicitante.";
                            }

                            // Obtener el correo y nombre del jefe desde la tabla jefes
                            if ($cod_jefe) {
                                $sql_jefe = "SELECT correo, nombre_jefe FROM jefes WHERE cod_jefe = ?";
                                if ($stmt_jefe = $conn->prepare($sql_jefe)) {
                                    $stmt_jefe->bind_param('i', $cod_jefe);
                                    $stmt_jefe->execute();
                                    $result_jefe = $stmt_jefe->get_result();
                                    $jefe = $result_jefe->fetch_assoc();
                                    $stmt_jefe->close();

                                    if ($jefe) {
                                        $to_jefe = $jefe['correo'];
                                        $nombre_jefe = $jefe['nombre_jefe'];

                                        // Enviar correo al jefe
                                        $subject_jefe = "Solicitud Revisada por RRHH - ID: {$solicitud_id}";
                                        $body_jefe = "<h2>Hola, {$nombre_jefe}</h2>
                                                      <p>La solicitud del empleado {$nombre_solicitante} ha sido revisada por Recursos Humanos.</p>
                                                      <p><strong>ID de Solicitud:</strong> {$solicitud_id}</p>
                                                      <p><strong>Estado:</strong> {$estado}</p>
                                                      <p><strong>Unidad:</strong> {$solicitud['unidad']}</p>
                                                      <p><strong>Puesto:</strong> {$solicitud['puesto']}</p>
                                                      <p><strong>Tipo de Permiso:</strong> {$solicitud['tipo_permiso']}</p>
                                                      <p><strong>Motivo:</strong> {$solicitud['descripcion_motivo']}</p>
                                                      <p><strong>Fecha de Salida:</strong> {$solicitud['fecha_salida']}</p>
                                                      <p><strong>Horario del Permiso:</strong> {$solicitud['horario_permiso']}</p>
                                                      <p>Si tienes alguna pregunta, por favor contacta al equipo de RRHH.</p>
                                                      <p>Saludos,<br>El equipo de RRHH - PROASOL</p>";

                                        if (!sendEmail($to_jefe, $subject_jefe, $body_jefe)) {
                                            $_SESSION['error'] = "Estado actualizado, pero falló el envío del correo al jefe.";
                                        }
                                    } else {
                                        $_SESSION['error'] = "Estado actualizado, pero no se encontró el correo del jefe.";
                                    }
                                } else {
                                    $_SESSION['error'] = "Estado actualizado, pero error al consultar datos del jefe: " . $conn->error;
                                }
                            } else {
                                $_SESSION['error'] = "Estado actualizado, pero no se pudo determinar el jefe del solicitante.";
                            }
                        } else {
                            $_SESSION['error'] = "Estado actualizado, pero no se encontró el correo del solicitante.";
                        }
                    } else {
                        $_SESSION['error'] = "Estado actualizado, pero error al consultar datos del solicitante: " . $conn->error;
                    }
                } else {
                    $_SESSION['error'] = "Estado actualizado, pero no se encontró la solicitud.";
                }
            } else {
                $_SESSION['error'] = "Estado actualizado, pero error al consultar la solicitud: " . $conn->error;
            }
        } else {
            $_SESSION['error'] = "No se pudo actualizar el estado. Es posible que la solicitud ya no esté en estado 'Aprobada por Jefe Inmediato'.";
        }

        $stmt->close();
    } else {
        $_SESSION['error'] = "Error al preparar la actualización: " . $conn->error;
    }

    // Redirigir para evitar reenvíos de formulario
    header("Location: gestionar_solicitudes_rrhh.php");
    exit;
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gestionar Solicitudes - Recursos Humanos</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; font-family: 'Roboto', sans-serif; }
        body { background-color: #f0f4f8; color: #2c3e50; line-height: 1.6; }
        .container { display: flex; min-height: 100vh; }

        /* Sidebar */
        .sidebar { width: 260px; background: linear-gradient(135deg, #2c3e50, #34495e); color: white; padding: 20px 15px; position: fixed; height: 100%; transition: transform 0.3s ease; z-index: 1000; }
        .sidebar.collapsed { transform: translateX(-260px); width: 0; }
        .sidebar h2 { font-size: 24px; margin-bottom: 30px; text-align: center; color: #68c8d8; }
        .sidebar ul { list-style: none; }
        .sidebar ul li { margin-bottom: 15px; }
        .sidebar ul li a { color: #ecf0f1; text-decoration: none; font-size: 16px; display: flex; align-items: center; padding: 10px 15px; border-radius: 5px; transition: background 0.3s, color 0.3s; }
        .sidebar ul li a:hover { background: #465c71; color: #68c8d8; }
        .sidebar ul li a i { margin-right: 10px; }

        .toggle-btn { display: none; position: fixed; left: 10px; top: 10px; background: #68c8d8; color: white; border: none; padding: 10px; border-radius: 5px; cursor: pointer; z-index: 1001; transition: background 0.3s; }
        .toggle-btn:hover { background: #5dade2; }

        /* Main Content */
        .main-content { flex-grow: 1; padding: 30px; margin-left: 260px; transition: margin-left 0.3s ease; width: calc(100% - 260px); }
        .welcome-message { font-size: 28px; color: #2c3e50; margin-bottom: 25px; text-align: center; font-weight: 500; }
        .main-content h1 { font-size: 32px; color: #2c3e50; margin-bottom: 30px; text-align: center; border-bottom: 3px solid #68c8d8; padding-bottom: 10px; font-weight: 700; }

        /* Sections Grid */
        .dashboard-grid { display: grid; grid-template-columns: 1fr; gap: 30px; }

        /* Requests Section */
        .requests-section { background: white; padding: 20px; border-radius: 10px; box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1); overflow-x: auto; }
        .requests-section h2 { font-size: 22px; color: #2c3e50; margin-bottom: 20px; }
        .requests-section table { width: 100%; min-width: 600px; border-collapse: collapse; table-layout: fixed; }
        .requests-section th, .requests-section td { padding: 12px; text-align: left; border-bottom: 1px solid #ecf0f1; font-size: 15px; word-wrap: break-word; }
        .requests-section th { background: linear-gradient(135deg, #2c3e50, #34495e); color: white; font-weight: 500; position: sticky; top: 0; z-index: 1; }
        .requests-section tr:hover { background: #f9fbfd; }

        .requests-section .action-buttons form { display: inline-block; vertical-align: top; }

        .requests-section .action-buttons button {
            padding: 8px 12px; border: none; border-radius: 5px; font-size: 14px;
            cursor: pointer; transition: background 0.3s, transform 0.2s; font-weight: 500;
        }
        .requests-section .action-buttons .approve { background: linear-gradient(135deg, #27ae60, #219653); color: white; margin-right: 5px; }
        .requests-section .action-buttons .approve:hover { background: linear-gradient(135deg, #219653, #1e8449); transform: translateY(-2px); }
        .requests-section .action-buttons .reject { background: linear-gradient(135deg, #c0392b, #a93226); color: white; }
        .requests-section .action-buttons .reject:hover { background: linear-gradient(135deg, #a93226, #922b21); transform: translateY(-2px); }

        .requests-section .action-buttons a { color: #68c8d8; text-decoration: none; font-weight: 500; transition: color 0.3s; margin-left: 10px; }
        .requests-section .action-buttons a:hover { color: #5dade2; text-decoration: underline; }

        /* Responsive tweaks omitidos por brevedad (se mantienen iguales) */
        @media (max-width: 1024px) {
            .sidebar { width: 220px; }
            .main-content { margin-left: 220px; width: calc(100% - 220px); padding: 25px; }
        }
        @media (max-width: 768px) {
            .toggle-btn { display: block; }
            .sidebar { transform: translateX(-260px); width: 260px; }
            .sidebar.open { transform: translateX(0); }
            .main-content { margin-left: 0; width: 100%; padding: 20px; }
            .requests-section th, .requests-section td { padding: 10px; font-size: 13px; }
            .requests-section .action-buttons button { padding: 6px 10px; font-size: 12px; }
            .requests-section .action-buttons a { font-size: 12px; margin-left: 5px; }
        }
        @media (max-width: 480px) {
            .sidebar { padding: 10px; }
            .sidebar h2 { font-size: 18px; margin-bottom: 20px; }
            .sidebar ul li a { font-size: 14px; padding: 8px; }
            .main-content { padding: 15px; }
            .welcome-message { font-size: 20px; }
            .main-content h1 { font-size: 24px; }
            .requests-section { padding: 15px; }
            .requests-section th, .requests-section td { padding: 8px; font-size: 12px; }
            .requests-section .action-buttons { display: flex; flex-wrap: wrap; gap: 5px; }
            .requests-section .action-buttons button { padding: 5px 8px; font-size: 10px; }
            .requests-section .action-buttons a { font-size: 10px; margin-left: 5px; }
        }
    </style>
</head>
<body>
    <button class="toggle-btn" onclick="toggleSidebar()"><i class="fas fa-bars"></i></button>
    <div class="container">
        <!-- Menú lateral -->
        <div class="sidebar" id="sidebar">
            <h2>Panel RRHH</h2>
            <ul>
                <li><a href="dashboard_rrhh.php"><i class="fas fa-home"></i> Inicio</a></li>
                <?php if ($_SESSION['role'] != 11): ?>
                    <li><a href="gestionar_solicitudes_rrhh.php"><i class="fas fa-tasks"></i> Gestionar Solicitudes</a></li>
                <?php endif; ?>
                <li><a href="panel_jefe_rrhh.php"><i class="fas fa-chart-bar"></i>Solicitudes Unidad RRHH</a></li>
                <li><a href="panel_rrhh_vacaciones.php"><i class="fas fa-chart-bar"></i>Solicitudes Vacaciones RRHH</a></li>
                <li><a href="estadisticas_rrhh.php"><i class="fas fa-chart-bar"></i> Estadísticas</a></li>
                <li><a href="solicitudes_aprobadas_rrhh.php"><i class="fas fa-check"></i> Historial de Solicitudes Aprobadas</a></li>
                <li><a href="ver_solicitudes.php"><i class="fas fa-eye"></i> Más Solicitudes</a></li>
                <?php if ($_SESSION['role'] != 11): ?>
                    <li><a href="gestionar_empleados.php"><i class="fas fa-users"></i> Gestión de Empleados</a></li>
                <?php endif; ?>
                <li><a href="panel_vacaciones_rrhh.php"><i class="fas fa-umbrella-beach"></i> Gestión de Vacaciones</a></li>
                <?php if ($_SESSION['role'] != 11): ?>
                    <li><a href="gestionar_unidades_puestos.php"><i class="fas fa-building"></i> Unidades y Puestos</a></li>
                    <li><a href="asignar_privilegios_rrhh.php"><i class="fas fa-user-shield"></i> Asignar Rol</a></li>
                <?php endif; ?>
                <!-- ✅ NUEVO: acceso directo al Portal de Denuncias -->
                <li>
                    <a href="https://sistemas.proasol.gob.hn/denuncias_proasol/index.html?src=rrhh_sidebar" target="_blank" rel="noopener">
                       <i class="fas fa-shield-alt"></i> Denuncia-CPEP
                    </a>
                </li>
                <li><a href="panel_rrhh_user.php"><i class="fas fa-user"></i> Perfil</a></li>
                <li><a href="logout.php"><i class="fas fa-sign-out-alt"></i> Cerrar Sesión</a></li>
            </ul>
        </div>

        <!-- Contenido principal -->
        <div class="main-content">
            <div class="welcome-message">Bienvenido, <?= htmlspecialchars($nombre_usuario) ?> <span style="font-size: 14px; color: #7f8c8d;"></span></div>
            <h1>Gestionar Solicitudes - Recursos Humanos</h1>

            <!-- Dashboard Grid -->
            <div class="dashboard-grid">
                <!-- Requests Section -->
                <div class="requests-section">
                    <h2>Solicitudes en Revisión por RRHH</h2>
                    <?php if ($result_solicitudes->num_rows > 0): ?>
                        <table>
                            <thead>
                                <tr>
                                    <th>Unidad</th>
                                    <th>Empleado</th>
                                    <th>Tipo de Solicitud</th>
                                    <th>Fecha de Solicitud</th>
                                    <th>Fecha de Salida</th>
                                    <th>Motivo</th>
                                    <th>Acciones</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php while ($row = $result_solicitudes->fetch_assoc()): ?>
                                    <tr>
                                        <td><?= htmlspecialchars($row['nombre_unidad']) ?></td>
                                        <td><?= htmlspecialchars($row['Nom'] . ' ' . $row['Ape']) ?></td>
                                        <td><?= htmlspecialchars($row['tipo_permiso']) ?></td>
                                        <td><?= htmlspecialchars($row['fecha_solicitud']) ?></td>
                                        <td><?= htmlspecialchars($row['fecha_salida']) ?></td>
                                        <td><?= htmlspecialchars($row['descripcion_motivo']) ?></td>
                                        <td class="action-buttons">
                                            <!-- ✅ Formulario Aprobar con comentario -->
                                            <form method="POST" style="display:inline;">
                                                <input type="hidden" name="solicitud_id" value="<?= $row['id'] ?>">
                                                <input type="hidden" name="action" value="aprobar">
                                                <!-- ✅ NUEVO: Comentario final -->
                                                <div style="margin-bottom:6px;">
                                                    <textarea name="comentarios_finales" placeholder="Comentario (opcional)" rows="2" style="width:240px; padding:6px;"></textarea>
                                                </div>
                                                <button type="submit" class="approve">Aprobar</button>
                                            </form>

                                            <!-- ✅ Formulario Rechazar con comentario -->
                                            <form method="POST" style="display:inline; margin-left:6px;">
                                                <input type="hidden" name="solicitud_id" value="<?= $row['id'] ?>">
                                                <input type="hidden" name="action" value="rechazar">
                                                <!-- ✅ NUEVO: Comentario final -->
                                                <div style="margin-bottom:6px;">
                                                    <textarea name="comentarios_finales" placeholder="Motivo de rechazo (opcional)" rows="2" style="width:240px; padding:6px;"></textarea>
                                                </div>
                                                <button type="submit" class="reject">Rechazar</button>
                                            </form>

                                            <a href="ver_detalle_rrhh.php?id=<?= $row['id'] ?>">Ver Detalles</a>
                                        </td>
                                    </tr>
                                <?php endwhile; ?>
                            </tbody>
                        </table>
                    <?php else: ?>
                        <p style="text-align: center; color: #777;">No hay solicitudes en revisión por RRHH en este momento.</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <script>
        function toggleSidebar() {
            const sidebar = document.getElementById('sidebar');
            sidebar.classList.toggle('open');
            const mainContent = document.querySelector('.main-content');
            if (sidebar.classList.contains('open')) {
                mainContent.style.marginLeft = '260px';
                mainContent.style.width = 'calc(100% - 260px)';
            } else {
                mainContent.style.marginLeft = '0';
                mainContent.style.width = '100%';
            }
        }
    </script>

    <?php $conn->close(); ?>
</body>
</html>
