<?php
session_start();
require 'conexion.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] != 9) {
    header("Location: login.php");
    exit;
}

$nombre_usuario = $_SESSION['Nom'];
$mensaje = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nueva_unidad = trim($_POST['nueva_unidad']);
    $nuevo_puesto = trim($_POST['nuevo_puesto']);

    if (!empty($nueva_unidad) && !empty($nuevo_puesto)) {
        $stmt_unidad = $conn->prepare("INSERT INTO unidad (nombre_unidad) VALUES (?)");
        $stmt_unidad->bind_param("s", $nueva_unidad);
        if ($stmt_unidad->execute()) {
            $stmt_puesto = $conn->prepare("INSERT INTO puestos (nombre_puesto) VALUES (?)");
            $stmt_puesto->bind_param("s", $nuevo_puesto);
            if ($stmt_puesto->execute()) {
                $mensaje = "Unidad y puesto agregados exitosamente.";
            } else {
                $mensaje = "Error al agregar el puesto.";
            }
            $stmt_puesto->close();
        } else {
            $mensaje = "Error al agregar la unidad.";
        }
        $stmt_unidad->close();
    } else {
        $mensaje = "Por favor, complete ambos campos.";
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gestionar Unidades y Puestos</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        * { box-sizing: border-box; }

        body {
            margin: 0;
            font-family: 'Roboto', sans-serif;
            background: #f4f6f9;
            color: #333;
        }

        .container {
            display: flex;
            min-height: 100vh;
        }

        .sidebar {
            width: 250px;
            background: linear-gradient(135deg, #2c3e50, #34495e);
            color: white;
            padding: 20px 15px;
            position: fixed;
            height: 100%;
            box-shadow: 2px 0 5px rgba(0, 0, 0, 0.1);
            transition: transform 0.3s ease;
            z-index: 1000;
        }

        .sidebar.collapsed {
            transform: translateX(-250px);
            width: 0;
        }

        .sidebar h2 {
            font-size: 24px;
            margin-bottom: 30px;
            text-align: center;
            color: #68c8d8;
            font-weight: 700;
        }

        .sidebar ul {
            list-style: none;
            padding: 0;
        }

        .sidebar ul li {
            margin-bottom: 15px;
        }

        .sidebar ul li a {
            color: #ecf0f1;
            text-decoration: none;
            font-size: 16px;
            display: flex;
            align-items: center;
            padding: 10px 15px;
            border-radius: 5px;
            transition: background 0.3s, color 0.3s;
        }

        .sidebar ul li a:hover {
            background: #465c71;
            color: #68c8d8;
        }

        .sidebar ul li a i {
            margin-right: 10px;
            font-size: 16px;
        }

     .toggle-btn {
    display: none;
    position: fixed;
    top: 15px;
    left: 15px;
    background: #68c8d8;
    color: white;
    border: none;
    padding: 10px 12px;
    border-radius: 5px;
    cursor: pointer;
    z-index: 1100;
    transition: background 0.3s;
}


        .toggle-btn:hover {
            background: #5dade2;
        }

        .main {
            flex: 1;
            padding: 40px;
            margin-left: 250px;
            transition: margin-left 0.3s ease;
        }

        h1 {
            font-size: 28px;
            margin-bottom: 20px;
            color: #2c3e50;
            border-bottom: 2px solid #3498db;
            padding-bottom: 10px;
        }

        .form-container {
            background: #fff;
            padding: 20px;
            border-radius: 12px;
            box-shadow: 0 4px 10px rgba(0,0,0,0.1);
            max-width: 500px;
        }

        .form-group {
            margin-bottom: 20px;
        }

        label {
            display: block;
            font-weight: 600;
            margin-bottom: 5px;
            color: #2c3e50;
        }

        input[type="text"] {
            width: 100%;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 6px;
            font-size: 14px;
            background: #f9f9f9;
        }

        input[type="text"]:focus {
            outline: none;
            border-color: #3498db;
        }

        button {
            background-color: #3498db;
            color: white;
            border: none;
            padding: 10px 20px;
            border-radius: 6px;
            cursor: pointer;
            font-size: 14px;
            transition: background 0.3s;
        }

        button:hover {
            background-color: #2980b9;
        }

        .message {
            margin-top: 10px;
            padding: 10px;
            border-radius: 4px;
            display: none;
        }

        .message.success {
            background-color: #dff0d8;
            color: #3c763d;
            display: block;
        }

        .message.error {
            background-color: #f2dede;
            color: #a94442;
            display: block;
        }

        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-250px);
                width: 250px;
                height: 100vh;
                position: fixed;
                top: 0;
                left: 0;
            }

            .sidebar.open {
                transform: translateX(0);
            }

            .toggle-btn {
                display: block;
            }

            .main {
                margin-left: 0;
                padding: 20px;
            }

            .form-container {
                padding: 15px;
                max-width: 100%;
            }

            button {
                width: 100%;
                padding: 10px;
            }
        }
        
        @media (max-width: 768px) {
    .toggle-btn {
        display: block;
    }

    .main {
        margin-left: 0;
    }

    .sidebar {
        transform: translateX(-250px);
    }

    .sidebar.open {
        transform: translateX(0);
    }
}

    </style>
</head>
<body>
<div class="container">
   <div class="sidebar" id="sidebar">
    <h2>Panel RRHH</h2>
   <ul>
        <li><a href="dashboard_rrhh.php"><i class="fas fa-home"></i> Inicio</a></li>
        <?php if ($_SESSION['role'] != 11): ?>
            <li><a href="gestionar_solicitudes_rrhh.php"><i class="fas fa-tasks"></i> Gestionar Solicitudes</a></li>
        <?php endif; ?>
        <li><a href="panel_jefe_rrhh.php"><i class="fas fa-chart-bar"></i>Solicitudes Unidad RRHH</a></li>
         <li><a href="panel_rrhh_vacaciones.php"><i class="fas fa-chart-bar"></i>Solicitudes Vacaciones RRHH</a></li>
        <li><a href="estadisticas_rrhh.php"><i class="fas fa-chart-bar"></i> Estadísticas</a></li>
        <li><a href="solicitudes_aprobadas_rrhh.php"><i class="fas fa-check"></i> Historial de Solicitudes Aprobadas</a></li>
        <li><a href="ver_solicitudes.php"><i class="fas fa-eye"></i> Más Solicitudes</a></li>
        <?php if ($_SESSION['role'] != 11): ?>
            <li><a href="gestionar_empleados.php"><i class="fas fa-users"></i> Gestión de Empleados</a></li>
        <?php endif; ?>
        <li><a href="panel_vacaciones_rrhh.php"><i class="fas fa-umbrella-beach"></i> Gestión de Vacaciones</a></li>
        <?php if ($_SESSION['role'] != 11): ?>
            <li><a href="gestionar_unidades_puestos.php"><i class="fas fa-building"></i> Unidades y Puestos</a></li>
            <li><a href="asignar_privilegios_rrhh.php"><i class="fas fa-user-shield"></i> Asignar Rol</a></li>
        <?php endif; ?>

        <!-- ✅ NUEVO: acceso directo al Portal de Denuncias -->
        <li>
            <a href="https://sistemas.proasol.gob.hn/denuncias_proasol/index.html?src=rrhh_sidebar"
               target="_blank" rel="noopener">
               <i class="fas fa-shield-alt"></i> Denuncia-CPEP
            </a>
        </li>

        <li><a href="panel_rrhh_user.php"><i class="fas fa-user"></i> Perfil</a></li>
        <li><a href="logout.php"><i class="fas fa-sign-out-alt"></i> Cerrar Sesión</a></li>
    </ul>
</div>


    <div class="main">
        <h1>Gestionar Unidades y Puestos</h1>
        <div class="form-container">
            <form method="POST" action="">
                <div class="form-group">
                    <label for="nueva_unidad">Nueva Unidad:</label>
                    <input type="text" id="nueva_unidad" name="nueva_unidad" required>
                </div>
                <div class="form-group">
                    <label for="nuevo_puesto">Nuevo Puesto:</label>
                    <input type="text" id="nuevo_puesto" name="nuevo_puesto" required>
                </div>
                <button type="submit">Guardar</button>
            </form>
            <?php if ($mensaje): ?>
                <div class="message <?php echo strpos($mensaje, 'exitosamente') !== false ? 'success' : 'error'; ?>">
                    <?= htmlspecialchars($mensaje) ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<script>
function toggleSidebar() {
    const sidebar = document.getElementById('sidebar');
    const main = document.querySelector('.main');

    sidebar.classList.toggle('open');

    if (window.innerWidth <= 768) {
        if (sidebar.classList.contains('open')) {
            main.style.marginLeft = '250px';
        } else {
            main.style.marginLeft = '0';
        }
    }
}
</script>
</body>
</html>

<?php $conn->close(); ?>
