<?php
require 'conexion.php';

$unidad       = $_POST['unidad']       ?? '';
$empleado     = $_POST['empleado']     ?? '';
$fecha_inicio = $_POST['fecha_inicio'] ?? '';
$fecha_fin    = $_POST['fecha_fin']    ?? '';

$condiciones = [];
$parametros  = [];
$tipos       = '';

/* ===== Subconsulta base: unifica fechas de ejecución =====
   - Vacaciones: rango MIN(fecha_inicio)..MAX(fecha_fin) y suma de días
   - Personal/Oficial: fecha_salida (inicio=fin=fecha_salida)
   - Otros: cae a fecha_solicitud (inicio=fin)
*/
$sql_base = "
    SELECT
        s.id                    AS id_solicitud,
        s.id_usuario,
        a.cod_unidad,
        s.tipo_permiso,
        s.estado,
        DATE(s.fecha_solicitud) AS fecha_solicitud,
        DATE(s.fecha_salida)    AS fecha_salida,

        CASE
            WHEN s.tipo_permiso = 'Vacaciones' AND v.fecha_inicio_vac IS NOT NULL THEN v.fecha_inicio_vac
            WHEN s.tipo_permiso IN ('Personal','Oficial') AND s.fecha_salida IS NOT NULL THEN DATE(s.fecha_salida)
            ELSE DATE(s.fecha_solicitud)
        END AS fecha_evento_inicio,

        CASE
            WHEN s.tipo_permiso = 'Vacaciones' AND v.fecha_fin_vac IS NOT NULL THEN v.fecha_fin_vac
            WHEN s.tipo_permiso IN ('Personal','Oficial') AND s.fecha_salida IS NOT NULL THEN DATE(s.fecha_salida)
            ELSE DATE(s.fecha_solicitud)
        END AS fecha_evento_fin
    FROM solicitudes s
    INNER JOIN accounts a ON s.id_usuario = a.ID
    LEFT JOIN (
        SELECT 
            id_solicitud,
            MIN(fecha_inicio) AS fecha_inicio_vac,
            MAX(fecha_fin)    AS fecha_fin_vac,
            SUM(dias)         AS dias_vac
        FROM vacaciones
        GROUP BY id_solicitud
    ) v ON v.id_solicitud = s.id
";

/* ===== Selección y filtros sobre la vista unificada ===== */
$sql = "
    SELECT 
        t.tipo_permiso,
        COUNT(*) AS total
    FROM ( $sql_base ) t
";

/* Filtro fijo: estado aprobado */
$condiciones[] = "t.estado = ?";
$parametros[]  = 'Aprobada por Recursos Humanos';
$tipos        .= 's';

/* Solo estos tipos */
$condiciones[] = "t.tipo_permiso IN (?,?,?)";
$parametros[]  = 'Personal';
$parametros[]  = 'Vacaciones';
$parametros[]  = 'Oficial';
$tipos        .= 'sss';

/* Filtros opcionales */
if ($unidad !== '') {
    $condiciones[] = "t.cod_unidad = ?";
    $parametros[]  = $unidad; // si cod_unidad es INT en tu BD, cambia el tipo a 'i'
    $tipos        .= 's';
}

if ($empleado !== '') {
    $condiciones[] = "t.id_usuario = ?";
    $parametros[]  = (int)$empleado;
    $tipos        .= 'i';
}

/* Rango por fechas REALES de ejecución (solapamiento)
   - Si envías ambos: inicio_evento <= fecha_fin AND fin_evento >= fecha_inicio
   - Solo inicio:     fin_evento >= fecha_inicio
   - Solo fin:        inicio_evento <= fecha_fin
*/
if ($fecha_inicio !== '' && $fecha_fin !== '') {
    $condiciones[] = "t.fecha_evento_inicio <= ? AND t.fecha_evento_fin >= ?";
    $parametros[]  = $fecha_fin;
    $parametros[]  = $fecha_inicio;
    $tipos        .= 'ss';
} elseif ($fecha_inicio !== '') {
    $condiciones[] = "t.fecha_evento_fin >= ?";
    $parametros[]  = $fecha_inicio;
    $tipos        .= 's';
} elseif ($fecha_fin !== '') {
    $condiciones[] = "t.fecha_evento_inicio <= ?";
    $parametros[]  = $fecha_fin;
    $tipos        .= 's';
}

$where = count($condiciones) ? (' WHERE ' . implode(' AND ', $condiciones)) : '';
$sql  .= $where . " GROUP BY t.tipo_permiso";

$stmt = $conn->prepare($sql);
if (!empty($parametros)) {
    $stmt->bind_param($tipos, ...$parametros);
}
$stmt->execute();
$result = $stmt->get_result();

/* Mantener orden fijo y ceros cuando no existan resultados */
$base = ['Personal' => 0, 'Vacaciones' => 0, 'Oficial' => 0];
while ($row = $result->fetch_assoc()) {
    $tipo = $row['tipo_permiso'];
    if (isset($base[$tipo])) {
        $base[$tipo] = (int)$row['total'];
    }
}

echo json_encode([
    'labels' => array_keys($base),
    'data'   => array_values($base)
]);

$stmt->close();
$conn->close();
