
<?php
require_once 'conexion.php';

$unidad_id = isset($_GET['unidad_id']) ? intval($_GET['unidad_id']) : 0;

if ($unidad_id <= 0) {
    http_response_code(400);
    echo json_encode(["error" => "unidad_id inválido."]);
    exit;
}

$stmt = $conn->prepare("SELECT DISTINCT puesto, jefe_inmediato_cod FROM puestos WHERE unidad_id = ?");
$stmt->bind_param("i", $unidad_id);
$stmt->execute();
$result = $stmt->get_result();

$puestos = array();
while($row = $result->fetch_assoc()) {
    $puestos[] = [
        'puesto' => $row['puesto'],
        'jefe_inmediato_cod' => $row['jefe_inmediato_cod']
    ];
}

$stmt->close();
$conn->close();

header('Content-Type: application/json');
echo json_encode($puestos);
?>

