<?php
session_start();
require 'conexion.php';

// Verificar que el usuario esté autenticado
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['error' => 'Usuario no autenticado']);
    exit;
}

$user_id = $_SESSION['user_id'];

// Determinar la página actual
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$records_per_page = 10;
$offset = ($page - 1) * $records_per_page;

// Obtener el total de solicitudes para la paginación
$sql_total = "SELECT COUNT(*) FROM solicitudes WHERE id_usuario = ?";
if ($stmt = $conn->prepare($sql_total)) {
    $stmt->bind_param('i', $user_id);
    $stmt->execute();
    $stmt->bind_result($total_records);
    $stmt->fetch();
    $stmt->close();
} else {
    $total_records = 0;
}

$total_pages = ceil($total_records / $records_per_page);

// Obtener las solicitudes para la página actual
$sql_solicitudes = "SELECT id, tipo_permiso, fecha_solicitud, descripcion_motivo, estado FROM solicitudes WHERE id_usuario = ? LIMIT ?, ?";
if ($stmt = $conn->prepare($sql_solicitudes)) {
    $stmt->bind_param('iii', $user_id, $offset, $records_per_page);
    $stmt->execute();
    $result = $stmt->get_result();
    $solicitudes = $result->fetch_all(MYSQLI_ASSOC);
    $stmt->close();
} else {
    $solicitudes = [];
}

$conn->close();

// Preparar la respuesta JSON
$response = [
    'solicitudes' => $solicitudes,
    'total_pages' => $total_pages
];

header('Content-Type: application/json');
echo json_encode($response);
?>