<?php
// get_vacaciones_disponibles.php
session_start();
require 'conexion.php';

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['ok' => false, 'error' => 'No autenticado']);
    exit;
}

$id_usuario = (int)$_SESSION['user_id'];
$LIMITE_VACACIONES_ANUAL = 12.0;

// ✅ Desde 1 de julio de 2024 (abierto hacia adelante)
$desde = '2024-07-01';

try {
    $sql = "SELECT COALESCE(SUM(dias),0) AS usados
            FROM vacaciones
            WHERE id_usuario = ? AND fecha_inicio >= ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param('is', $id_usuario, $desde);
    $stmt->execute();
    $stmt->bind_result($usados);
    $stmt->fetch();
    $stmt->close();

    $usados = (float)$usados;
    $restantes = max(0.0, $LIMITE_VACACIONES_ANUAL - $usados);

    echo json_encode([
        'ok' => true,
        'since' => $desde,                // 📌 nuevo: punto de inicio del cómputo
        'limit' => $LIMITE_VACACIONES_ANUAL,
        'used' => $usados,
        'remaining' => $restantes
    ]);
} catch (Throwable $e) {
    http_response_code(500);
    echo json_encode(['ok' => false, 'error' => $e->getMessage()]);
}
