<?php
session_start();
if (!isset($_SESSION['loggedin'])) {
    header("Location: index.php");
    exit;
}
// Leer la preferencia del tema desde la sesión
$theme = $_SESSION['theme'] ?? 'light';
if ($_SESSION['Rol'] !== 'Administrador' && $_SESSION['Rol'] !== 'Moderador' && $_SESSION['Rol'] !== 'UsuarioRegular') {
    header('Location: inicio.php?error=' . urlencode('No tienes permiso para acceder a esta página.'));
    exit;
}
// Mostrar alerta solo al iniciar sesión
if (!isset($_SESSION['alertShown'])) {
    $_SESSION['alertShown'] = true; // Marcar que la alerta ya se mostró
    $showAlert = true;
} else {
    $showAlert = false;
}
$tiempo_maximo_inactividad = 6000000;
if (isset($_SESSION['ultima_actividad'])) {
    $tiempo_inactivo = time() - $_SESSION['ultima_actividad'];
    if ($tiempo_inactivo > $tiempo_maximo_inactividad) {
        session_unset();
        session_destroy();
        header('Location: index.php');
        exit;
    }
}
$_SESSION['ultima_actividad'] = time();
?>

<!DOCTYPE HTML>
<html lang="es">
<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Inicio</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@10/dist/sweetalert2.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css">

    <style>
        body {
            font-family: 'Arial', sans-serif;
            margin: 0;
            padding: 0;
            overflow: hidden;
            background-color: #121212;
            color: #e0e0e0;
        }

        /* Contenedor de partículas */
       /* Contenedor de partículas */
#particles-js {
    position: fixed;
    width: 100%;
    height: 100%;
    top: 0;
    left: 0;
    z-index: -2;
    pointer-events: none; /* Ignora los clics en el fondo de partículas */
}

        /* Contenedor centrado */
        .centered-container {
            display: flex;
            align-items: center;
            justify-content: center;
            width: 100%;
            height: 100vh;
            position: absolute;
            top: 0;
            left: 0;
            z-index: 1;
        }

        /* Estilo de las cartas */
        .card-container {
            display: flex;
            flex-wrap: wrap;
            gap: 20px;
            justify-content: center;
        }
        .card {
            background-color: #1e1e1e;
            color: #e0e0e0;
            border-radius: 8px;
            width: 260px;
            padding: 2rem;
            text-align: center;
            transition: transform 0.3s, box-shadow 0.3s;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.3);
        }
        .card:hover {
            transform: translateY(-10px);
            box-shadow: 0 8px 16px rgba(0, 0, 0, 0.4);
        }
        .card i {
            font-size: 3rem;
            color: #007bff;
            margin-bottom: 1rem;
        }
        .card-title {
            font-size: 1.5rem;
            margin: 0.5rem 0;
        }
        /* Tooltip */
        [data-tooltip] {
            position: relative;
            cursor: pointer;
        }
        [data-tooltip]::after {
            content: attr(data-tooltip);
            position: absolute;
            bottom: 100%;
            left: 50%;
            transform: translateX(-50%);
            background-color: #333;
            color: #fff;
            padding: 5px;
            border-radius: 4px;
            font-size: 0.8rem;
            display: none;
        }
        [data-tooltip]:hover::after {
            display: block;
        }

        /* Tema oscuro y claro */
        .dark-theme {
            background-color: #121212;
            color: #e0e0e0;
        }
        .light-theme {
            background-color: #ffffff;
            color: #121212;
        }
        /* Loader */
        #loader {
            position: fixed;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.8);
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 10;
            display: none;
        }
         /* Botón de alternar tema */
         .theme-toggle {
            position: fixed;
            bottom: 20px;
            right: 20px;
            font-size: 1.5rem;
            background-color: #007bff;
            color: white;
            border: none;
            padding: 0.5rem;
            border-radius: 50%;
            cursor: pointer;
            z-index: 5;
        }
        /* Barra de progreso */
        .progress-bar {
            position: fixed;
            top: 0;
            left: 0;
            height: 4px;
            background-color: #007bff;
            width: 0%;
            z-index: 100;
            transition: width 0.4s ease;
        }
/* Menú lateral */
.sidebar {
    position: fixed;
    top: 0;
    left: 0;
    height: 100%;
    width: 250px;
    background-color: #1f1f1f;
    padding: 20px;
    transform: translateX(-250px);
    transition: transform 0.3s ease;
    z-index: 3; /* Asegura que el menú esté por encima de las partículas */
}
        .sidebar.active {
            transform: translateX(0);
        }
        .sidebar h2 {
            color: #fff;
            font-size: 1.5rem;
            margin-bottom: 1rem;
        }
        .sidebar a {
            color: #e0e0e0;
            display: block;
            margin-bottom: 1rem;
            text-decoration: none;
            font-size: 1.1rem;
        }
        .sidebar a:hover {
            color: #007bff;
        }

        /* Botón de menú */
        /* Botón de menú */
.menu-toggle {
    position: absolute;
    top: 20px;
    left: 20px;
    font-size: 2rem;
    color: #007bff;
    cursor: pointer;
    z-index: 4; /* Asegura que el botón esté por encima del menú y las partículas */
}
        /* Contenido principal */
        .content {
            margin-left: 260px;
            padding: 2rem;
            transition: margin-left 0.3s;
        }
        /* Card */
        .card-container {
            display: flex;
            flex-wrap: wrap;
            gap: 20px;
            justify-content: center;
            padding: 2rem 0;
        }
        .card {
            background-color: #1e1e1e;
            color: #e0e0e0;
            border-radius: 8px;
            width: 260px;
            padding: 2rem;
            text-align: center;
            transition: transform 0.3s, box-shadow 0.3s;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.3);
        }
        .card:hover {
            transform: translateY(-10px);
            box-shadow: 0 8px 16px rgba(0, 0, 0, 0.4);
        }
        .card i {
            font-size: 3rem;
            color: #007bff;
            margin-bottom: 1rem;
        }
        .card-title {
            font-size: 1.5rem;
            margin: 0.5rem 0;
        }

        /* Tooltip */
        [data-tooltip] {
            position: relative;
            cursor: pointer;
        }
        [data-tooltip]::after {
            content: attr(data-tooltip);
            position: absolute;
            bottom: 100%;
            left: 50%;
            transform: translateX(-50%);
            background-color: #333;
            color: #fff;
            padding: 5px;
            border-radius: 4px;
            font-size: 0.8rem;
            display: none;
        }
        [data-tooltip]:hover::after {
            display: block;
        }

        /* Tema oscuro y claro */
        .dark-theme {
            background-color: #121212;
            color: #e0e0e0;
        }
        .light-theme {
            background-color: #ffffff;
            color: #121212;
        }
    </style>
<script>
document.addEventListener('DOMContentLoaded', function () {
    const themeToggleButton = document.getElementById('theme-toggle');
    const body = document.body;

    // Leer el tema guardado en la sesión (aplicado desde PHP)
    const currentTheme = body.classList.contains('dark-theme') ? 'dark' : 'light';

    // Función para alternar el tema
    function toggleTheme() {
        let newTheme;
        if (body.classList.contains('dark-theme')) {
            body.classList.remove('dark-theme');
            body.classList.add('light-theme');
            newTheme = 'light';
        } else {
            body.classList.remove('light-theme');
            body.classList.add('dark-theme');
            newTheme = 'dark';
        }

        // Hacer una solicitud AJAX para guardar el tema en la base de datos
        fetch('guardar_tema.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded'
            },
            body: `theme=${newTheme}`
        }).then(response => response.json())
          .then(data => {
              if (data.success) {
                  console.log('Tema guardado correctamente en la base de datos.');
              } else {
                  console.error('Error al guardar el tema:', data.error);
              }
          });
    }

    // Asignar el evento de clic al botón para alternar el tema
    if (themeToggleButton) {
        themeToggleButton.addEventListener('click', toggleTheme);
    }
});
</script>
 
    <script>
        // Tema oscuro/claro
        function toggleTheme() {
            document.body.classList.toggle('dark-theme');
            document.body.classList.toggle('light-theme');
        }

        // Loader al cambiar de página
        function showLoader() {
            document.getElementById('loader').style.display = 'flex';
        }

        // Barra de progreso
        function startProgress() {
            const progressBar = document.querySelector('.progress-bar');
            progressBar.style.width = '100%';
            setTimeout(() => progressBar.style.width = '0%', 800);
        }

        // Notificación de sesión a punto de expirar
        function notifySessionExpiry() {
            Swal.fire({
                icon: 'warning',
                title: '¡Atención!',
                text: 'Tu sesión está a punto de expirar. ¿Deseas extenderla?',
                showCancelButton: true,
                confirmButtonText: 'Sí, extender sesión',
                cancelButtonText: 'No'
            }).then((result) => {
                if (result.isConfirmed) {
                    resetTimer();
                } else {
                    window.location.href = 'index.php';
                }
            });
        }

        // Temporizador para mostrar notificación de sesión
        let timer;
        function resetTimer() {
            clearTimeout(timer);
            timer = setTimeout(notifySessionExpiry, 600000); // Notificar después de 9 minutos 50 segundos
        }
        document.onmousemove = resetTimer;
        document.onkeypress = resetTimer;
    </script>
</head>



<body class="<?= $theme ?>-theme">
    



<div id="loader">
    <div class="spinner-border" role="status">
        <span class="visually-hidden">Loading...</span>
    </div>
</div>
<div class="progress-bar"></div>

<!-- Fondo de partículas -->
<!-- Fondo de partículas -->
<div id="particles-js"></div>

<!-- Botón de alternar tema -->
<!--<button class="theme-toggle" onclick="toggleTheme()"><i class="fas fa-adjust"></i></button>-->
<!-- Botón de alternar tema -->
<button id="theme-toggle" class="theme-toggle"><i class="fas fa-adjust"></i></button>

<!-- Botón de menú -->
<i class="fas fa-bars menu-toggle" onclick="toggleSidebar()"></i>

<!-- Menú lateral -->
<div class="sidebar" id="sidebar">
    <h2>Menú</h2>
    <a href="perfil.php" onclick="showLoader()">Información de Usuario</a>
    <?php if ($_SESSION['Rol'] == 'Administrador') { ?>
        <a href="usuarios.php" onclick="showLoader()">Usuarios</a>
        <a href="excel.php" onclick="showLoader()">Exportar Información</a>
        <a href="dashboard.php" onclick="showLoader()">Dashboard</a>
    <?php } elseif ($_SESSION['Rol'] == 'Moderador') { ?>
        <a href="excel.php" onclick="showLoader()">Exportar Información</a>
        <a href="dashboard.php" onclick="showLoader()">Dashboard</a>
    <?php } ?>
    <a href="cerrar-sesion.php" class="btn btn-danger">Cerrar Sesión</a>
</div>

<!-- Contenido principal -->
<!-- Contenedor centrado con cartas -->
<!-- Cartas con Animación de Entrada -->
<div class="centered-container animate__animated animate__fadeIn">
    <div class="card-container">
        <div class="card animate__animated animate__fadeInUp">
            <i class="fas fa-file-invoice-dollar"></i>
            <h5 class="card-title">Pagar Planilla</h5>
            <p>Verifica la exactitud de los pagos de cada integrante.</p>
            <a href="planilla.php" class="btn btn-primary">Pagar Planilla</a>
        </div>
        <div class="card animate__animated animate__fadeInDown ">
            <i class="fas fa-chart-line"></i>
            <h5 class="card-title">Estadísticas</h5>
            <p>Resultados en tiempo real del análisis de datos.</p>
            <a href="estadisticas.php" class="btn btn-primary">Ver Estadísticas</a>
        </div>
        <div class="card animate__animated animate__fadeInUp "> <!-- animate__delay-1s -->
            <i class="fas fa-database"></i>
            <h5 class="card-title">Datos Generales</h5>
            <p>Organización de datos relevantes para el sistema.</p>
            <a href="datos_generales.php" class="btn btn-primary">Ver Datos Generales</a>
        </div>
        <?php if ($_SESSION['Rol'] == 'Administrador') { ?>
            <div class="card animate__animated animate__fadeInDown ">
                <i class="fas fa-upload"></i>
                <h5 class="card-title">Subir Archivo</h5>
                <p>Carga archivos CSV de manera rápida y eficiente.</p>
                <a href="planilla_carga_archivo.php" class="btn btn-primary">Subir Archivo</a>
            </div>
        <?php } ?>
    </div>
</div>


<!-- Scripts -->
<script src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
<script>
   particlesJS.load('particles-js', 'particles.json', function() {
        console.log('Particles.js configuration loaded successfully.');
    });


    /* Toggle Sidebar */
    function toggleSidebar() {
    const sidebar = document.getElementById("sidebar");

    if (sidebar.classList.contains("active")) {
        sidebar.classList.remove("animate__fadeInLeft");
        sidebar.classList.add("animate__fadeOutLeft");
        setTimeout(() => {
            sidebar.classList.remove("active");
            sidebar.classList.remove("animate__fadeOutLeft");
        }, 500);
    } else {
        sidebar.classList.add("active", "animate__animated", "animate__fadeInLeft");
    }
}

</script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>

<!-- Librerías de Toastr -->
<!-- Scripts -->
<script src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>

<script>
   document.addEventListener('DOMContentLoaded', function() {
    toastr.options = {
        "closeButton": true,
        "progressBar": true,
        "positionClass": "toast-top-center",
        "timeOut": "5000",
        "extendedTimeOut": "1500",
        "showMethod": "fadeIn",
        "hideMethod": "fadeOut"
    };

    // Obtener la hora actual y mostrar saludo
    const currentHour = new Date().getHours();
    let greetingMessage = '';

    if (currentHour >= 5 && currentHour < 12) {
        greetingMessage = '¡Buenos días! Esperamos que tengas un excelente comienzo de día.';
    } else if (currentHour >= 12 && currentHour < 18) {
        greetingMessage = '¡Buenas tardes! Esperamos que tu tarde esté llena de productividad.';
    } else {
        greetingMessage = '¡Buenas noches!';
    }

    // Mostrar saludo solo al iniciar sesión
    <?php if ($showAlert): ?>
        toastr.success(`${greetingMessage} Bienvenido de nuevo, <?= $_SESSION["name"] ?>`, '¡Hola!');
    <?php endif; ?>
});

</script>



<!-- jQuery -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>

<!-- Toastr -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">

<!-- SweetAlert2 -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>



</body>
</html>  