<?php
session_start();
require 'conexion.php';

if (
    !isset($_SESSION['user_id']) ||
    !isset($_SESSION['role']) ||
    (!in_array($_SESSION['role'], [8, 9, 12]))
) {
    $_SESSION['error'] = 'Acceso no autorizado.';
    header("Location: login.php");
    exit;
}
$user_id = $_SESSION['user_id'];
$nombre_usuario = $_SESSION['Nom'];

// Obtener datos del usuario
$sql = "SELECT a.username, a.correo_personal, a.CorreoElectronico, 
               a.Nom, a.Nom2, a.Ape, a.Ape2, a.FechaNacimiento, a.Genero,
               a.dni, a.estado_civil, a.edad, a.direccion, a.telefono, a.numero_hijos,
               a.numero_empleado, a.fecha_ingreso, a.tipo_contrato,
               a.nivel_educativo, a.profesion, a.tipo_sangre, a.enfermedad,
               a.contacto_emergencia, a.nombre_contacto, a.parentesco,
               u.nombre_unidad, j.nombre_jefe, p.nombre_puesto 
        FROM accounts a
        LEFT JOIN unidad u ON a.cod_unidad = u.cod_unidad
        LEFT JOIN jefes j ON a.cod_jefe = j.cod_jefe
        LEFT JOIN puestos p ON a.cod_puesto = p.cod_puesto
        WHERE a.id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$usuario = $result->fetch_assoc();
$stmt->close();
$conn->close();

if (!$usuario) {
    echo "Usuario no encontrado.";
    exit;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Ficha del Jefe</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        body { background:#f0f4f8; font-family:'Roboto',sans-serif; margin:0; color:#2c3e50; }
        .container { display:flex; min-height:100vh; }
        .sidebar { width:260px; background:linear-gradient(135deg,#2c3e50,#34495e); color:white; padding:20px 15px; position:fixed; height:100%; z-index: 1000; }
        .sidebar h2 { font-size:24px; margin-bottom:30px; text-align:center; color:#68c8d8; }
        .sidebar ul { list-style:none; padding:0; }
        .sidebar ul li { margin-bottom:15px; }
        .sidebar ul li a { color:#ecf0f1; text-decoration:none; font-size:16px; display:flex; align-items:center; padding:10px 15px; border-radius:5px; transition:.3s; }
        .sidebar ul li a:hover { background:#465c71; color:#68c8d8; }
        .sidebar ul li a i { margin-right:10px; }
        .main-content { margin-left:260px; padding:30px; width:calc(100% - 260px); }
        .header { text-align:center; margin-bottom:25px; }
        .header h1 { font-size:28px; }
        .header p { color:#7f8c8d; }
        .card { background:white; border-radius:15px; box-shadow:0 4px 15px rgba(0,0,0,0.1); margin-bottom:25px; padding:25px; }
        .card h2 { font-size:20px; border-bottom:2px solid #68c8d8; padding-bottom:8px; margin-bottom:15px; color:#34495e; display:flex; align-items:center; }
        .card h2 i { margin-right:8px; color:#68c8d8; }
        .info-grid { display:grid; grid-template-columns:repeat(2,1fr); gap:15px; }
        .form-group label { display:block; font-weight:500; margin-bottom:5px; color:#555; }
        .form-group input,.form-group select { width:100%; padding:10px; border:1px solid #ddd; border-radius:8px; font-size:14px; }
        .btn-save { display:block; margin:30px auto; padding:14px 25px; background:linear-gradient(135deg,#27ae60,#219653); color:white; border-radius:8px; border:none; cursor:pointer; font-size:16px; font-weight:500; }
        .btn-save:hover { background:linear-gradient(135deg,#219653,#1e8449); }
        .alert-success { background-color: #d4edda; color: #155724; padding: 15px; border-radius: 8px; margin-bottom: 20px; text-align: center; border: 1px solid #c3e6cb; }
        @media(max-width:768px){ .info-grid{grid-template-columns:1fr;} .main-content{margin-left:0;width:100%;} .sidebar{display:none;} }
    </style>
</head>
<body>
    <div class="container">
        <div class="sidebar" id="sidebar">
            <h2>Panel Jefe</h2>
            <ul>
                <li><a href="dashboard_jefe.php"><i class="fas fa-tachometer-alt"></i> Panel Principal</a></li>
                <li><a href="panel_jefe.php"><i class="fas fa-clipboard-list"></i> Solicitudes Pendientes-Permiso</a></li>
                <li><a href="panel_jefe_vacaciones.php"><i class="fas fa-umbrella-beach"></i> Solicitudes Pendientes-Vacaciones</a></li>
                <li><a href="solicitudes_aprobadas.php"><i class="fas fa-check"></i> Solicitudes Aprobadas</a></li>
                <li><a href="solicitudes_rechazadas.php"><i class="fas fa-times"></i> Solicitudes Rechazadas</a></li>
                <li><a href="vacaciones_jefe.php"><i class="fas fa-users"></i> Vacaciones</a></li>
                <li><a href="panel_jefe_user.php"><i class="fas fa-eye"></i> Perfil</a></li>
                <li><a href="https://sistemas.proasol.gob.hn/denuncias_proasol/index.html?src=jefe_sidebar" target="_blank" rel="noopener"><i class="fas fa-shield-alt"></i> Denuncia-CPEP</a></li>
                <li><a href="logout.php"><i class="fas fa-sign-out-alt"></i> Cerrar Sesión</a></li>
            </ul>
        </div>

        <div class="main-content">
            <div class="header">
                <h1>Ficha del Jefe</h1>
                <p>Bienvenido, <?= htmlspecialchars($nombre_usuario) ?> </p>
            </div>

            <?php if (isset($_GET['success'])): ?>
                <div class="alert-success"><i class="fas fa-check-circle"></i> Perfil actualizado correctamente.</div>
            <?php endif; ?>

            <form action="actualizar_perfil_jefe.php" method="POST">
                <div class="card">
                    <h2><i class="fas fa-user"></i> Información Personal</h2>
                    <div class="info-grid">
                        <div class="form-group"><label>Primer Nombre</label><input type="text" name="Nom" value="<?= htmlspecialchars($usuario['Nom']) ?>" required></div>
                        <div class="form-group"><label>Segundo Nombre</label><input type="text" name="Nom2" value="<?= htmlspecialchars($usuario['Nom2']) ?>"></div>
                        <div class="form-group"><label>Primer Apellido</label><input type="text" name="Ape" value="<?= htmlspecialchars($usuario['Ape']) ?>" required></div>
                        <div class="form-group"><label>Segundo Apellido</label><input type="text" name="Ape2" value="<?= htmlspecialchars($usuario['Ape2']) ?>"></div>
                        <div class="form-group">
                            <label>DNI</label>
                            <input type="text" name="dni" id="dni_input" maxlength="13" value="<?= htmlspecialchars($usuario['dni']) ?>" oninput="validarDNI(this)">
                            <small id="dni_warning" style="color: #e74c3c; display: none;"><i class="fas fa-exclamation-circle"></i> Solo números, sin guiones ni espacios.</small>
                        </div>
                        <div class="form-group"><label>Estado Civil</label>
                            <select name="estado_civil">
                                <option value="Soltero" <?= $usuario['estado_civil']=='Soltero'?'selected':'' ?>>Soltero/a</option>
                                <option value="Casado" <?= $usuario['estado_civil']=='Casado'?'selected':'' ?>>Casado/a</option>
                                <option value="Divorciado" <?= $usuario['estado_civil']=='Divorciado'?'selected':'' ?>>Divorciado/a</option>
                                <option value="Viudo" <?= $usuario['estado_civil']=='Viudo'?'selected':'' ?>>Viudo/a</option>
                            </select>
                        </div>
                        <div class="form-group"><label>Número de Hijos</label><input type="text" name="numero_hijos" maxlength="2" value="<?= htmlspecialchars($usuario['numero_hijos']) ?>"></div>
                        <div class="form-group"><label>Edad</label><input type="text" name="edad" maxlength="2" value="<?= htmlspecialchars($usuario['edad']) ?>"></div>
                        <div class="form-group"><label>Fecha de Nacimiento</label><input type="date" name="FechaNacimiento" value="<?= htmlspecialchars($usuario['FechaNacimiento']) ?>"></div>
                        <div class="form-group"><label>Dirección</label><input type="text" name="direccion" value="<?= htmlspecialchars($usuario['direccion']) ?>"></div>
                        <div class="form-group"><label>Teléfono</label><input type="text" name="telefono" maxlength="8" value="<?= htmlspecialchars($usuario['telefono']) ?>"></div>
                        <div class="form-group"><label>Correo Personal</label><input type="email" name="correo_personal" value="<?= htmlspecialchars($usuario['correo_personal']) ?>"></div>
                        <div class="form-group"><label>Género</label>
                            <select name="Genero">
                                <option value="M" <?= $usuario['Genero']=='M'?'selected':'' ?>>Masculino</option>
                                <option value="F" <?= $usuario['Genero']=='F'?'selected':'' ?>>Femenino</option>
                                <option value="O" <?= $usuario['Genero']=='O'?'selected':'' ?>>Otro</option>
                            </select>
                        </div>
                    </div>
                </div>

                <div class="card">
                    <h2><i class="fas fa-briefcase"></i> Información Laboral</h2>
                    <div class="info-grid">
                        <div class="form-group"><label>Número de Empleado</label><input type="text" name="numero_empleado" value="<?= htmlspecialchars($usuario['numero_empleado']) ?>"></div>
                        <div class="form-group"><label>Fecha de Ingreso</label><input type="date" name="fecha_ingreso" value="<?= htmlspecialchars($usuario['fecha_ingreso']) ?>"></div>
                        <div class="form-group"><label>Puesto</label><input type="text" value="<?= htmlspecialchars($usuario['nombre_puesto']) ?>" readonly></div>
                        <div class="form-group"><label>Unidad</label><input type="text" value="<?= htmlspecialchars($usuario['nombre_unidad']) ?>" readonly></div>
                        <div class="form-group"><label>Tipo de Contrato</label>
                            <select name="tipo_contrato">
                                <option value="Acuerdo" <?= $usuario['tipo_contrato']=='Acuerdo'?'selected':'' ?>>Acuerdo</option>
                                <option value="Contrato" <?= $usuario['tipo_contrato']=='Contrato'?'selected':'' ?>>Contrato</option>
                            </select>
                        </div>
                        <div class="form-group"><label>Correo Institucional</label><input type="email" value="<?= htmlspecialchars($usuario['CorreoElectronico']) ?>" readonly></div>
                        <div class="form-group"><label>Jefe Inmediato</label><input type="text" value="<?= htmlspecialchars($usuario['nombre_jefe']) ?>" readonly></div>
                    </div>
                </div>

                <div class="card">
                    <h2><i class="fas fa-graduation-cap"></i> Formación Académica</h2>
                    <div class="info-grid">
                        <div class="form-group"><label>Nivel Educativo</label>
                            <select name="nivel_educativo">
                                <option value="Primaria" <?= $usuario['nivel_educativo']=='Primaria'?'selected':'' ?>>Primaria</option>
                                <option value="Secundaria" <?= $usuario['nivel_educativo']=='Secundaria'?'selected':'' ?>>Secundaria</option>
                                <option value="Universidad Incompleta" <?= $usuario['nivel_educativo']=='Universidad Incompleta'?'selected':'' ?>>Universidad Incompleta</option>
                                <option value="Pregrado" <?= $usuario['nivel_educativo']=='Pregrado'?'selected':'' ?>>Pregrado</option>
                                <option value="Posgrado" <?= $usuario['nivel_educativo']=='Posgrado'?'selected':'' ?>>Posgrado</option>
                            </select>
                        </div>
                        <div class="form-group"><label>Ocupación / Profesión</label><input type="text" name="profesion" value="<?= htmlspecialchars($usuario['profesion']) ?>"></div>
                    </div>
                </div>

                <div class="card">
                    <h2><i class="fas fa-heartbeat"></i> Información de Salud</h2>
                    <div class="info-grid">
                        <div class="form-group"><label>Tipo de Sangre</label>
                            <select name="tipo_sangre">
                                <option value="A+" <?= $usuario['tipo_sangre']=='A+'?'selected':'' ?>>A+</option>
                                <option value="A-" <?= $usuario['tipo_sangre']=='A-'?'selected':'' ?>>A-</option>
                                <option value="B+" <?= $usuario['tipo_sangre']=='B+'?'selected':'' ?>>B+</option>
                                <option value="B-" <?= $usuario['tipo_sangre']=='B-'?'selected':'' ?>>B-</option>
                                <option value="AB+" <?= $usuario['tipo_sangre']=='AB+'?'selected':'' ?>>AB+</option>
                                <option value="AB-" <?= $usuario['tipo_sangre']=='AB-'?'selected':'' ?>>AB-</option>
                                <option value="O+" <?= $usuario['tipo_sangre']=='O+'?'selected':'' ?>>O+</option>
                                <option value="O-" <?= $usuario['tipo_sangre']=='O-'?'selected':'' ?>>O-</option>
                            </select>
                        </div>
                        <div class="form-group"><label>Enfermedades Cronicas</label><input type="text" name="enfermedad" value="<?= htmlspecialchars($usuario['enfermedad']) ?>"></div>
                    </div>
                </div>

                <div class="card">
                    <h2><i class="fas fa-phone-alt"></i> Contacto de Emergencia</h2>
                    <div class="info-grid">
                        <div class="form-group"><label>Nombre del Contacto</label><input type="text" name="nombre_contacto" value="<?= htmlspecialchars($usuario['nombre_contacto']) ?>"></div>
                        <div class="form-group"><label>Parentesco</label>
                            <select name="parentesco">
                                <option value="Padre" <?= $usuario['parentesco']=='Padre'?'selected':'' ?>>Padre</option>
                                <option value="Madre" <?= $usuario['parentesco']=='Madre'?'selected':'' ?>>Madre</option>
                                <option value="Hermano/a" <?= $usuario['parentesco']=='Hermano/a'?'selected':'' ?>>Hermano/a</option>
                                <option value="Esposo/a" <?= $usuario['parentesco']=='Esposo/a'?'selected':'' ?>>Esposo/a</option>
                                <option value="Pareja" <?= $usuario['parentesco']=='Pareja'?'selected':'' ?>>Pareja</option>
                            </select>
                        </div>
                        <div class="form-group"><label>Teléfono de Contacto</label><input type="text" name="contacto_emergencia" maxlength="8" value="<?= htmlspecialchars($usuario['contacto_emergencia']) ?>"></div>
                    </div>
                </div>

                <button type="submit" class="btn-save"><i class="fas fa-save"></i> Guardar Cambios</button>
            </form>
        </div>
    </div>

    <script>
    function validarDNI(input) {
        let original = input.value;
        let limpio = original.replace(/[^0-9]/g, '');
        input.value = limpio;
        let aviso = document.getElementById('dni_warning');
        if (original !== limpio) {
            aviso.style.display = 'block';
            setTimeout(() => { aviso.style.display = 'none'; }, 3000);
        } else {
            aviso.style.display = 'none';
        }
    }
    </script>
</body>
</html>