<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Vacaciones - Panel RRHH</title>
    <style>
        table {
            width: 90%;
            margin: 20px auto;
            border-collapse: collapse;
            font-family: Arial;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 10px;
            text-align: center;
        }
        th {
            background-color: #f3f3f3;
        }
        input[type="text"] {
            margin: 20px auto;
            display: block;
            padding: 8px;
            width: 300px;
            font-size: 16px;
        }
    </style>
</head>
<body>

<h2 style="text-align: center;">Control de Vacaciones - RRHH</h2>

<input type="text" id="buscador" placeholder="Buscar empleado por nombre...">

<table id="tabla-rrhh">
    <thead>
        <tr>
            <th>Empleado</th>
            <th>Días Asignados</th>
            <th>Días Utilizados</th>
            <th>Días Disponibles</th>
        </tr>
    </thead>
    <tbody></tbody>
</table>

<script>
fetch("vacaciones_rrhh.php")
    .then(res => res.json())
    .then(data => {
        const tbody = document.querySelector("#tabla-rrhh tbody");
        tbody.innerHTML = "";
        data.forEach(row => {
            tbody.innerHTML += `
                <tr>
                    <td>${row.nombre_empleado}</td>
                    <td>${row.asignados}</td>
                    <td>${row.utilizados}</td>
                    <td>${row.disponibles}</td>
                </tr>`;
        });
    });

// Buscador
document.getElementById("buscador").addEventListener("input", function () {
    const filtro = this.value.toLowerCase();
    document.querySelectorAll("#tabla-rrhh tbody tr").forEach(fila => {
        const nombre = fila.children[0].textContent.toLowerCase();
        fila.style.display = nombre.includes(filtro) ? "" : "none";
    });
});
</script>

</body>
</html>
