<?php
session_start();
require 'conexion.php';

// Validar sesión y rol (Permitir rol 9 y 11)
if (!isset($_SESSION['user_id']) || ($_SESSION['role'] != 11 && $_SESSION['role'] != 9)) {
    header('Location: login.php');
    exit;
}
$user_id = $_SESSION['user_id'];
$nombre_usuario = $_SESSION['Nom'];

// Obtener TODOS los datos del usuario para la ficha
$sql = "SELECT a.*, u.nombre_unidad, j.nombre_jefe, p.nombre_puesto 
        FROM accounts a
        LEFT JOIN unidad u ON a.cod_unidad = u.cod_unidad
        LEFT JOIN jefes j ON a.cod_jefe = j.cod_jefe
        LEFT JOIN puestos p ON a.cod_puesto = p.cod_puesto
        WHERE a.id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$usuario = $result->fetch_assoc();
$stmt->close();
$conn->close();

if (!$usuario) {
    echo "Error: Usuario no encontrado.";
    exit;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ficha Completa del Empleado - RRHH</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <style>
        :root { --primary-dark: #2c3e50; --secondary-blue: #34495e; --accent-cyan: #68c8d8; --success-green: #27ae60; --bg-light: #f0f4f8; }
        
        body { background-color: var(--bg-light); font-family: 'Roboto', sans-serif; margin: 0; padding: 0; color: #333; }
        .container { display: flex; min-height: 100vh; }

        /* Sidebar con Scroll Independiente */
        .sidebar {
            width: 260px; background: linear-gradient(135deg, var(--primary-dark), var(--secondary-blue)); color:white;
            padding:20px 15px; position:fixed; height:100%; overflow-y: auto; z-index: 1000;
        }
        .sidebar h2 { font-size:22px; margin-bottom:25px; text-align:center; color: var(--accent-cyan); font-weight: 700; border-bottom: 1px solid rgba(255,255,255,0.1); padding-bottom: 15px; }
        .sidebar ul { list-style:none; padding:0; }
        .sidebar ul li { margin-bottom:5px; }
        .sidebar ul li a {
            color:#ecf0f1; text-decoration:none; font-size:14px; display:flex; align-items:center;
            padding:12px 15px; border-radius:8px; transition:0.3s ease;
        }
        .sidebar ul li a:hover { background:rgba(255,255,255,0.1); color: var(--accent-cyan); padding-left: 20px; }
        .sidebar ul li a i { margin-right:12px; width: 20px; text-align: center; font-size: 16px; }

        /* Main Content */
        .main-content { margin-left:260px; padding:40px; width:calc(100% - 260px); }
        .header { text-align:left; margin-bottom:30px; border-bottom: 2px solid #ddd; padding-bottom: 15px; }
        .header h1 { font-size:26px; margin: 0; color: var(--primary-dark); }
        .header p { color:#7f8c8d; font-size: 15px; margin-top: 5px; }

        /* Cards Organizadas */
        .card {
            background:white; border-radius:12px; box-shadow:0 5px 15px rgba(0,0,0,0.05);
            margin-bottom:30px; padding:25px; border-left: 5px solid var(--accent-cyan);
        }
        .card h2 {
            font-size:19px; margin-bottom:20px; color:var(--secondary-blue); display:flex; align-items:center;
            font-weight: 600;
        }
        .card h2 i { margin-right:12px; color: var(--accent-cyan); }

        .info-grid { display:grid; grid-template-columns:repeat(auto-fit, minmax(220px, 1fr)); gap:20px; }
        .form-group label { display:block; font-weight:500; margin-bottom:8px; color:#555; font-size: 13px; }
        .form-group input, .form-group select {
            width:100%; padding:11px; border:1px solid #dcdfe6; border-radius:6px; font-size:14px; box-sizing: border-box; transition: 0.3s;
        }
        .form-group input:focus { border-color: var(--accent-cyan); outline: none; box-shadow: 0 0 5px rgba(104,200,216,0.3); }
        input[readonly] { background-color: #f8f9fa; color: #7f8c8d; cursor: not-allowed; border: 1px dashed #ccc; }

        /* Validaciones Visuales */
        .error-input { border-color: #e74c3c !important; background-color: #fff6f6; }
        .error-text { color: #e74c3c; font-size: 11px; margin-top: 5px; display: none; font-weight: bold; }

        .btn-save {
            display:block; margin:40px auto; padding:16px 60px;
            background: linear-gradient(135deg, var(--success-green), #219653); color:white; border-radius:35px;
            font-weight:600; border:none; cursor:pointer; font-size:16px; transition: 0.4s;
            box-shadow: 0 4px 15px rgba(39,174,96,0.3);
        }
        .btn-save:hover { transform: translateY(-3px); box-shadow: 0 8px 20px rgba(39,174,96,0.4); }

        @media(max-width:992px){ .sidebar { width: 70px; } .sidebar h2, .sidebar a span { display: none; } .main-content { margin-left: 70px; width: calc(100% - 70px); } }
    </style>
</head>
<body>

    <div class="container">
        <div class="sidebar">
            <h2>Panel RRHH</h2>
            <ul>
                <li><a href="dashboard_rrhh.php"><i class="fas fa-home"></i> <span>Inicio</span></a></li>
                <?php if ($_SESSION['role'] != 11): ?>
                    <li><a href="gestionar_solicitudes_rrhh.php"><i class="fas fa-tasks"></i> <span>Gestionar Solicitudes</span></a></li>
                <?php endif; ?>
                <li><a href="panel_jefe_rrhh.php"><i class="fas fa-chart-bar"></i> <span>Solicitudes Unidad</span></a></li>
                <li><a href="panel_rrhh_vacaciones.php"><i class="fas fa-umbrella-beach"></i> <span>Vacaciones RRHH</span></a></li>
                <li><a href="estadisticas_rrhh.php"><i class="fas fa-chart-line"></i> <span>Estadísticas</span></a></li>
                <li><a href="solicitudes_aprobadas_rrhh.php"><i class="fas fa-check-circle"></i> <span>Historial Aprobado</span></a></li>
                <li><a href="ver_solicitudes.php"><i class="fas fa-eye"></i> <span>Más Solicitudes</span></a></li>
                
                <?php if ($_SESSION['role'] != 11): ?>
                    <li><a href="gestionar_empleados.php"><i class="fas fa-users"></i> <span>Gestión de Empleados</span></a></li>
                <?php endif; ?>
                
                <li><a href="panel_vacaciones_rrhh.php"><i class="fas fa-calendar-alt"></i> <span>Gestión Vacaciones</span></a></li>
                
                <?php if ($_SESSION['role'] != 11): ?>
                    <li><a href="gestionar_unidades_puestos.php"><i class="fas fa-building"></i> <span>Unidades y Puestos</span></a></li>
                    <li><a href="asignar_privilegios_rrhh.php"><i class="fas fa-user-shield"></i> <span>Asignar Rol</span></a></li>
                <?php endif; ?>

                <li><a href="https://sistemas.proasol.gob.hn/denuncias_proasol/index.html?src=rrhh_sidebar" target="_blank"><i class="fas fa-shield-alt"></i> <span>Denuncia-CPEP</span></a></li>
                <li><a href="panel_rrhh_user.php"><i class="fas fa-user-circle"></i> <span>Mi Perfil</span></a></li>
                <li><a href="logout.php" style="color: #ff7675;"><i class="fas fa-sign-out-alt"></i> <span>Cerrar Sesión</span></a></li>
            </ul>
        </div>

        <div class="main-content">
            <div class="header">
                <h1>Ficha Integral del Empleado</h1>
                <p>Usuario: <strong><?= htmlspecialchars($usuario['username']) ?></strong> | Nombre: <?= htmlspecialchars($nombre_usuario) ?></p>
            </div>

            <form id="profileForm" action="actualizar_perfil_rrhh.php" method="POST">
                
                <div class="card">
                    <h2><i class="fas fa-id-card"></i> Datos Personales y de Identidad</h2>
                    <div class="info-grid">
                        <div class="form-group">
                            <label>DNI (Identidad Hondureña)</label>
                            <input type="text" name="dni" id="dni" value="<?= htmlspecialchars($usuario['dni']) ?>" maxlength="13" required oninput="validarIdentidad(this)">
                            <span id="dniError" class="error-text">Debe contener exactamente 13 dígitos.</span>
                        </div>
                        <div class="form-group"><label>Primer Nombre</label><input type="text" name="Nom" value="<?= htmlspecialchars($usuario['Nom']) ?>" required></div>
                        <div class="form-group"><label>Segundo Nombre</label><input type="text" name="Nom2" value="<?= htmlspecialchars($usuario['Nom2']) ?>"></div>
                        <div class="form-group"><label>Primer Apellido</label><input type="text" name="Ape" value="<?= htmlspecialchars($usuario['Ape']) ?>" required></div>
                        <div class="form-group"><label>Segundo Apellido</label><input type="text" name="Ape2" value="<?= htmlspecialchars($usuario['Ape2']) ?>"></div>
                        <div class="form-group"><label>Fecha Nacimiento</label><input type="date" name="FechaNacimiento" value="<?= htmlspecialchars($usuario['FechaNacimiento']) ?>"></div>
                        <div class="form-group"><label>Género</label>
                            <select name="Genero">
                                <option value="M" <?= $usuario['Genero']=='M'?'selected':'' ?>>Masculino</option>
                                <option value="F" <?= $usuario['Genero']=='F'?'selected':'' ?>>Femenino</option>
                            </select>
                        </div>
                        <div class="form-group"><label>Estado Civil</label>
                            <select name="estado_civil">
                                <option value="Soltero" <?= $usuario['estado_civil']=='Soltero'?'selected':'' ?>>Soltero/a</option>
                                <option value="Casado" <?= $usuario['estado_civil']=='Casado'?'selected':'' ?>>Casado/a</option>
                            </select>
                        </div>
                        <div class="form-group"><label>Número de Hijos</label><input type="number" name="numero_hijos" value="<?= htmlspecialchars($usuario['numero_hijos']) ?>"></div>
                        <div class="form-group"><label>Teléfono</label><input type="text" name="telefono" value="<?= htmlspecialchars($usuario['telefono']) ?>" maxlength="8" oninput="validarNumeros(this)"></div>
                        <div class="form-group"><label>Correo Personal</label><input type="email" name="correo_personal" value="<?= htmlspecialchars($usuario['correo_personal']) ?>"></div>
                    </div>
                </div>

                <div class="card">
                    <h2><i class="fas fa-briefcase"></i> Detalle Institucional</h2>
                    <div class="info-grid">
                        <div class="form-group"><label>N° Empleado</label><input type="text" name="numero_empleado" value="<?= htmlspecialchars($usuario['numero_empleado']) ?>"></div>
                        <div class="form-group"><label>Fecha Ingreso</label><input type="date" name="fecha_ingreso" value="<?= htmlspecialchars($usuario['fecha_ingreso']) ?>"></div>
                        <div class="form-group"><label>Puesto Actual</label><input type="text" value="<?= htmlspecialchars($usuario['nombre_puesto']) ?>" readonly></div>
                        <div class="form-group"><label>Unidad/Dirección</label><input type="text" value="<?= htmlspecialchars($usuario['nombre_unidad']) ?>" readonly></div>
                        <div class="form-group"><label>Tipo Contrato</label>
                            <select name="tipo_contrato">
                                <option value="Acuerdo" <?= $usuario['tipo_contrato']=='Acuerdo'?'selected':'' ?>>Acuerdo</option>
                                <option value="Contrato" <?= $usuario['tipo_contrato']=='Contrato'?'selected':'' ?>>Contrato</option>
                            </select>
                        </div>
                        <div class="form-group"><label>Jefe Inmediato</label><input type="text" value="<?= htmlspecialchars($usuario['nombre_jefe']) ?>" readonly></div>
                        <div class="form-group"><label>Correo Institucional</label><input type="text" value="<?= htmlspecialchars($usuario['CorreoElectronico']) ?>" readonly></div>
                    </div>
                </div>

                <div class="card">
                    <h2><i class="fas fa-heartbeat"></i> Formación y Perfil de Salud</h2>
                    <div class="info-grid">
                        <div class="form-group"><label>Nivel Educativo</label>
                            <select name="nivel_educativo">
                                <option value="Secundaria" <?= $usuario['nivel_educativo']=='Secundaria'?'selected':'' ?>>Secundaria</option>
                                <option value="Pregrado" <?= $usuario['nivel_educativo']=='Pregrado'?'selected':'' ?>>Pregrado (Licenciatura/Ing)</option>
                                <option value="Posgrado" <?= $usuario['nivel_educativo']=='Posgrado'?'selected':'' ?>>Posgrado (Maestría/Doc)</option>
                            </select>
                        </div>
                        <div class="form-group"><label>Profesión</label><input type="text" name="profesion" value="<?= htmlspecialchars($usuario['profesion']) ?>"></div>
                        <div class="form-group"><label>Tipo de Sangre</label>
                            <select name="tipo_sangre">
                                <option value="O+" <?= $usuario['tipo_sangre']=='O+'?'selected':'' ?>>O+</option>
                                <option value="A+" <?= $usuario['tipo_sangre']=='A+'?'selected':'' ?>>A+</option>
                                <option value="B+" <?= $usuario['tipo_sangre']=='B+'?'selected':'' ?>>B+</option>
                                <option value="O-" <?= $usuario['tipo_sangre']=='O-'?'selected':'' ?>>O-</option>
                            </select>
                        </div>
                        <div class="form-group"><label>Enfermedades Crónicas</label><input type="text" name="enfermedad" value="<?= htmlspecialchars($usuario['enfermedad']) ?>" placeholder="Ninguna"></div>
                    </div>
                </div>

                <div class="card">
                    <h2><i class="fas fa-ambulance"></i> Contacto de Emergencia</h2>
                    <div class="info-grid">
                        <div class="form-group"><label>Nombre del Contacto</label><input type="text" name="nombre_contacto" value="<?= htmlspecialchars($usuario['nombre_contacto']) ?>"></div>
                        <div class="form-group"><label>Parentesco</label><input type="text" name="parentesco" value="<?= htmlspecialchars($usuario['parentesco']) ?>"></div>
                        <div class="form-group"><label>Teléfono Emergencia</label><input type="text" name="contacto_emergencia" value="<?= htmlspecialchars($usuario['contacto_emergencia']) ?>" maxlength="8" oninput="validarNumeros(this)"></div>
                    </div>
                </div>

                <button type="submit" class="btn-save" id="btnSubmit"><i class="fas fa-save"></i> Guardar Ficha Completa</button>
            </form>
        </div>
    </div>

    <script>
        // Función para validar que solo entren números
        function validarNumeros(input) {
            input.value = input.value.replace(/[^0-9]/g, '');
        }

        // Validación específica del DNI Hondureño (13 dígitos)
        function validarIdentidad(input) {
            validarNumeros(input);
            const errorText = document.getElementById('dniError');
            const btn = document.getElementById('btnSubmit');

            if (input.value.length > 0 && input.value.length < 13) {
                input.classList.add('error-input');
                errorText.style.display = 'block';
                input.setCustomValidity("Incompleto");
            } else {
                input.classList.remove('error-input');
                errorText.style.display = 'none';
                input.setCustomValidity("");
            }
        }

        // SweetAlert para confirmación de éxito
        const urlParams = new URLSearchParams(window.location.search);
        if (urlParams.has('success')) {
            Swal.fire({
                icon: 'success',
                title: '¡Ficha Actualizada!',
                text: 'Los cambios se han guardado exitosamente en el sistema.',
                confirmButtonColor: '#27ae60'
            });
        }
    </script>
</body>
</html>