<?php
session_start();
require 'conexion.php';

// Asegurarse de que el usuario esté autenticado y tenga el rol correcto (cod_rol = 8)
if (!isset($_SESSION['user_id']) || !isset($_SESSION['role']) || $_SESSION['role'] != 9) {
    $_SESSION['error'] = 'Acceso no autorizado. Por favor, inicia sesión con una cuenta de Jefe de Departamento válida.';
    header("Location: login.php");
    exit;
}

$userId = $_SESSION['user_id'];
$unidadJefe = null;

// Obtener cod_unidad del jefe
$stmtUnidad = $conn->prepare("SELECT cod_unidad FROM accounts WHERE ID = ?");
$stmtUnidad->bind_param("i", $userId);
$stmtUnidad->execute();
$stmtUnidad->bind_result($unidadJefe);
$stmtUnidad->fetch();
$stmtUnidad->close();

// Consulta de solicitudes filtradas por unidad
$sql = "
SELECT 
    s.id AS id_solicitud, 
    v.id_vacacion, 
    v.id_usuario, 
    v.fecha_inicio, 
    v.fecha_fin, 
    v.dias,
    a.Nom, 
    a.Nom2, 
    a.Ape, 
    a.Ape2
FROM vacaciones v
JOIN solicitudes s ON v.id_solicitud = s.id
JOIN accounts a ON v.id_usuario = a.ID
WHERE s.id IN (
    SELECT MAX(s2.id)
    FROM solicitudes s2
    JOIN vacaciones v2 ON v2.id_solicitud = s2.id
    WHERE s2.tipo_permiso = 'Vacaciones'
      AND s2.estado = 'Pendiente'
      AND v2.fecha_inicio >= '2025-07-01'
      AND v2.fecha_fin <= '2025-12-31'
    GROUP BY s2.id_usuario
)
AND a.cod_unidad = ?
AND a.cod_rol IN (7, 9)
AND a.cod_jefe = 2
ORDER BY s.id DESC;
";



$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $unidadJefe);
$stmt->execute();
$result = $stmt->get_result();



?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Panel Jefe de Departamento - Solicitudes de Vacaciones Pendientes</title>
      <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Roboto', sans-serif;
        }

        body {
            background-color: #f0f4f8;
            color: #2c3e50;
            line-height: 1.6;
        }

        .container {
            display: flex;
            min-height: 100vh;
        }

        /* Sidebar */
        .sidebar {
            width: 260px;
            background: linear-gradient(135deg, #2c3e50, #34495e);
            color: white;
            padding: 20px 15px;
            position: fixed;
            height: 100%;
            transition: transform 0.3s ease;
            z-index: 1000;
        }

        .sidebar.collapsed {
            transform: translateX(-260px);
            width: 0;
        }

        .sidebar h2 {
            font-size: 24px;
            margin-bottom: 30px;
            text-align: center;
            color: #68c8d8;
        }

        .sidebar ul {
            list-style: none;
        }

        .sidebar ul li {
            margin-bottom: 15px;
        }

        .sidebar ul li a {
            color: #ecf0f1;
            text-decoration: none;
            font-size: 16px;
            display: flex;
            align-items: center;
            padding: 10px 15px;
            border-radius: 5px;
            transition: background 0.3s, color 0.3s;
        }

        .sidebar ul li a:hover {
            background: #465c71;
            color: #68c8d8;
        }

        .sidebar ul li a i {
            margin-right: 10px;
        }

        .toggle-btn {
            display: none;
            position: fixed;
            left: 10px;
            top: 10px;
            background: #68c8d8;
            color: white;
            border: none;
            padding: 10px;
            border-radius: 5px;
            cursor: pointer;
            z-index: 1001;
            transition: background 0.3s;
        }

        .toggle-btn:hover {
            background: #5dade2;
        }

        /* Main Content */
        .main-content {
            flex-grow: 1;
            padding: 30px;
            margin-left: 260px;
            transition: margin-left 0.3s ease;
            width: calc(100% - 260px);
        }

        .welcome-message {
            font-size: 28px;
            color: #2c3e50;
            margin-bottom: 25px;
            text-align: center;
            font-weight: 500;
        }

        .main-content h1 {
            font-size: 32px;
            color: #2c3e50;
            margin-bottom: 30px;
            text-align: center;
            border-bottom: 3px solid #68c8d8;
            padding-bottom: 10px;
            font-weight: 700;
        }

        /* Sections Grid */
        .dashboard-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 20px;
            overflow-x: auto; /* Permite desplazamiento horizontal si es necesario */
        }

        /* Solicitud Card */
        .solicitud-card {
            background: white;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            transition: transform 0.2s;
            display: flex;
            flex-direction: column;
            min-height: 400px; /* Mínimo para mantener estructura */
        }

        .solicitud-card:hover {
            transform: translateY(-5px);
        }

        .solicitud-card p {
            margin-bottom: 10px;
            font-size: 15px;
            color: #555;
            line-height: 1.5;
            word-wrap: break-word; /* Ajusta texto largo */
        }

        .solicitud-card p strong {
            color: #2c3e50;
            font-weight: 500;
        }

        .solicitud-card form {
            margin-top: auto;
            display: flex;
            flex-direction: column;
            gap: 10px;
        }

        .solicitud-card textarea {
            width: 100%;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 5px;
            resize: vertical; /* Permite redimensionar verticalmente */
            font-size: 14px;
            min-height: 60px;
            transition: border-color 0.3s;
        }

        .solicitud-card textarea:focus {
            border-color: #68c8d8;
            outline: none;
        }

        .solicitud-card .button-group {
            display: flex;
            gap: 10px;
            flex-wrap: wrap; /* Ajuste en pantallas pequeñas */
        }

        .solicitud-card button {
            flex: 1;
            padding: 12px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 15px;
            transition: background 0.3s, transform 0.2s;
            font-weight: 500;
            min-width: 100px; /* Mínimo ancho para botones */
        }

        .solicitud-card button[name="accion"][value="Aprobar"] {
            background: linear-gradient(135deg, #27ae60, #219653);
            color: white;
        }

        .solicitud-card button[name="accion"][value="Aprobar"]:hover {
            background: linear-gradient(135deg, #219653, #1e8449);
            transform: translateY(-2px);
        }

        .solicitud-card button[name="accion"][value="Rechazar"] {
            background: linear-gradient(135deg, #c0392b, #a93226);
            color: white;
        }

        .solicitud-card button[name="accion"][value="Rechazar"]:hover {
            background: linear-gradient(135deg, #a93226, #922b21);
            transform: translateY(-2px);
        }

        /* Responsive Design */
        @media (max-width: 1024px) {
            .sidebar {
                width: 220px;
            }
            .main-content {
                margin-left: 220px;
                width: calc(100% - 220px);
                padding: 25px;
            }
        }

        @media (max-width: 768px) {
            .toggle-btn {
                display: block;
            }
            .sidebar {
                transform: translateX(-260px);
                width: 260px;
            }
            .sidebar.open {
                transform: translateX(0);
            }
            .main-content {
                margin-left: 0;
                width: 100%;
                padding: 20px;
            }
            .dashboard-grid {
                grid-template-columns: 1fr;
            }
            .solicitud-card {
                min-height: auto;
                padding: 15px;
            }
            .solicitud-card .button-group {
                flex-direction: column;
            }
            .solicitud-card button {
                width: 100%;
            }
        }

        @media (max-width: 480px) {
            .sidebar {
                padding: 10px;
            }
            .sidebar h2 {
                font-size: 18px;
                margin-bottom: 15px;
            }
            .sidebar ul li a {
                font-size: 14px;
                padding: 6px 10px;
            }
            .main-content {
                padding: 10px;
            }
            .welcome-message {
                font-size: 20px;
            }
            .main-content h1 {
                font-size: 24px;
            }
            .solicitud-card p {
                font-size: 14px;
            }
            .solicitud-card textarea {
                font-size: 13px;
                min-height: 50px;
            }
            .solicitud-card button {
                font-size: 14px;
                padding: 8px;
            }
        }
    </style>
</head>
<body>
    <button class="toggle-btn" onclick="toggleSidebar()"><i class="fas fa-bars"></i></button>
    <div class="container">
        <!-- Menú lateral -->
        <div class="sidebar" id="sidebar">
            <h2>Panel Jefe</h2>
             <ul>
        <li><a href="dashboard_rrhh.php"><i class="fas fa-home"></i> Inicio</a></li>
        <?php if ($_SESSION['role'] != 11): ?>
            <li><a href="gestionar_solicitudes_rrhh.php"><i class="fas fa-tasks"></i> Gestionar Solicitudes</a></li>
        <?php endif; ?>
        <li><a href="panel_jefe_rrhh.php"><i class="fas fa-chart-bar"></i>Solicitudes Unidad RRHH</a></li>
         <li><a href="panel_rrhh_vacaciones.php"><i class="fas fa-chart-bar"></i>Solicitudes Vacaciones RRHH</a></li>
        <li><a href="estadisticas_rrhh.php"><i class="fas fa-chart-bar"></i> Estadísticas</a></li>
        <li><a href="solicitudes_aprobadas_rrhh.php"><i class="fas fa-check"></i> Historial de Solicitudes Aprobadas</a></li>
        <li><a href="ver_solicitudes.php"><i class="fas fa-eye"></i> Más Solicitudes</a></li>
        <?php if ($_SESSION['role'] != 11): ?>
            <li><a href="gestionar_empleados.php"><i class="fas fa-users"></i> Gestión de Empleados</a></li>
        <?php endif; ?>
        <li><a href="panel_vacaciones_rrhh.php"><i class="fas fa-umbrella-beach"></i> Gestión de Vacaciones</a></li>
        <?php if ($_SESSION['role'] != 11): ?>
            <li><a href="gestionar_unidades_puestos.php"><i class="fas fa-building"></i> Unidades y Puestos</a></li>
            <li><a href="asignar_privilegios_rrhh.php"><i class="fas fa-user-shield"></i> Asignar Rol</a></li>
        <?php endif; ?>

        <!-- ✅ NUEVO: acceso directo al Portal de Denuncias -->
        <li>
            <a href="https://sistemas.proasol.gob.hn/denuncias_proasol/index.html?src=rrhh_sidebar"
               target="_blank" rel="noopener">
               <i class="fas fa-shield-alt"></i> Denuncia-CPEP
            </a>
        </li>

        <li><a href="panel_rrhh_user.php"><i class="fas fa-user"></i> Perfil</a></li>
        <li><a href="logout.php"><i class="fas fa-sign-out-alt"></i> Cerrar Sesión</a></li>
    </ul>
        </div>

        <!-- Contenido principal -->
        <div class="main-content">
            <div class="welcome-message">Bienvenido, <?= htmlspecialchars($_SESSION['Nom']) ?> <span style="font-size: 14px; color: #7f8c8d;">(<?= date('h:i A T') ?>)</span></div>
            <h1>Solicitudes de Vacaciones Pendientes - Panel Jefe de Departamento</h1>

            <!-- Dashboard Grid -->
            <div class="dashboard-grid">
                <?php if ($result->num_rows > 0): ?>
                    <?php while ($row = $result->fetch_assoc()): ?>
                        <div class="solicitud-card">
                            <p><strong>Funcionario:</strong> 
                                <?= htmlspecialchars($row['Nom'] . ' ' . $row['Nom2'] . ' ' . $row['Ape'] . ' ' . $row['Ape2']) ?>
                            </p>
                            <p><strong>Fecha de inicio:</strong> <?= htmlspecialchars($row['fecha_inicio']) ?></p>
                            <p><strong>Fecha de fin:</strong> <?= htmlspecialchars($row['fecha_fin']) ?></p>
                            <p><strong>Días solicitados:</strong> <?= htmlspecialchars($row['dias']) ?></p>

                            <form action="procesar_revision_vacaciones.php" method="POST">
                                <input type="hidden" name="id_solicitud" value="<?= $row['id_solicitud'] ?>">
                                <textarea name="comentario" placeholder="Comentario (opcional)"></textarea>
                                <div class="button-group">
                                    <button type="submit" name="accion" value="Aprobar">✅ Aprobar
                                    </button>
                                    <button type="submit" name="accion" value="Rechazar">❌ Rechazar</button>
                                </div>
                            </form>
                        </div>
                    <?php endwhile; ?>
                <?php else: ?>
                    <div class="solicitud-card" style="text-align: center; min-height: 200px; justify-content: center;">
                        <p style="color: #777;">No hay solicitudes pendientes.</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <script>
        function toggleSidebar() {
            const sidebar = document.getElementById('sidebar');
            sidebar.classList.toggle('open');
            const mainContent = document.querySelector('.main-content');
            if (sidebar.classList.contains('open')) {
                mainContent.style.marginLeft = '260px';
                mainContent.style.width = 'calc(100% - 260px)';
            } else {
                mainContent.style.marginLeft = '0';
                mainContent.style.width = '100%';
            }
        }
    </script>
    



    <?php $conn->close(); ?>
 
</body>
</html>
