<?php
session_start();
require 'conexion.php';

// Verificar que el usuario esté autenticado
if (!isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit;
}

// ✅ Función para redirigir según rol
function obtenerDashboardPorRol($role) {
    switch ($role) {
        case 7: return "dashboard_usuario.php";
        case 8: return "dashboard_jefe.php";
        case 9: 
        case 11: return "dashboard_rrhh.php";
        case 12: return "dashboard_directora.php";
        default: return "login.php";
    }
}

$user_id = $_SESSION['user_id'];

// Obtener el nombre completo, username, unidad y jefe del usuario desde la tabla accounts
$sql_usuario = "SELECT Nom, Nom2, Ape, Ape2, username, cod_unidad, cod_jefe, cod_puesto FROM accounts WHERE ID = ?";
if ($stmt = $conn->prepare($sql_usuario)) {
    $stmt->bind_param('i', $user_id);
    $stmt->execute();
    $stmt->bind_result($nom, $nom2, $ape, $ape2, $username, $cod_unidad, $cod_jefe, $cod_puesto);
    $stmt->fetch();

    $nombre_completo = trim(implode(' ', array_filter([$nom, $nom2, $ape, $ape2])));
    $_SESSION['nombre_completo'] = $nombre_completo;
    $_SESSION['username'] = $username ?? 'Usuario no encontrado';

    $stmt->close();

    if ($cod_unidad) {
        $sql_unidad = "SELECT nombre_unidad FROM unidad WHERE cod_unidad = ?";
        if ($stmt_unidad = $conn->prepare($sql_unidad)) {
            $stmt_unidad->bind_param('i', $cod_unidad);
            $stmt_unidad->execute();
            $stmt_unidad->bind_result($nombre_unidad);
            $stmt_unidad->fetch();
            $_SESSION['unidad'] = $nombre_unidad ?? 'Unidad no encontrada';
            $stmt_unidad->close();
        } else {
            $_SESSION['unidad'] = 'Error al obtener la unidad';
        }
    } else {
        $_SESSION['unidad'] = 'Unidad no asignada';
    }

    if ($cod_puesto) {
        $sql_puesto = "SELECT nombre_puesto FROM puestos WHERE cod_puesto = ?";
        if ($stmt_puesto = $conn->prepare($sql_puesto)) {
            $stmt_puesto->bind_param('i', $cod_puesto);
            $stmt_puesto->execute();
            $stmt_puesto->bind_result($nombre_puesto);
            $stmt_puesto->fetch();
            $_SESSION['puesto'] = $nombre_puesto ?? 'Unidad no encontrada';
            $stmt_puesto->close();
        } else {
            $_SESSION['puesto'] = 'Error al obtener la unidad';
        }
    } else {
        $_SESSION['puesto'] = 'Unidad no asignada';
    }

    if ($cod_jefe) {
        $sql_jefe = "SELECT nombre_jefe FROM jefes WHERE cod_jefe = ?";
        if ($stmt_jefe = $conn->prepare($sql_jefe)) {
            $stmt_jefe->bind_param('i', $cod_jefe);
            $stmt_jefe->execute();
            $stmt_jefe->bind_result($nombre_jefe);
            $stmt_jefe->fetch();
            $_SESSION['nombre_jefe_inmediato'] = $nombre_jefe ?? 'Jefe no encontrado';
            $stmt_jefe->close();
        } else {
            $_SESSION['nombre_jefe_inmediato'] = 'Error al obtener el jefe';
        }
    } else {
        $_SESSION['nombre_jefe_inmediato'] = 'Jefe no asignado';
    }
} else {
    $_SESSION['nombre_completo'] = "Error al obtener el nombre";
    $_SESSION['username'] = "Error al obtener el usuario";
    $_SESSION['unidad'] = 'Error al obtener la unidad';
    $_SESSION['puesto'] = 'Error al obtener el puesto';
    $_SESSION['nombre_jefe_inmediato'] = 'Error al obtener el jefe';
}

// Verificar el estado de la solicitud
$solicitud_aprobada = false;
$fecha_aprobacion_jefe = '';
$fecha_aprobacion_rrhh = '';
$sql_estado = "SELECT estado, fecha_aprobacion_jefe, fecha_aprobacion_rrhh FROM solicitudes WHERE id_usuario = ? AND estado = 'Aprobada por Recursos Humanos' LIMIT 1";
if ($stmt = $conn->prepare($sql_estado)) {
    $stmt->bind_param('i', $user_id);
    $stmt->execute();
    $stmt->bind_result($estado, $fecha_aprobacion_jefe, $fecha_aprobacion_rrhh);
    $solicitud_aprobada = $stmt->fetch();
    $stmt->close();
}

date_default_timezone_set('America/Tegucigalpa');
$fecha_solicitud = date('Y-m-d\TH:i');

$conn->close();
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pase de Salida</title>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f5f5f5;
            margin: 0;
            padding: 0;
        }

        .container {
            max-width: 800px;
            margin: 20px auto;
            background-color: white;
            padding: 20px;
            border: 1px solid #ccc;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            position: relative;
        }

        .ribbon {
            position: absolute;
            top: 0;
            left: 0;
            width: 10px;
            height: 100%;
            background-color: #68c8d8;
        }

        header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }

        header h1 {
            font-size: 24px;
            margin: 0;
            color: #333;
        }

        .logo-left img {
            width: 100px;
            height: 100px;
        }

        .logo-right img {
            width: 150px;
            height: 100px;
        }

     
        /* 🔙 Botón Atrás flotante */
        .back-button {
            position: fixed;
            bottom: 20px;
            left: 20px;
            background: linear-gradient(135deg, #e74c3c, #c0392b);
            color: white;
            padding: 12px 20px;
            border-radius: 8px;
            font-size: 15px;
            font-weight: 600;
            text-decoration: none;
            box-shadow: 0 4px 8px rgba(0,0,0,0.2);
            transition: background 0.3s, transform 0.2s;
            z-index: 999;
        }
        .back-button:hover {
            background: linear-gradient(135deg, #c0392b, #e74c3c);
            transform: translateY(-2px);
        }

        .form-group { margin-bottom: 15px; }
        .form-group label { display: block; font-weight: bold; margin-bottom: 5px; }
        .form-group input,
        .form-group textarea,
        .form-group select {
            width: 100%; padding: 8px; border: 1px solid #ccc; border-radius: 4px; box-sizing: border-box;
        }
        .form-group textarea { resize: vertical; }

        .form-group.inline { display: flex; gap: 20px; }
        .form-group.inline > div { flex: 1; }

        .form-group.inline .motivo {
            display: flex; align-items: center; gap: 10px;
        }

        .signatures { margin-top: 30px; display: flex; justify-content: space-between; flex-wrap: wrap; border-top: 1px solid #ccc; padding-top: 15px; }
        .signatures div { text-align: center; font-size: 13px; }
        .signatures label { font-weight: bold; }
        .signatures span { display: block; margin-top: 5px; }

        .print-button, .save-button {
            display: block; margin: 20px auto; padding: 10px 20px; border: none; border-radius: 5px;
            font-size: 16px; cursor: pointer; transition: background 0.3s;
        }
        .print-button { background-color: #68c8d8; color: white; display: <?php echo $solicitud_aprobada ? 'block' : 'none'; ?>; }
        .print-button:hover { background-color: #56b0c0; }
        .save-button { background-color: #28a745; color: white; }
        .save-button:hover { background-color: #218838; }

        .approval-message {
            display: <?php echo $solicitud_aprobada ? 'none' : 'block'; ?>;
            text-align: center; margin: 20px auto; padding: 10px 20px;
            background-color: #f8d7da; color: #721c24; border: 1px solid #f5c6cb;
            border-radius: 5px; font-size: 16px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="ribbon"></div>
        <header>
            <div class="logo-left"><img src="logo-proasol.png" alt="Logo PROASOL"></div>
            <h1>Pase de Salida</h1>
            <div class="logo-right"><img src="gobierno-logo.png" alt="Logo HONDUR"></div>
        </header>

        <!-- 🔙 Botón Atrás -->
        <a href="<?= obtenerDashboardPorRol($_SESSION['role'] ?? 0) ?>" class="back-button">⬅ Volver al Panel</a>

        <form id="solicitudForm" action="procesar_solicitud.php" method="POST">
            <div class="form-group">
                <label for="nombre-funcionario">Nombre del Funcionario</label>
                <input type="text" id="nombre-funcionario" name="nombre_funcionario" value="<?= htmlspecialchars($_SESSION['nombre_completo'] ?? '') ?>" required readonly>
            </div>

            <div class="form-group inline">
                <div>
                    <label for="unidad">Unidad</label>
                    <input type="text" id="unidad" name="unidad" value="<?= htmlspecialchars($_SESSION['unidad'] ?? '') ?>" required readonly>
                </div>
                <div>
                    <label for="puesto">Puesto</label>
                    <input type="text" id="puesto" name="puesto" value="<?= htmlspecialchars($_SESSION['puesto'] ?? '') ?>" required>
                </div>
            </div>

            <div class="form-group">
                <label for="nombre-jefe">Nombre del Jefe Inmediato</label>
                <input type="text" id="nombre-jefe" name="nombre_jefe_inmediato" value="<?= htmlspecialchars($_SESSION['nombre_jefe_inmediato'] ?? '') ?>" required readonly>
            </div>

            <div class="form-group inline">
                <div>
                    <label for="fecha-solicitud">Fecha de Solicitud</label>
                    <input type="datetime-local" id="fecha-solicitud" name="fecha_solicitud" value="<?= $fecha_solicitud ?>" required>
                </div>
                <div class="motivo">
                    <label for="tipo_permiso">Tipo de Permiso:</label>
                    <input type="radio" name="tipo_permiso" value="Personal" required> Personal
                    <input type="radio" name="tipo_permiso" value="Oficial" required> Oficial
                </div>
            </div>

            <div class="form-group">
                <label for="descripcion">Breve Descripción del Motivo del Permiso</label>
                <textarea id="descripcion" name="descripcion_motivo" rows="3"></textarea>
            </div>

            <div class="form-group inline">
                <div>
                    <label for="fecha-salida">Fecha de Salida</label>
                    <input type="date" id="fecha-salida" name="fecha_salida" required>
                </div>
                <div>
                    <label for="horario">Horario del Permiso Solicitado</label>
                    <input type="text" id="horario" name="horario_permiso" placeholder="Ej. 10:00 - 12:00">
                </div>
            </div>

            <div class="form-group observaciones">
                <h3>Observaciones:</h3>
                <ul>
                    <li>Ausentarse o abandonar su puesto en horarios laborales sin la debida autorización se considerará una falta leve.</li>
                    <li>Se podrán otorgar hasta tres autorizaciones justificadas por mes y serán válidas por un máximo de dos horas si el asunto es personal.</li>
                    <li>Para asuntos oficiales, las autorizaciones se otorgarán por el tiempo que sea necesario y se deberán presentar los respaldos correspondientes.</li>
                    <li>Independientemente el motivo del permiso deberá marcar en el reloj biométrico.</li>
                    <li>Si el permiso se encuentra dentro del horario laboral deberá marcar la salida y el regreso a su puesto de trabajo.</li>
                </ul>
            </div>

            <footer>
                <p>CENTRO CÍVICO GUBERNAMENTAL, TORRE 2, PISO 1, BOULEVARD JUAN PABLO II, TEGUCIGALPA, M.D.C., HONDURAS, C.A.</p>
                <p>(+504) 2242-7981</p>
            </footer>

            <button type="submit" class="save-button">Enviar</button>
        </form>
        <p class="approval-message">Podrá imprimir su permiso cuando RRHH lo haya aprobado</p>
    </div>

    <script>
        // Confirmación antes de enviar
        document.getElementById('solicitudForm').addEventListener('submit', function(event) {
            event.preventDefault();
            Swal.fire({
                icon: 'success',
                title: '¡Solicitud enviada!',
                text: 'La solicitud ha sido enviada correctamente.',
                confirmButtonText: 'Aceptar',
                confirmButtonColor: '#28a745'
            }).then((result) => {
                if (result.isConfirmed) {
                    this.submit();
                }
            });
        });
    </script>
</body>
</html>
