<?php
session_start();
require 'conexion.php';
require 'email_config.php'; // Debe definir la función sendEmail($to, $subject, $htmlBody) sin hacer echo/prints

// ✅ Verificar autenticación de roles permitidos (8, 9 y 12)
if (
    !isset($_SESSION['user_id']) ||
    !isset($_SESSION['role']) ||
    ($_SESSION['role'] != 8 && $_SESSION['role'] != 9 && $_SESSION['role'] != 12)
) {
    $_SESSION['error'] = 'Acceso no autorizado.';
    header("Location: login.php");
    exit;
}

// Si no viene POST válido, redirige a su panel
if ($_SERVER['REQUEST_METHOD'] !== 'POST' || !isset($_POST['accion']) || !isset($_POST['id_solicitud'])) {
    $_SESSION['error'] = 'Acción no válida.';
    if ($_SESSION['role'] == 8) {
        header("Location: panel_jefe.php");
    } elseif ($_SESSION['role'] == 9) {
        header("Location: panel_jefe_rrhh.php");
    } elseif ($_SESSION['role'] == 12) {
        header("Location: panel_directora.php");
    } else {
        header("Location: login.php");
    }
    exit;
}

$id_solicitud = (int)$_POST['id_solicitud'];
$accion = $_POST['accion'];
$comentario = isset($_POST['comentario']) ? trim($_POST['comentario']) : '';

// Determinar el nuevo estado basado en la acción
$estado = ($accion === 'Aprobar') ? 'Aprobada por Jefe Inmediato' : 'Rechazada por Jefe Inmediato';

// Obtener username y nombre completo del jefe
$username_jefe = '';
$nombre_completo_jefe = '';
$nom1 = $nom2 = $ape1 = $ape2 = '';

$sql_jefe = "SELECT username, Nom, Nom2, Ape, Ape2 FROM accounts WHERE ID = ?";
if ($stmt_jefe = $conn->prepare($sql_jefe)) {
    $stmt_jefe->bind_param('i', $_SESSION['user_id']);
    $stmt_jefe->execute();
    $stmt_jefe->bind_result($username_jefe, $nom1, $nom2, $ape1, $ape2);
    $stmt_jefe->fetch();
    $stmt_jefe->close();
    $nombre_completo_jefe = trim($nom1 . ' ' . $nom2 . ' ' . $ape1 . ' ' . $ape2);
}

$fecha_aprobacion_jefe = date('Y-m-d H:i:s');

// Actualizar solicitud: estado, comentarios, fecha, firma, nombre completo (solo si estaba Pendiente)
$sql_update = "UPDATE solicitudes 
               SET estado = ?, comentarios_finales = ?, fecha_aprobacion_jefe = ?, firma_jefe = ?, nombre_jefe_firma = ?
               WHERE id = ? AND estado = 'Pendiente'";
if ($stmt = $conn->prepare($sql_update)) {
    $stmt->bind_param('sssssi', $estado, $comentario, $fecha_aprobacion_jefe, $username_jefe, $nombre_completo_jefe, $id_solicitud);
    $stmt->execute();

    if ($stmt->affected_rows > 0) {
        // === Obtener información de la solicitud (sin get_result) ===
        $sql_solicitud = "SELECT id_usuario, unidad, puesto, tipo_permiso, descripcion_motivo, fecha_salida, horario_permiso 
                          FROM solicitudes 
                          WHERE id = ?";
        if ($stmt_solicitud = $conn->prepare($sql_solicitud)) {
            $stmt_solicitud->bind_param('i', $id_solicitud);
            $stmt_solicitud->execute();
            $stmt_solicitud->bind_result(
                $id_usuario,
                $unidad,
                $puesto,
                $tipo_permiso,
                $descripcion_motivo,
                $fecha_salida,
                $horario_permiso
            );

            $tiene_solicitud = $stmt_solicitud->fetch();
            $stmt_solicitud->close();

            if ($tiene_solicitud) {
                // === Obtener el correo y nombre del solicitante (sin get_result) ===
                $sql_usuario = "SELECT CorreoElectronico, Nom, Ape FROM accounts WHERE ID = ?";
                if ($stmt_usuario = $conn->prepare($sql_usuario)) {
                    $stmt_usuario->bind_param('i', $id_usuario);
                    $stmt_usuario->execute();
                    $stmt_usuario->bind_result($correo_solicitante, $nom_solic, $ape_solic);
                    $tiene_usuario = $stmt_usuario->fetch();
                    $stmt_usuario->close();

                    if ($tiene_usuario && !empty($correo_solicitante)) {
                        $nombre_solicitante = trim($nom_solic . ' ' . $ape_solic);

                        // Construir el cuerpo del correo
                        $subject_solicitante = "Actualización de tu Solicitud - ID: {$id_solicitud}";
                        $body_solicitante = "<h2>Hola, " . htmlspecialchars($nombre_solicitante) . "</h2>
                            <p>Tu solicitud ha sido actualizada por tu jefe inmediato.</p>
                            <p><strong>ID de Solicitud:</strong> " . (int)$id_solicitud . "</p>
                            <p><strong>Estado:</strong> " . htmlspecialchars($estado) . "</p>
                            <p><strong>Unidad:</strong> " . htmlspecialchars($unidad) . "</p>
                            <p><strong>Puesto:</strong> " . htmlspecialchars($puesto) . "</p>
                            <p><strong>Tipo de Permiso:</strong> " . htmlspecialchars($tipo_permiso) . "</p>
                            <p><strong>Motivo:</strong> " . nl2br(htmlspecialchars($descripcion_motivo)) . "</p>
                            <p><strong>Fecha de Salida:</strong> " . htmlspecialchars($fecha_salida) . "</p>";

                        // Mostrar horario solo si el permiso es "Personal"
                        if (strcasecmp($tipo_permiso, 'Personal') === 0 && !empty($horario_permiso)) {
                            $body_solicitante .= "<p><strong>Horario del Permiso:</strong> " . htmlspecialchars($horario_permiso) . "</p>";
                        }

                        if (!empty($comentario)) {
                            $body_solicitante .= "<p><strong>Comentarios del Jefe:</strong> " . nl2br(htmlspecialchars($comentario)) . "</p>";
                        }

                        $body_solicitante .= "<p>Saludos,<br>Mensaje automático - Sistema PROASOL</p>";

                        // Enviar correo
                        if (sendEmail($correo_solicitante, $subject_solicitante, $body_solicitante)) {
                            $_SESSION['success'] = "Estado actualizado y notificación enviada al solicitante.";
                        } else {
                            $_SESSION['error'] = "Estado actualizado, pero falló el envío del correo.";
                        }
                    } else {
                        $_SESSION['error'] = "Estado actualizado, pero no se encontró el correo del solicitante.";
                    }
                } else {
                    $_SESSION['error'] = "Estado actualizado, pero ocurrió un error obteniendo el solicitante: " . $conn->error;
                }
            } else {
                $_SESSION['error'] = "Estado actualizado, pero no se encontró la solicitud para notificar.";
            }
        } else {
            $_SESSION['error'] = "Estado actualizado, pero ocurrió un error obteniendo la solicitud: " . $conn->error;
        }
    } else {
        // Si no afectó filas, puede que ya no esté 'Pendiente' o no exista
        $_SESSION['error'] = "No se pudo actualizar el estado. Puede que la solicitud ya no esté pendiente o no exista.";
    }

    $stmt->close();
} else {
    $_SESSION['error'] = "Error al preparar la actualización: " . $conn->error;
}

// 🔁 Redirección final según el rol (manteniendo tu estilo de ejemplo)
if ($_SESSION['role'] == 8) {
    header("Location: panel_jefe.php");
    exit;
} elseif ($_SESSION['role'] == 9) {
    header("Location: panel_jefe_rrhh.php");
    exit;
} elseif ($_SESSION['role'] == 12) {
    header("Location: panel_directora.php");
    exit;
} else {
    $_SESSION['error'] = 'Acción no válida.';
    header("Location: panel_jefe.php");
    exit;
}

$conn->close();
