<?php
session_start();

require 'conexion.php';
require 'email_config.php'; // Configuración de PHPMailer

// ✅ Verificar autenticación de roles permitidos (8, 9 y 12)
if (
    !isset($_SESSION['user_id']) ||
    !isset($_SESSION['role']) ||
    ($_SESSION['role'] != 8 && $_SESSION['role'] != 9 && $_SESSION['role'] != 12)
) {
    $_SESSION['error'] = 'Acceso no autorizado.';
    header("Location: login.php");
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['accion']) && isset($_POST['id_solicitud'])) {
    $id_solicitud = (int)$_POST['id_solicitud'];
    $accion = $_POST['accion'];
    $comentario = isset($_POST['comentario']) ? trim($_POST['comentario']) : '';

    $estado = ($accion === 'Aprobar') ? 'Aprobada por Jefe Inmediato' : 'Rechazada por Jefe Inmediato';

    // Obtener datos del jefe
    $sql_jefe = "SELECT username, Nom, Nom2, Ape, Ape2 FROM accounts WHERE ID = ?";
    if ($stmt_jefe = $conn->prepare($sql_jefe)) {
        $stmt_jefe->bind_param('i', $_SESSION['user_id']);
        $stmt_jefe->execute();
        $stmt_jefe->bind_result($username_jefe, $nom1, $nom2, $ape1, $ape2);
        $stmt_jefe->fetch();
        $nombre_completo_jefe = trim("$nom1 $nom2 $ape1 $ape2");
        $stmt_jefe->close();
    } else {
        // En caso de error, redirigir al panel con error
        header("Location: panel_jefe_vacaciones.php?error=1");
        exit;
    }

    $fecha_revision = date('Y-m-d H:i:s');

    $sql_update = "UPDATE solicitudes 
                   SET estado = ?, comentarios_finales = ?, fecha_aprobacion_jefe = ?, firma_jefe = ?, nombre_jefe_firma = ?
                   WHERE id = ? AND estado = 'Pendiente'";
    if ($stmt_update = $conn->prepare($sql_update)) {
        $stmt_update->bind_param('sssssi', $estado, $comentario, $fecha_revision, $username_jefe, $nombre_completo_jefe, $id_solicitud);
        $stmt_update->execute();

        if ($stmt_update->affected_rows > 0) {
            // Obtener datos del solicitante
            $sql_vac = "SELECT v.fecha_inicio, v.fecha_fin, v.dias,
                               a.Nom, a.Nom2, a.Ape, a.Ape2, a.CorreoElectronico,
                               s.fecha_solicitud
                        FROM vacaciones v
                        JOIN solicitudes s ON v.id_solicitud = s.id
                        JOIN accounts a ON s.id_usuario = a.ID
                        WHERE v.id_solicitud = ?";

            if ($stmt_vac = $conn->prepare($sql_vac)) {
                $stmt_vac->bind_param('i', $id_solicitud);
                $stmt_vac->execute();
                $result_vac = $stmt_vac->get_result();
                $data = $result_vac->fetch_assoc();
                $stmt_vac->close();

                if ($data) {
                    $nombre_solicitante = trim("{$data['Nom']} {$data['Nom2']} {$data['Ape']} {$data['Ape2']}");
                    $to_email = $data['CorreoElectronico'];

                    // Correo al solicitante
                    $subject = "Actualización de solicitud de vacaciones - ID: {$id_solicitud}";
                    $body = "<h2>Hola, {$nombre_solicitante}</h2>
                            <p>Tu solicitud de vacaciones ha sido <strong>{$estado}</strong> </p>
                            <p><strong>Fecha de Inicio:</strong> {$data['fecha_inicio']}</p>
                            <p><strong>Fecha de Fin:</strong> {$data['fecha_fin']}</p>
                            <p><strong>Días Solicitados:</strong> {$data['dias']}</p>";

                    if (!empty($comentario)) {
                        $body .= "<p><strong>Comentario del Jefe:</strong> {$comentario}</p>";
                    }

                    $body .= "<p>Saludos,<br>El equipo de RRHH - PROASOL</p>";

                    sendEmail($to_email, $subject, $body);

                    // Correo a RRHH si fue aprobado
                    if ($accion === 'Aprobar') {
                        $subject_rrhh = "Solicitud de vacaciones aprobada por jefe - ID: {$id_solicitud}";
                        $body_rrhh = "<h2>Notificación a RRHH</h2>
                            <p>Una solicitud de vacaciones ha sido <strong>aprobada por el jefe inmediato</strong> y está lista para revisión de RRHH.</p>
                            <p><strong>Funcionario:</strong> {$nombre_solicitante}</p>
                            <p><strong>Fecha de Inicio:</strong> {$data['fecha_inicio']}</p>
                            <p><strong>Fecha de Fin:</strong> {$data['fecha_fin']}</p>
                            <p><strong>Días Solicitados:</strong> {$data['dias']}</p>
                            <p><strong>Jefe Revisor:</strong> {$nombre_completo_jefe}</p>";

                        if (!empty($comentario)) {
                            $body_rrhh .= "<p><strong>Comentario del Jefe:</strong> {$comentario}</p>";
                        }

                        $body_rrhh .= "<p>Por favor, ingresa al sistema para revisar y aprobar esta solicitud.<br>Saludos,<br>Notificación Automática - PROASOL</p>";

                        // Cambia el correo si necesitas múltiples destinatarios o un alias
                        sendEmail("gina.alvarado@proasol.gob.hn", $subject_rrhh, $body_rrhh);
                    }
                }
            }
        }

        $stmt_update->close();
    }

    // 🔒 Cerrar conexión antes de redirigir
    $conn->close();

    // 🔁 Redirección final según el rol (manteniendo tu estilo de ejemplo)
    if ($_SESSION['role'] == 8) {
        header("Location: panel_jefe.php");
        exit;
    } elseif ($_SESSION['role'] == 9) {
        header("Location: panel_jefe_rrhh.php");
        exit;
    } elseif ($_SESSION['role'] == 12) {
        header("Location: panel_directora.php");
        exit;
    } else {
        $_SESSION['error'] = 'Acción no válida.';
        header("Location: panel_jefe.php");
        exit;
    }

} else {
    // Si no es POST o faltan datos, cerrar y redirigir por rol
    if (isset($conn) && $conn instanceof mysqli) {
        $conn->close();
    }

    // 🔁 Redirección final según el rol también en este camino
    if ($_SESSION['role'] == 8) {
        header("Location: panel_jefe.php");
        exit;
    } elseif ($_SESSION['role'] == 9) {
        header("Location: panel_jefe_rrhh.php");
        exit;
    } elseif ($_SESSION['role'] == 12) {
        header("Location: panel_directora.php");
        exit;
    } else {
        $_SESSION['error'] = 'Acción no válida.';
        header("Location: panel_jefe.php");
        exit;
    }
}
?>
