<?php
session_start();
require 'conexion.php'; // Conexión a la base de datos
require 'email_config.php'; // Configuración PHPMailer

// Verificar que el usuario esté autenticado
if (!isset($_SESSION['loggedin'])) {
    die("Acceso denegado");
}

// Recibir datos del formulario
$id_usuario = $_SESSION['id'];
$unidad = $_POST['unidad'];
$puesto = $_POST['puesto'];
$nombre_jefe_inmediato = $_POST['nombre_jefe_inmediato'];
$fecha_solicitud = $_POST['fecha_solicitud'];
$tipo_permiso = $_POST['tipo_permiso'];
$descripcion_motivo = $_POST['descripcion_motivo'];
$fecha_salida = $_POST['fecha_salida'];
$horario_permiso = $_POST['horario_permiso'];
$estado = 'Pendiente';

// Fechas de aprobación iniciales NULL
$fecha_aprobacion_jefe = NULL;
$fecha_aprobacion_rrhh = NULL;

// Obtener username (firma del funcionario)
$sql_username = "SELECT username FROM accounts WHERE ID = ?";
$stmt_username = $conn->prepare($sql_username);
$stmt_username->bind_param('i', $id_usuario);
$stmt_username->execute();
$result_username = $stmt_username->get_result();
$row_username = $result_username->fetch_assoc();
$stmt_username->close();

$firma_funcionario = $row_username ? $row_username['username'] : '---';

// Obtener nombre completo del funcionario para almacenarlo como quien firma
$sql_nombre = "SELECT Nom, Nom2, Ape, Ape2 FROM accounts WHERE ID = ?";
$stmt_nombre = $conn->prepare($sql_nombre);
$stmt_nombre->bind_param('i', $id_usuario);
$stmt_nombre->execute();
$stmt_nombre->bind_result($nom, $nom2, $ape, $ape2);
$stmt_nombre->fetch();
$nombre_funcionario_firma = trim(implode(' ', array_filter([$nom, $nom2, $ape, $ape2])));
$stmt_nombre->close();

// Insertar la solicitud en la base de datos
$sql = "INSERT INTO solicitudes (
    id_usuario, unidad, puesto, nombre_jefe_inmediato,
    fecha_solicitud, tipo_permiso, descripcion_motivo,
    fecha_salida, horario_permiso, firma_funcionario, estado,
    fecha_aprobacion_jefe, fecha_aprobacion_rrhh, nombre_funcionario_firma
) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

$stmt = $conn->prepare($sql);
$stmt->bind_param(
    "isssssssssssss",
    $id_usuario,
    $unidad,
    $puesto,
    $nombre_jefe_inmediato,
    $fecha_solicitud,
    $tipo_permiso,
    $descripcion_motivo,
    $fecha_salida,
    $horario_permiso,
    $firma_funcionario,
    $estado,
    $fecha_aprobacion_jefe,
    $fecha_aprobacion_rrhh,
    $nombre_funcionario_firma
);

if ($stmt->execute()) {
    $solicitud_id = $conn->insert_id;

    // Obtener correo y nombre del solicitante
    $sql_usuario = "SELECT CorreoElectronico, Nom, Ape, cod_jefe FROM accounts WHERE ID = ?";
    $stmt_usuario = $conn->prepare($sql_usuario);
    $stmt_usuario->bind_param('i', $id_usuario);
    $stmt_usuario->execute();
    $result_usuario = $stmt_usuario->get_result();
    $solicitante = $result_usuario->fetch_assoc();
    $stmt_usuario->close();

    if ($solicitante) {
        $to_solicitante = $solicitante['CorreoElectronico'];
        $nombre_solicitante = $solicitante['Nom'] . ' ' . $solicitante['Ape'];
        $cod_jefe = $solicitante['cod_jefe'];

        $subject_solicitante = "Nueva Solicitud Registrada - Estado Pendiente";
        $body_solicitante = "<h2>Hola, {$nombre_solicitante}</h2>
            <p>Hemos recibido tu nueva solicitud en el sistema.</p>
            <p><strong>ID de Solicitud:</strong> {$solicitud_id}</p>
            <p><strong>Estado:</strong> {$estado}</p>
            <p><strong>Unidad:</strong> {$unidad}</p>
            <p><strong>Puesto:</strong> {$puesto}</p>
            <p><strong>Tipo de Permiso:</strong> {$tipo_permiso}</p>
            <p><strong>Motivo:</strong> {$descripcion_motivo}</p>
            <p><strong>Fecha de Salida:</strong> {$fecha_salida}</p>
            <p><strong>Horario del Permiso:</strong> {$horario_permiso}</p>
            <p>Te notificaremos cuando haya actualizaciones en tu solicitud.</p>
            <p>Saludos,<br>Mensaje automático - Sistema PROASOL</p>";

        if (sendEmail($to_solicitante, $subject_solicitante, $body_solicitante)) {
            $mensaje_solicitante = "Se ha enviado una notificación a tu correo.";
        } else {
            $mensaje_solicitante = "Falló el envío del correo al solicitante.";
        }
    } else {
        $mensaje_solicitante = "No se encontró el correo del solicitante.";
        $cod_jefe = null;
    }

    // Notificar al jefe
    if ($cod_jefe) {
        $sql_jefe = "SELECT correo, nombre_jefe FROM jefes WHERE cod_jefe = ?";
        $stmt_jefe = $conn->prepare($sql_jefe);
        $stmt_jefe->bind_param('i', $cod_jefe);
        $stmt_jefe->execute();
        $result_jefe = $stmt_jefe->get_result();
        $jefe = $result_jefe->fetch_assoc();
        $stmt_jefe->close();

        if ($jefe) {
            $to_jefe = $jefe['correo'];
            $nombre_jefe = $jefe['nombre_jefe'];

            $subject_jefe = "Nueva Solicitud Pendiente - Acción Requerida";
            $body_jefe = "<h2>Hola, {$nombre_jefe}</h2>
                <p>Se ha creado una nueva solicitud que requiere tu aprobación.</p>
                <p><strong>ID de Solicitud:</strong> {$solicitud_id}</p>
                <p><strong>Solicitante:</strong> {$nombre_solicitante}</p>
                <p><strong>Unidad:</strong> {$unidad}</p>
                <p><strong>Puesto:</strong> {$puesto}</p>
                <p><strong>Tipo de Permiso:</strong> {$tipo_permiso}</p>
                <p><strong>Motivo:</strong> {$descripcion_motivo}</p>
                <p><strong>Fecha de Salida:</strong> {$fecha_salida}</p>
                <p><strong>Horario del Permiso:</strong> {$horario_permiso}</p>
                <p>Por favor, revisa y aprueba o rechaza la solicitud en el sistema.</p>
                <p>Saludos,<br>Mensaje automático - Sistema PROASOL</p>";

            if (sendEmail($to_jefe, $subject_jefe, $body_jefe)) {
                $mensaje_jefe = "Se ha notificado al jefe.";
            } else {
                $mensaje_jefe = "Falló el envío del correo al jefe.";
            }
        } else {
            $mensaje_jefe = "No se encontró el correo del jefe.";
        }
    } else {
        $mensaje_jefe = "No se pudo determinar el jefe del solicitante.";
    }

    $_SESSION['success_message'] = "✅ Solicitud enviada correctamente. {$mensaje_solicitante} {$mensaje_jefe}";
    header("Location: pase_salida.php");
    exit;
} else {
    $_SESSION['error_message'] = "❌ Error al guardar la solicitud: " . $stmt->error;
    header("Location: pase_salida.php");
    exit;
}

$stmt->close();
$conn->close();
?>
