<?php
session_start();
require 'conexion.php';
require 'email_config.php'; // Asegúrate que contiene la función sendEmail()

// Verificar si el usuario está autenticado
if (!isset($_SESSION['user_id'])) {
    $_SESSION['error'] = 'Debes iniciar sesión para enviar una solicitud.';
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id'];

// Obtener datos del formulario
$tipo_solicitud = $_POST['tipo_solicitud'] ?? '';
$comentarios = $_POST['comentarios'] ?? '';

// Validar datos
if (empty($tipo_solicitud)) {
    $_SESSION['error'] = 'El tipo de solicitud es obligatorio.';
    header("Location: dashboard_usuario.php");
    exit;
}

// Obtener datos del solicitante
$sql_user = "SELECT Nom, Nom2, Ape, Ape2, CorreoElectronico FROM accounts WHERE ID = ?";
$stmt_user = $conn->prepare($sql_user);
$stmt_user->bind_param('i', $user_id);
$stmt_user->execute();
$stmt_user->bind_result($nom, $nom2, $ape, $ape2, $correo_solicitante);
$stmt_user->fetch();
$nombre_solicitante = trim("$nom $nom2 $ape $ape2");
$stmt_user->close();

// Insertar la solicitud
$sql = "INSERT INTO solicitudes (id_usuario, tipo_solicitud, descripcion_motivo, fecha_solicitud, estado) 
        VALUES (?, ?, ?, NOW(), 'Pendiente')";
if ($stmt = $conn->prepare($sql)) {
    $stmt->bind_param('iss', $user_id, $tipo_solicitud, $comentarios);
    $stmt->execute();
    $stmt->close();

    $_SESSION['success'] = 'Solicitud enviada correctamente.';

    // Enviar correo a RRHH
    $correo_rrhh = "solicitudrrhh@proasol.gob.hn";
    $subject = "Nueva solicitud enviada - $tipo_solicitud";
    $body = "<h3>Se ha recibido una nueva solicitud</h3>
            <p><strong>Funcionario:</strong> $nombre_solicitante</p>
            <p><strong>Tipo de solicitud:</strong> $tipo_solicitud</p>
            <p><strong>Comentarios:</strong> $comentarios</p>
            <br><p>Por favor, ingrese al sistema para revisarla.</p>
            <p>-- Notificación automática PROASOL --</p>";

    sendEmail($correo_rrhh, $subject, $body);

} else {
    $_SESSION['error'] = 'Error al procesar la solicitud. Inténtalo de nuevo.';
}

$conn->close();
header("Location: dashboard_usuario.php");
exit;
?>
