<?php
session_start();
require 'conexion.php';

// Asegurarse de que el usuario esté autenticado y tenga el rol correcto (cod_rol = 8)
if (!isset($_SESSION['user_id']) || !isset($_SESSION['role']) || $_SESSION['role'] != 12) {
    $_SESSION['error'] = 'Acceso no autorizado. Por favor, inicia sesión con una cuenta de Jefe de Departamento válida.';
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id'];
$nombre_usuario = $_SESSION['Nom'];

// Obtener el cod_unidad y el nombre_unidad del jefe
$sql_jefe_unidad = "SELECT a.cod_unidad, u.nombre_unidad 
                    FROM accounts a 
                    INNER JOIN unidad u ON a.cod_unidad = u.cod_unidad 
                    WHERE a.ID = ?";
$cod_unidad_jefe = null;
$nombre_unidad_jefe = null;
if ($stmt = $conn->prepare($sql_jefe_unidad)) {
    $stmt->bind_param('i', $user_id);
    $stmt->execute();
    $stmt->bind_result($cod_unidad_jefe, $nombre_unidad_jefe);
    $stmt->fetch();
    $stmt->close();
}

// Si el jefe no tiene un cod_unidad asignado o no se encuentra la unidad, mostrar error
if (is_null($cod_unidad_jefe) || is_null($nombre_unidad_jefe)) {
    $_SESSION['error'] = 'No tienes una unidad asignada o la unidad no está registrada. Contacta al administrador.';
    header("Location: login.php");
    exit;
}

// Obtener solicitudes aprobadas (empleados con el mismo cod_unidad que el jefe)
$sql_solicitudes_aprobadas = "SELECT s.id, s.tipo_permiso, s.fecha_solicitud, s.fecha_salida, s.descripcion_motivo, s.estado, a.Nom, a.Ape 
                              FROM solicitudes s 
                              JOIN accounts a ON s.id_usuario = a.ID 
                              WHERE s.estado IN ('Aprobada por Jefe Inmediato', 'Aprobada por Recursos Humanos') 
                              AND a.cod_unidad = ? 
                              ORDER BY s.fecha_solicitud DESC";

if ($stmt = $conn->prepare($sql_solicitudes_aprobadas)) {
    $stmt->bind_param('s', $cod_unidad_jefe);
    $stmt->execute();
    $result_solicitudes_aprobadas = $stmt->get_result();
    $stmt->close();
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Solicitudes Aprobadas - Jefe de Departamento</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Roboto', sans-serif;
        }

        body {
            background-color: #f0f4f8;
            color: #2c3e50;
            line-height: 1.6;
        }

        .container {
            display: flex;
            min-height: 100vh;
        }

        /* Sidebar */
        .sidebar {
            width: 260px;
            background: linear-gradient(135deg, #2c3e50, #34495e);
            color: white;
            padding: 20px 15px;
            position: fixed;
            height: 100%;
            transition: transform 0.3s ease;
            z-index: 1000;
        }

        .sidebar.collapsed {
            transform: translateX(-260px);
            width: 0;
        }

        .sidebar h2 {
            font-size: 24px;
            margin-bottom: 30px;
            text-align: center;
            color: #68c8d8;
        }

        .sidebar ul {
            list-style: none;
        }

        .sidebar ul li {
            margin-bottom: 15px;
        }

        .sidebar ul li a {
            color: #ecf0f1;
            text-decoration: none;
            font-size: 16px;
            display: flex;
            align-items: center;
            padding: 10px 15px;
            border-radius: 5px;
            transition: background 0.3s, color 0.3s;
        }

        .sidebar ul li a:hover {
            background: #465c71;
            color: #68c8d8;
        }

        .sidebar ul li a i {
            margin-right: 10px;
        }

        .toggle-btn {
            display: none;
            position: fixed;
            left: 10px;
            top: 10px;
            background: #68c8d8;
            color: white;
            border: none;
            padding: 10px;
            border-radius: 5px;
            cursor: pointer;
            z-index: 1001;
            transition: background 0.3s;
        }

        .toggle-btn:hover {
            background: #5dade2;
        }

        /* Main Content */
        .main-content {
            flex-grow: 1;
            padding: 30px;
            margin-left: 260px;
            transition: margin-left 0.3s ease;
            width: calc(100% - 260px);
        }

        .welcome-message {
            font-size: 28px;
            color: #2c3e50;
            margin-bottom: 25px;
            text-align: center;
            font-weight: 500;
        }

        .main-content h1 {
            font-size: 32px;
            color: #2c3e50;
            margin-bottom: 30px;
            text-align: center;
            border-bottom: 3px solid #68c8d8;
            padding-bottom: 10px;
            font-weight: 700;
        }

        /* Sections Grid */
        .dashboard-grid {
            display: grid;
            grid-template-columns: 1fr;
            gap: 30px;
        }

        /* Approved Requests */
        .approved-requests {
            background: white;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            overflow-x: auto; /* Permite desplazamiento horizontal en pantallas pequeñas */
        }

        .approved-requests h2 {
            font-size: 22px;
            color: #2c3e50;
            margin-bottom: 20px;
        }

        .approved-requests table {
            width: 100%;
            min-width: 600px; /* Mínimo ancho para evitar colapso */
            border-collapse: collapse;
            table-layout: fixed;
        }

        .approved-requests th, .approved-requests td {
            padding: 12px;
            text-align: left;
            border-bottom: 1px solid #ecf0f1;
            font-size: 15px;
            word-wrap: break-word; /* Permite que el texto se divida */
        }

        .approved-requests th {
            background: linear-gradient(135deg, #2c3e50, #34495e);
            color: white;
            font-weight: 500;
            position: sticky;
            top: 0;
            z-index: 1;
        }

        .approved-requests td {
            color: #555;
            transition: background 0.3s;
        }

        .approved-requests tr:hover {
            background: #f9fbfd;
        }

        .approved-requests .action-buttons a {
            color: #68c8d8;
            text-decoration: none;
            font-weight: 500;
            transition: color 0.3s;
        }

        .approved-requests .action-buttons a:hover {
            color: #5dade2;
            text-decoration: underline;
        }

        /* Estilo para la columna de estado */
        .approved-requests .estado-aprobada-jefe {
            color: #3498db;
            font-weight: 500;
        }

        .approved-requests .estado-aprobada-rrhh {
            color: #27ae60;
            font-weight: 500;
        }

        /* Responsive Design */
        @media (max-width: 1024px) {
            .sidebar {
                width: 220px;
            }
            .main-content {
                margin-left: 220px;
                width: calc(100% - 220px);
                padding: 25px;
            }
        }

        @media (max-width: 768px) {
            .toggle-btn {
                display: block;
            }
            .sidebar {
                transform: translateX(-260px);
                width: 260px;
            }
            .sidebar.open {
                transform: translateX(0);
            }
            .main-content {
                margin-left: 0;
                width: 100%;
                padding: 20px;
            }
            .approved-requests th, .approved-requests td {
                padding: 10px;
                font-size: 13px;
            }
        }

        @media (max-width: 480px) {
            .sidebar {
                padding: 10px;
            }
            .sidebar h2 {
                font-size: 18px;
                margin-bottom: 20px;
            }
            .sidebar ul li a {
                font-size: 14px;
                padding: 8px;
            }
            .main-content {
                padding: 15px;
            }
            .welcome-message {
                font-size: 20px;
            }
            .main-content h1 {
                font-size: 24px;
            }
            .approved-requests {
                padding: 15px;
            }
            .approved-requests th, .approved-requests td {
                padding: 8px;
                font-size: 12px;
            }
            .approved-requests .action-buttons a {
                font-size: 12px;
            }
        }
    </style>
</head>
<body>
    <button class="toggle-btn" onclick="toggleSidebar()"><i class="fas fa-bars"></i></button>
    <div class="container">
        <!-- Menú lateral -->
        <div class="sidebar" id="sidebar">
            <h2>Panel Jefe</h2>
          <ul>
                <li><a href="dashboard_directora.php"><i class="fas fa-tachometer-alt"></i> Panel Principal</a></li>
                <li><a href="panel_directora.php"><i class="fas fa-clipboard-list"></i> Solicitudes Pendientes-Permiso</a></li>
                <li><a href="panel_directora_vacaciones.php"><i class="fas fa-umbrella-beach"></i> Solicitudes Pendientes-Vacaciones</a></li>
                <li><a href="solicitudes_aprobadas_directora.php"><i class="fas fa-check"></i> Solicitudes Aprobadas</a></li>
                <li><a href="solicitudes_rechazadas_directora.php"><i class="fas fa-times"></i> Solicitudes Rechazadas</a></li>
                <li><a href="vacaciones_jefe.php"><i class="fas fa-users"></i> Vacaciones</a></li>
                <li><a href="panel_user_directora.php"><i class="fas fa-eye"></i> Perfil</a></li>
                <li>
                    <a href="https://sistemas.proasol.gob.hn/denuncias_proasol/index.html?src=jefe_sidebar"
                       target="_blank" rel="noopener">
                       <i class="fas fa-shield-alt"></i> Denuncia-CPEP
                    </a>
                </li>
                <li><a href="logout.php"><i class="fas fa-sign-out-alt"></i> Cerrar Sesión</a></li>
            </ul>
        </div>

        <!-- Contenido principal -->
        <div class="main-content">
            <div class="welcome-message">Bienvenido, <?= htmlspecialchars($nombre_usuario) ?> <span style="font-size: 14px; color: #7f8c8d;">(<?= date('h:i A T') ?>)</span></div>
            <h1>Solicitudes Aprobadas - Jefe de Departamento</h1>

            <!-- Dashboard Grid -->
            <div class="dashboard-grid">
                <!-- Approved Requests -->
                <div class="approved-requests">
                    <h2>Solicitudes Aprobadas (<?= htmlspecialchars($nombre_unidad_jefe) ?>)</h2>
                    <?php if ($result_solicitudes_aprobadas->num_rows > 0): ?>
                        <table>
                            <thead>
                                <tr>
                                    <th>Empleado</th>
                                    <th>Tipo de Solicitud</th>
                                    <th>Fecha de Solicitud</th>
                                    <th>Fecha de Salida</th>
                                    <th>Motivo</th>
                                    <th>Estado</th>
                                    <th>Acciones</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php while ($row = $result_solicitudes_aprobadas->fetch_assoc()): ?>
                                    <tr>
                                        <td><?= htmlspecialchars($row['Nom'] . ' ' . $row['Ape']) ?></td>
                                        <td><?= htmlspecialchars($row['tipo_permiso']) ?></td>
                                        <td><?= htmlspecialchars($row['fecha_solicitud']) ?></td>
                                        <td><?= htmlspecialchars($row['fecha_salida']) ?></td>
                                        <td><?= htmlspecialchars($row['descripcion_motivo']) ?></td>
                                        <td class="estado-<?= $row['estado'] === 'Aprobada por Jefe Inmediato' ? 'aprobada-jefe' : 'aprobada-rrhh' ?>">
                                            <?= htmlspecialchars($row['estado']) ?>
                                        </td>
                                        <td class="action-buttons">
                                            <a href="detalle_solicitud_jefe.php?id=<?= $row['id'] ?>">Ver Detalles</a>
                                        </td>
                                    </tr>
                                <?php endwhile; ?>
                            </tbody>
                        </table>
                    <?php else: ?>
                        <p style="text-align: center; color: #777;">No hay solicitudes aprobadas en tu unidad (<?= htmlspecialchars($nombre_unidad_jefe) ?>).</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <script>
        function toggleSidebar() {
            const sidebar = document.getElementById('sidebar');
            sidebar.classList.toggle('open');
            const mainContent = document.querySelector('.main-content');
            if (sidebar.classList.contains('open')) {
                mainContent.style.marginLeft = '260px';
                mainContent.style.width = 'calc(100% - 260px)';
            } else {
                mainContent.style.marginLeft = '0';
                mainContent.style.width = '100%';
            }
        }
    </script>

    <?php $conn->close(); ?>
</body>
</html>