<?php
session_start();
require 'conexion.php';

// Verificar autenticación y rol
if (!isset($_SESSION['user_id']) || $_SESSION['role'] != 9) {
    header("Location: login.php");
    exit;
}

$nombre_usuario = $_SESSION['Nom'];

// ====== Filtro por empleado (por ID de accounts) ======
$empleado_id = isset($_GET['empleado']) ? (int)$_GET['empleado'] : 0;

// ====== Listado de empleados con solicitudes aprobadas para el combo ======
$sql_empleados = "
    SELECT DISTINCT a.ID, CONCAT(a.Nom, ' ', a.Ape) AS nombre
    FROM solicitudes s
    JOIN accounts a ON s.id_usuario = a.ID
    WHERE s.estado = 'Aprobada por Recursos Humanos'
    ORDER BY nombre ASC
";
$result_empleados = $conn->query($sql_empleados);

// ====== Consulta para obtener solicitudes aprobadas por RRHH (con filtro opcional) ======
$base_sql = "SELECT s.id, s.tipo_permiso, s.fecha_solicitud, s.fecha_salida, s.descripcion_motivo, 
                    a.Nom, a.Ape, u.nombre_unidad 
             FROM solicitudes s 
             JOIN accounts a ON s.id_usuario = a.ID 
             INNER JOIN unidad u ON a.cod_unidad = u.cod_unidad 
             WHERE s.estado = 'Aprobada por Recursos Humanos'";

$params = [];
$types  = '';

if ($empleado_id > 0) {
    $base_sql .= " AND s.id_usuario = ?";
    $params[] = $empleado_id;
    $types   .= 'i';
}

$base_sql .= " ORDER BY s.fecha_solicitud DESC";

$stmt = $conn->prepare($base_sql);
if ($empleado_id > 0) {
    $stmt->bind_param($types, ...$params);
}
$stmt->execute();
$result_solicitudes = $stmt->get_result();

// Nota: cerramos conexión al final por orden
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Historial de Solicitudes Aprobadas - RRHH</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; font-family: 'Roboto', sans-serif; }
        body { background-color: #f4f7fa; color: #333; }
        .container { display: flex; min-height: 100vh; }

        /* Menú lateral */
        .sidebar { width: 250px; background: linear-gradient(135deg, #2c3e50, #34495e); color: white; padding: 20px 15px; position: fixed; height: 100%; box-shadow: 2px 0 5px rgba(0,0,0,0.1); transition: transform 0.3s ease; z-index: 1000; }
        .sidebar.collapsed { transform: translateX(-250px); width: 0; }
        .sidebar h2 { font-size: 24px; margin-bottom: 30px; text-align: center; color: #68c8d8; font-weight: 700; }
        .sidebar ul { list-style: none; padding: 0; }
        .sidebar ul li { margin-bottom: 15px; }
        .sidebar ul li a { color: #ecf0f1; text-decoration: none; font-size: 16px; display: flex; align-items: center; padding: 10px 15px; border-radius: 5px; transition: background 0.3s, color 0.3s; }
        .sidebar ul li a:hover { background: #465c71; color: #68c8d8; }
        .sidebar ul li a i { margin-right: 10px; font-size: 16px; }
        .toggle-btn { display: none; position: fixed; left: 10px; top: 10px; background: #68c8d8; color: white; border: none; padding: 10px; border-radius: 5px; cursor: pointer; z-index: 1001; transition: background 0.3s; }
        .toggle-btn:hover { background: #5dade2; }
        .main-content { flex-grow: 1; padding: 40px; margin-left: 250px; transition: margin-left 0.3s ease; width: calc(100% - 250px); }
        .welcome-message { font-size: 20px; color: #2c3e50; margin-bottom: 20px; text-align: center; }
        h1 { color: #2c3e50; text-align: center; margin-bottom: 20px; border-bottom: 2px solid #68c8d8; padding-bottom: 10px; }

        /* Filtro */
        .filters-bar { display: flex; gap: 12px; align-items: center; justify-content: center; margin: 15px auto 25px; flex-wrap: wrap; }
        .filters-bar label { font-weight: 700; color: #2c3e50; }
        .filters-bar select { padding: 8px 10px; border: 1px solid #ccc; border-radius: 6px; background: #fff; min-width: 260px; }
        .filters-bar .btn-clear { border: none; padding: 8px 12px; border-radius: 6px; background: #bdc3c7; color: #2c3e50; cursor: pointer; }
        .filters-bar .btn-clear:hover { background: #95a5a6; }

        table { width: 100%; border-collapse: collapse; background-color: white; box-shadow: 0 4px 8px rgba(0,0,0,0.1); overflow-x: auto; }
        th, td { padding: 12px; text-align: left; border-bottom: 1px solid #ddd; white-space: nowrap; }
        th { background-color: #2c3e50; color: white; position: sticky; top: 0; z-index: 1; }
        tr:nth-child(even) { background-color: #f9f9f9; }
        tr:hover { background-color: #f1f1f1; }
        .action-btn { padding: 6px 12px; background-color: #3498db; color: white; border: none; border-radius: 4px; cursor: pointer; text-decoration: none; font-size: 14px; transition: background-color 0.3s; }
        .action-btn:hover { background-color: #2980b9; }

        /* Responsive */
        @media (max-width: 1024px) {
            .sidebar { width: 220px; }
            .main-content { margin-left: 220px; width: calc(100% - 220px); padding: 25px; }
        }
        @media (max-width: 768px) {
            .toggle-btn { display: block; }
            .sidebar { transform: translateX(-250px); width: 250px; }
            .sidebar.open { transform: translateX(0); }
            .main-content { margin-left: 0; width: 100%; padding: 20px; }
            th, td { padding: 8px; font-size: 14px; }
            .welcome-message { font-size: 18px; }
            h1 { font-size: 24px; }
            .action-btn { padding: 4px 8px; font-size: 12px; }
        }
        @media (max-width: 480px) {
            .main-content { padding: 15px; }
            .welcome-message { font-size: 16px; }
            h1 { font-size: 20px; }
            th, td { padding: 6px; font-size: 12px; }
            .action-btn { padding: 3px 6px; font-size: 10px; }
            .filters-bar select { min-width: 200px; }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="sidebar" id="sidebar">
            <h2>Panel RRHH</h2>
            <ul>
                <li><a href="dashboard_rrhh.php"><i class="fas fa-home"></i> Inicio</a></li>
                <?php if ($_SESSION['role'] != 11): ?>
                    <li><a href="gestionar_solicitudes_rrhh.php"><i class="fas fa-tasks"></i> Gestionar Solicitudes</a></li>
                <?php endif; ?>
                <li><a href="panel_jefe_rrhh.php"><i class="fas fa-chart-bar"></i>Solicitudes Unidad RRHH</a></li>
                <li><a href="panel_rrhh_vacaciones.php"><i class="fas fa-chart-bar"></i>Solicitudes Vacaciones RRHH</a></li>
                <li><a href="estadisticas_rrhh.php"><i class="fas fa-chart-bar"></i> Estadísticas</a></li>
                <li><a href="solicitudes_aprobadas_rrhh.php"><i class="fas fa-check"></i> Historial de Solicitudes Aprobadas</a></li>
                <li><a href="ver_solicitudes.php"><i class="fas fa-eye"></i> Más Solicitudes</a></li>
                <?php if ($_SESSION['role'] != 11): ?>
                    <li><a href="gestionar_empleados.php"><i class="fas fa-users"></i> Gestión de Empleados</a></li>
                <?php endif; ?>
                <li><a href="panel_vacaciones_rrhh.php"><i class="fas fa-umbrella-beach"></i> Gestión de Vacaciones</a></li>
                <?php if ($_SESSION['role'] != 11): ?>
                    <li><a href="gestionar_unidades_puestos.php"><i class="fas fa-building"></i> Unidades y Puestos</a></li>
                    <li><a href="asignar_privilegios_rrhh.php"><i class="fas fa-user-shield"></i> Asignar Rol</a></li>
                <?php endif; ?>

                <!-- ✅ Acceso directo al Portal de Denuncias -->
                <li>
                    <a href="https://sistemas.proasol.gob.hn/denuncias_proasol/index.html?src=rrhh_sidebar" target="_blank" rel="noopener">
                       <i class="fas fa-shield-alt"></i> Denuncia-CPEP
                    </a>
                </li>

                <li><a href="panel_rrhh_user.php"><i class="fas fa-user"></i> Perfil</a></li>
                <li><a href="logout.php"><i class="fas fa-sign-out-alt"></i> Cerrar Sesión</a></li>
            </ul>
        </div>

        <!-- Contenido principal -->
        <div class="main-content">
            <div class="welcome-message">Bienvenido, <?= htmlspecialchars($nombre_usuario) ?> <span style="font-size: 14px; color: #7f8c8d;"></span></div>
            <h1>Historial de Solicitudes Aprobadas</h1>

            <!-- ====== Filtros ====== -->
            <form class="filters-bar" method="get" action="">
                <label for="empleado"><i class="fas fa-user"></i> Empleado:</label>
                <select name="empleado" id="empleado" onchange="this.form.submit()">
                    <option value="0">— Todos —</option>
                    <?php if ($result_empleados && $result_empleados->num_rows > 0): ?>
                        <?php while($emp = $result_empleados->fetch_assoc()): ?>
                            <option value="<?= (int)$emp['ID']; ?>" <?= $empleado_id == (int)$emp['ID'] ? 'selected' : '' ?>>
                                <?= htmlspecialchars($emp['nombre']); ?>
                            </option>
                        <?php endwhile; ?>
                    <?php endif; ?>
                </select>
                <?php if ($empleado_id > 0): ?>
                    <button type="button" class="btn-clear" onclick="window.location='<?= basename($_SERVER['PHP_SELF']); ?>'">
                        Limpiar
                    </button>
                <?php endif; ?>
            </form>

            <?php if ($result_solicitudes && $result_solicitudes->num_rows > 0): ?>
                <table>
                    <thead>
                        <tr>
                            <th>Unidad</th>
                            <th>Empleado</th>
                            <th>Tipo de Permiso</th>
                            <th>Fecha de Solicitud</th>
                            <th>Fecha de Salida</th>
                            <th>Acción</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while ($row = $result_solicitudes->fetch_assoc()): ?>
                            <tr>
                                <td><?= htmlspecialchars($row['nombre_unidad']) ?></td>
                                <td><?= htmlspecialchars($row['Nom'] . ' ' . $row['Ape']) ?></td>
                                <td><?= htmlspecialchars($row['tipo_permiso']) ?></td>
                                <td><?= htmlspecialchars($row['fecha_solicitud']) ?></td>
                                <td><?= htmlspecialchars($row['fecha_salida']) ?></td>
                                <td><a href="ver_detalle_rrhh.php?id=<?= (int)$row['id'] ?>" class="action-btn">Ver detalle</a></td>
                            </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            <?php else: ?>
                <p style="text-align: center; color: #777;">No hay solicitudes aprobadas por RRHH <?= $empleado_id ? 'para el empleado seleccionado' : 'en este momento'; ?>.</p>
            <?php endif; ?>
        </div>
    </div>

    <script>
        function toggleSidebar() {
            const sidebar = document.getElementById('sidebar');
            sidebar.classList.toggle('open');
            const mainContent = document.querySelector('.main-content');
            if (sidebar.classList.contains('open')) {
                mainContent.style.marginLeft = '250px';
            } else {
                mainContent.style.marginLeft = '0';
            }
        }
    </script>
</body>
</html>
<?php
// Cerrar recursos
if (isset($stmt)) { $stmt->close(); }
if (isset($result_empleados) && $result_empleados instanceof mysqli_result) { $result_empleados->free(); }
$conn->close();
?>
