<?php
// Confirmar sesión
session_start();

// Verificar si el usuario está logueado
if (!isset($_SESSION['loggedin'])) {
    // Redirigir al usuario a la página de inicio de sesión si no está logueado
    header('Location: index.html');
    exit;
}

// Verificar si el usuario tiene el rol de administrador
if ($_SESSION['role'] !=9) {
    // Redirigir al usuario a la página de inicio con un mensaje de error
    header('Location: inicio.php?error=' . urlencode('No tienes permiso para acceder a esta página.'));
    exit;
}
// El usuario tiene permisos de administrador, continuar con el código del módulo aquí
?>
<?php
// Definir tiempo máximo de inactividad (en segundos)
$tiempo_maximo_inactividad = 900000; // 1 minuto

// Verificar si hay un timestamp de la última actividad en la sesión
if (isset($_SESSION['ultima_actividad'])) {
    $tiempo_inactivo = time() - $_SESSION['ultima_actividad'];
    if ($tiempo_inactivo > $tiempo_maximo_inactividad) {
        // Si el tiempo de inactividad supera el máximo permitido, destruir la sesión y redirigir al inicio
        session_unset();
        session_destroy();
        header('Location: index.html');
        exit;
    }
}
// Actualizar el timestamp de la última actividad
$_SESSION['ultima_actividad'] = time();
?>
<!DOCTYPE html>
<html>
<head>
    <title>Usuarios</title>
    <!-- Agrega los enlaces a los archivos CSS y JavaScript de Bootstrap -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:opsz,wght,FILL,GRAD@24,400,0,0" />
    <!-- SweetAlert -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
    <script>
        var tiempoInactividadMaximo = 900000; // 1 minuto en milisegundos

        function mantenerSesionActiva() {
            var xhr = new XMLHttpRequest();
            xhr.open('GET', 'mantener_sesion.php', true);
            xhr.send();
        }

        function reiniciarContadorInactividad() {
            clearTimeout(timer);
            timer = setTimeout(function() {
                alert('Tu sesión ha expirado por inactividad.');
                window.location.href = 'index.html';
            }, tiempoInactividadMaximo);
        }

        var timer = setTimeout(function() {
            alert('Tu sesión ha expirado por inactividad.');
            window.location.href = 'index.html';
        }, tiempoInactividadMaximo);

        window.onload = reiniciarContadorInactividad;
        document.onmousemove = reiniciarContadorInactividad;
        document.onkeypress = reiniciarContadorInactividad;
    </script>
</head>
<body>
  
<div class="container-fluid p-5 bg-primary text-white text-center">
    	<h1 class="text-center mt-4 mb-4">USUARIOS</h1>
    </div>
	<div class="card ">
    		<div class="card-header">
    			<div class="row d-flex">
                <div class="flex-fill">
                
                
                <div class="col">
                <a href="inicio.php"><button class="btn btn-primary me-1" type="button">Inicio</button></a>
                <a href="datos.php"><button class="btn btn-primary me-1" type="button">Datos</button></a>
                <button type="button" class="btn btn-success" data-toggle="modal" data-target="#exampleModal">Crear Usuario</button>
                <b>Total Registros - <span id="total_data"></span></b>
                <input type="text" name="search" class="form" id="search" placeholder="Search Here" onkeyup="load_data(this.value);" />
    			</div>
    			</div>
    			</div>
                </div>
    		</div>
			<br>
			<div class="container-fluid">
    			<div class="card-body table-responsive table-striped">
    			<table class="  table-responsive table-hover table table-bordered ">
    				<thead >
    					<tr>
    				            		<th width="5%">#</th>
						              	<th width="5%">ID</th>
    				            		<th width="15%">UserName</th>
                            <th width="25%">Nombre</th>
                            <th width="25%">Segundo Nombre</th>
                            <th width="25%">Apellido</th>
                            <th width="25%">Segundo Apellido</th>
                            <th width="60%">Rol</th>
                            <th width="15%">Correo Electronico</th>
                            <th width="15%">PASSWORD</th>
						              	<th width="25%">Genero</th> 			
                            <th width="60%">EstadoCuenta</th>	            		
                            <th width="25%">Fecha Nacimiento</th>
                            <th width="60%">Editar</th>
    					</tr>
    				</thead>
    				<tbody id="post_data"></tbody>
    			</table>
    			</div>
			</div>
    	</div>
<!-- Button trigger modal -->


<!-- Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Usuario Nuevo</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>

      <div class="modal-body">
      <form action="crear_usuario.php" method="post">                                          
                                <label for="validationDefault01" class="form-label">UserName</label>
                                <input type="text" class="form-control" id="username" name="username"  required>
                                
                                
                                <label for="validationDefault01" class="form-label">Nombre</label>
                                <input type="text" class="form-control" id="Nom" name="Nom" required>
                                

                                <label for="validationDefault01" class="form-label">Segundo Nombre</label>
                                <input type="text" class="form-control" id="Nom2" name="Nom2" required>


                                <label for="validationDefault01" class="form-label">Apellido</label>
                                <input type="text" class="form-control" id="Ape" name="Ape" required>

                                <label for="validationDefault01" class="form-label">Segundo Apellido</label>
                                <input type="text" class="form-control" id="Ape2" name="Ape2" required>                  

                                

                                <label for="Unidad">Unidad</label>
                                <select id="unidadSelect" class="form-control" aria-label="Default select example">
                                <option selected disabled>Selecciona una unidad</option>
                                </select>
                                <br>

                                <label for="jefe_departamento">Jefe Inmediato</label>
                                <select id="jefe_departamento" class="form-control" name="jefe_departamento" required>
                                <option selected disabled>Selecciona un jefe de departamento</option>
                                </select>
                                <br>


                                <label for="puesto">Puesto</label>
                                <select id="puesto" class="form-control" name="puesto" aria-label="Default select example">
                                <option selected disabled>Selecciona Puesto</option>
                                </select>
                                <br>
                                <input type="hidden" id="jefe_inmediato_cod" name="jefe_inmediato_cod"  readonly placeholder="Jefe inmediato aparecerá aquí">

                                <!-- Input que se llenará con jefe_departamento -->
                                <!-- <input type="text" class="form-control mt-3" id="jefe_departamento" name="jefe_departamento" required readonly> -->
                                 <!-- Nuevo select de jefe_departamento -->
                                
                                <input  type="hidden" id="nombre_unidad" name="nombre_unidad">

                                <!-- Campo oculto o visible para unidad_id -->
                                <label for="Codigo_unidad">Codigo Unidad</label>
                                <input type="hidden" class="form-control mt-3" id="unidad_id" name="unidad_id" readonly>


                                <label for="FechaNacimiento">Fecha de Nacimiento:</label>
                                <input type="date" id="FechaNacimiento" name="FechaNacimiento" required><br>
                                
                                  
                                <fieldset class="form-group">
                                <div class="row">
                                <legend class="col-form-label col-sm-2 pt-0">Rol</legend>
                                <div class="col-sm-10">
                                    <div class="form-check">
                                    <input class="form-check-input" type="radio" name="Rol" id="Rol" value="UsuarioRegular" required>
                                    <label class="form-check-label" for="gridRadios1">
                                        Usuario Regular
                                    </label>
                                    </div>
                                    <div class="form-check">
                                    <input class="form-check-input" type="radio" name="Rol" id="Rol2" value="Moderador" required>
                                    <label class="form-check-label" for="gridRadios2">
                                        Moderador
                                    </label>
                                    </div>
                                    <div class="form-check">
                                    <input class="form-check-input" type="radio" name="Rol" id="Rol3" value="Administrador" required>
                                    <label class="form-check-label" for="gridRadios3">
                                        Administrador
                                    </label>
                                    </div>
                                </div>
                                </div>
                                </fieldset>
                                <div class="form-floating mb-3">
                                <label for="floatingInput">Email address</label>
                                <input type="email" class="form-control" id="email" name="email" placeholder="name@example.com" required>
                                </div>
                                <div class="form-floating">
                                <label for="floatingPassword">Password</label>
                                <input type="password" class="form-control" id="password" name="password" placeholder="Password" required>
                                </div>                                                   
                                <label for="Genero">Genero</label>
                                <select class="form-control" id="Genero"  name="Genero" required>
                                <option value="Masculino">Masculino</option>
                                <option value="Femenino">Femenino</option>
                                </select>
                               <br>
                        
                                <!-- Otros campos de usuario -->
                                <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                                <button type="reset"  value="Registrar" class="btn btn-danger me-2">Limpiar Formulairo</button>
                            <button type="submit"  value="Registrar" class="btn btn-success">Registrar</button>
                            </div>
                            </form>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>
<script>
$(document).ready(function() {
    $("form").on("submit", function(event) {
        event.preventDefault();
        $.ajax({
            url: "crear_usuario.php",
            type: "POST",
            data: $(this).serialize(),
            dataType: "json",
            success: function(response) {
                if (response.status === "success") {
                    Swal.fire({
                        title: "¡Buen trabajo!",
                        text: response.message,
                        icon: "success"
                    }).then(function() {
                        window.location.href = "usuarios.php";
                    });
                } else {
                    Swal.fire({
                        title: "Error",
                        text: response.message,
                        icon: "error"
                    });
                }
            },
            error: function(xhr, status, error) {
                Swal.fire({
                    title: "Error",
                    text: "Hubo un problema al procesar la solicitud, NickName o Correo Electronico Repetido con otro usuario",
                    icon: "error"
                });
            }
        });
    });
});
</script>
<script>
$(document).ready(function () {
   const puestoActual = $('#ex').data('puesto');

  // Cargar unidades
  $.ajax({
    url: 'get_unidades.php',
    method: 'GET',
    dataType: 'json',
    success: function (data) {
      $.each(data, function (index, unidad) {
        $('#unidadSelect').append(
          $('<option>', {
            value: unidad.unidad_id,
            text: unidad.nombre_unidad
          })
        );
      });
    },
    error: function () {
      alert('No se pudieron cargar las unidades.');
    }
  });

  // Al seleccionar una unidad
  $('#unidadSelect').on('change', function () {
    var unidadId = $(this).val();
    var nombreUnidad = $(this).find(':selected').text();

    $('#unidad_id').val(unidadId);
    $('#nombre_unidad').val(nombreUnidad);

    // 👉 LIMPIAR y cargar jefes dinámicamente
    $('#jefe_departamento').empty().append('<option selected disabled>Selecciona Jefe</option>');

    $.ajax({
      url: 'get_jefes.php',
      method: 'GET',
      data: { unidad_id: unidadId },
      dataType: 'json',
      success: function (jefes) {
        $.each(jefes, function (index, jefe) {
          $('#jefe_departamento').append(
            $('<option>', {
              value: jefe,
              text: jefe
            })
          );
        });

        // Opcional: seleccionar automáticamente el primer jefe
        if (jefes.length > 0) {
          $('#jefe_departamento').val(jefes[0]);
        }
      },
      error: function () {
        alert('No se pudieron cargar los jefes.');
      }
    });

    // 👉 LIMPIAR y cargar puestos dinámicamente
    $('#puesto').empty().append('<option selected disabled>Selecciona Puesto</option>');

  $.ajax({
            url: 'get_puestos.php',
            method: 'GET',
            data: { unidad_id: unidadId },
            dataType: 'json',
            success: function (puestos) {
           $.each(puestos, function (index, p) {
        const option = $('<option>', {
            value: p.puesto,
            text: p.puesto,
            'data-jefe': p.jefe_inmediato_cod  // atributo personalizado
        });

        if (p.puesto === puestoActual) {
            option.attr('selected', true);
        }

        $('#puesto').append(option);
                });
            },
            error: function () {
                alert('No se pudieron cargar los puestos.');
            }
        });
        // Este bloque va fuera del AJAX, para que se active siempre que cambie la selección
$('#puesto').on('change', function () {
    const selected = $(this).find('option:selected');
    const jefe = selected.data('jefe');

    $('#jefe_inmediato_cod').val(jefe); // si es un input
    // $('#jefe_inmediato').text(jefe); // si usas un <div> en lugar de input
});
    });
});

</script>

<!-- <script>
$(document).ready(function() {
  $.ajax({
    url: 'get_unidades.php', // Archivo PHP que consultará la base de datos
    method: 'GET',
    dataType: 'json',
    success: function(data) {
      $.each(data, function(index, unidad) {
        $('#unidadSelect').append(
          $('<option>', {
            value: unidad.unidad_id,
            text: unidad.nombre_unidad
          })
        );
      });
    },
    error: function() {
      alert('No se pudieron cargar las unidades.');
    }
  });
});
</script> -->
</body>
</html>
<script>
load_data();
function load_data(query = '')
{
	var form_data = new FormData();

	form_data.append('query', query);

	var ajax_request = new XMLHttpRequest();

	ajax_request.open('POST', 'process_data_accounts.php');

	ajax_request.send(form_data);

	ajax_request.onreadystatechange = function()
	{
		if(ajax_request.readyState == 4 && ajax_request.status == 200)
		{
			var response = JSON.parse(ajax_request.responseText);

			var html = '';

			var serial_no = 1;
			if(response.length > 0)
			{
				for(var count = 0; count < response.length; count++)
				{
					html += '<tr>';
					html += '<td>'+serial_no+'</td>';
					html += '<td>'+response[count].id+'</td>';
					html += '<td>'+response[count].username+'</td>';
          html += '<td>'+response[count].Nom+'</td>';
          html += '<td>'+response[count].Nom2+'</td>';
          html += '<td>'+response[count].Ape+'</td>';
          html += '<td>'+response[count].Ape2+'</td>';
          html += '<td>'+response[count].Rol+'</td>';
					html += '<td>'+response[count].CorreoElectronico+'</td>';
          html += '<td>'+response[count].PASSWORD+'</td>';                
          html += '<td>'+response[count].Genero+'</td>';
          html += '<td>'+response[count].EstadoCuenta+'</td>';                              
          html += '<td>'+response[count].FechaNacimiento+'</td>';                  
					html += '<td><a href="editar_usuario.php?id='+response[count].id+'"><span class="material-symbols-outlined">edit</span></a></td>';
					html += '</tr>';
					serial_no++;
				}
			}
			else
			{
				html += '<tr><td colspan="3" class="text-center">No Data Found</td></tr>';
			}
			document.getElementById('post_data').innerHTML = html;
			document.getElementById('total_data').innerHTML = response.length;
		}
	}
}
</script>

