<?php
// Mostrar errores para depuraciÃ³n
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();
require 'conexion.php';

// Verificar sesiÃ³n
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$empleado_id = $_SESSION['user_id'];
$empleado = [
    'Nom' => '', 'Nom2' => '', 'Ape' => '', 'Ape2' => '',
    'CorreoElectronico' => '', 'fecha_ingreso' => '',
    'unidad' => '', 'puesto' => '',
    'tipo_contrato' => '' // ðŸ”¹ nuevo campo
];
$permisos = [];

// Datos del empleado (incluyendo tipo_contrato)
$stmt_empleado = $conn->prepare("
    SELECT a.Nom, a.Nom2, a.Ape, a.Ape2, a.CorreoElectronico, a.fecha_ingreso, a.tipo_contrato,
           u.nombre_unidad AS unidad, p.nombre_puesto AS puesto
    FROM accounts a
    LEFT JOIN unidad u ON a.cod_unidad = u.cod_unidad
    LEFT JOIN puestos p ON a.cod_puesto = p.cod_puesto
    WHERE a.ID = ?
");
$stmt_empleado->bind_param("i", $empleado_id);
$stmt_empleado->execute();
$result_empleado = $stmt_empleado->get_result();
if ($row = $result_empleado->fetch_assoc()) {
    $empleado = $row;
}
$stmt_empleado->close();

// Permisos del usuario (se muestran todos los que cumplan la condiciÃ³n de tu lÃ³gica)
$stmt_permisos = $conn->prepare("
    SELECT v.fecha_inicio, v.fecha_fin, v.dias, v.observaciones
    FROM vacaciones v
    LEFT JOIN solicitudes s ON v.id_solicitud = s.id
    WHERE v.id_usuario = ?
      AND (
          v.id_solicitud IS NULL
          OR (s.estado = 'Aprobada por Recursos Humanos' AND v.fecha_inicio >= '2025-07-01')
      )
    ORDER BY v.fecha_inicio DESC
");
$stmt_permisos->bind_param("i", $empleado_id);
$stmt_permisos->execute();
$result_permisos = $stmt_permisos->get_result();
while ($row = $result_permisos->fetch_assoc()) {
    $permisos[] = $row;
}
$stmt_permisos->close();

/**
 * Cálculo de días tomados EXCLUYENDO
 * rangos y fechas específicas
 */

// 🔴 Rangos exactos a excluir
$rangos_excluidos = [
    ['inicio' => '2025-09-29', 'fin' => '2025-09-30'],
];

// 🔴 Fechas individuales a excluir
$fechas_excluidas = [
    '2025-12-24',
    '2025-12-26',
    '2025-12-31',
    '2026-01-02'
];

$dias_tomados = 0.0;

foreach ($permisos as $permiso) {

    // Normalizar fechas
    $inicio = date('Y-m-d', strtotime($permiso['fecha_inicio']));
    $fin    = date('Y-m-d', strtotime($permiso['fecha_fin']));

    // 🟡 Excluir rangos exactos
    foreach ($rangos_excluidos as $rango) {
        if ($inicio === $rango['inicio'] && $fin === $rango['fin']) {
            continue 2; // salta este permiso completo
        }
    }

    // 🟡 Excluir fechas individuales
    if (in_array($inicio, $fechas_excluidas, true) || in_array($fin, $fechas_excluidas, true)) {
        continue;
    }

    // ✅ Sumar solo los válidos
    $dias_tomados += (float)$permiso['dias'];
}


// ðŸ”¹ LÃ­mite base segÃºn tipo de contrato
$tipo_contrato = $empleado['tipo_contrato'] ?? null;

if ($tipo_contrato === 'Contrato') {
    $vacaciones_correspondientes = 6.0;   // Contrato â†’ 6 dÃ­as
} else {
    $vacaciones_correspondientes = 12.0;  // Resto â†’ 12 dÃ­as
}

// ðŸ”¹ Overrides por ID especÃ­ficos
$ids_5_dias = [165, 34, 47, 41, 71, 81, 131, 83];
$ids_6_dias = [166, 167, 48];
$ids_4_dias = [168, 164];
$id_4_5_dias = 162;

if (in_array($empleado_id, $ids_5_dias, true)) {
    $vacaciones_correspondientes = 5.0;
} elseif (in_array($empleado_id, $ids_6_dias, true)) {
    $vacaciones_correspondientes = 6.0;
} elseif (in_array($empleado_id, $ids_4_dias, true)) {
    $vacaciones_correspondientes = 4.0;
} elseif ($empleado_id == $id_4_5_dias) {
    $vacaciones_correspondientes = 4.5;
}

$dias_pendientes = max(0, $vacaciones_correspondientes - $dias_tomados);
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Perfil del Empleado</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Roboto', sans-serif;
            background: #f5f7fa;
            margin: 0;
            padding: 20px 0;
            color: #333;
        }
        .container {
            max-width: 1000px;
            margin: 0 auto;
            background: #fff;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            overflow: hidden;
        }
        .header {
            background: #0073aa;
            color: #fff;
            padding: 20px;
            text-align: center;
            border-bottom: 1px solid #005670;
        }
        .header h1 {
            font-size: 22px;
            font-weight: 500;
            margin: 0;
        }
        .section {
            padding: 20px;
            border-bottom: 1px solid #eee;
        }
        .section:last-child {
            border-bottom: none;
        }
        .info-table, .vacation-table, .summary-table {
            width: 100%;
            border-collapse: collapse;
            margin: 10px 0;
        }
        .info-table td, .vacation-table th, .vacation-table td, .summary-table td {
            padding: 12px;
            text-align: left;
            border-bottom: 1px solid #eee;
        }
        .info-table .label {
            font-weight: 500;
            color: #005670;
            width: 30%;
        }
        .info-table .value {
            color: #333;
            width: 70%;
        }
        .info-table .highlight {
            background: #fff9e6;
            font-weight: 500;
            color: #e67e22;
        }
        .vacation-table th {
            background: #f0f4f8;
            font-weight: 500;
            color: #005670;
            text-align: center;
        }
        .vacation-table td {
            text-align: center;
            vertical-align: middle;
        }
        .summary-table td:first-child {
            font-weight: 500;
            color: #005670;
            padding-right: 15px;
        }
        .summary-table .highlight {
            color: #e74c3c;
            font-weight: 500;
        }
        button {
            background: #0073aa;
            color: #fff;
            border: none;
            padding: 10px 20px;
            border-radius: 4px;
            cursor: pointer;
            font-weight: 500;
            margin-top: 15px;
            transition: background 0.3s;
        }
        button:hover {
            background: #005670;
        }
        .back-button {
            background: #e74c3c;
        }
        .back-button:hover {
            background: #c0392b;
        }
        @media (max-width: 768px) {
            .container { padding: 10px; }
            .header h1 { font-size: 18px; }
            .info-table td, .vacation-table th, .vacation-table td, .summary-table td { font-size: 14px; padding: 8px; }
            .section { padding: 15px; }
            button { width: 100%; margin-bottom: 10px; }
            .section:last-child .buttons { flex-direction: column; gap: 10px; }
        }
        @media (max-width: 480px) {
            .info-table .label, .info-table .value { width: 100%; display: block; }
            .vacation-table th, .vacation-table td { font-size: 12px; padding: 6px; }
            .summary-table td { font-size: 12px; padding: 6px; }
            .header h1 { font-size: 16px; }
        }
    </style>
</head>
<body>
<div class="container">
    <div class="header">
        <h1>Perfil del Empleado</h1>
    </div>

    <!-- InformaciÃ³n del empleado -->
    <div class="section">
        <table class="info-table">
            <tr>
                <td class="label">Nombre completo</td>
                <td class="value highlight">
                    <?= htmlspecialchars(trim(($empleado['Nom'] ?? '') . ' ' . ($empleado['Nom2'] ?? '') . ' ' . ($empleado['Ape'] ?? '') . ' ' . ($empleado['Ape2'] ?? ''))) ?>
                </td>
            </tr>
            <tr>
                <td class="label">Correo electrÃ³nico</td>
                <td class="value"><?= htmlspecialchars($empleado['CorreoElectronico'] ?? 'No registrado') ?></td>
            </tr>
            <tr>
                <td class="label">Unidad</td>
                <td class="value"><?= htmlspecialchars($empleado['unidad'] ?? 'No asignada') ?></td>
            </tr>
            <tr>
                <td class="label">Puesto</td>
                <td class="value"><?= htmlspecialchars($empleado['puesto'] ?? 'No asignado') ?></td>
            </tr>
            <tr>
                <td class="label">Ingreso Permanente</td>
                <td class="value"><?= htmlspecialchars($empleado['fecha_ingreso'] ?? 'No registrada') ?></td>
            </tr>
        </table>
    </div>

    <!-- Historial de permisos -->
    <div class="section">
        <table class="vacation-table">
            <tr>
                <th colspan="6">Historial de Permisos</th>
            </tr>
            <tr>
                <th>Desde</th>
                <th>Hasta</th>
                <th>DÃ­as</th>
                <th>Documento (SÃ­)</th>
                <th>Documento (No)</th>
                <th>Observaciones</th>
            </tr>
            <?php if (!empty($permisos)): ?>
                <?php foreach ($permisos as $permiso): ?>
                    <tr>
                        <td><?= htmlspecialchars(date('d-m-Y', strtotime($permiso['fecha_inicio']))) ?></td>
                        <td><?= htmlspecialchars(date('d-m-Y', strtotime($permiso['fecha_fin']))) ?></td>
                        <td><?= number_format((float)$permiso['dias'], 1) ?></td>
                        <td></td>
                        <td></td>
                        <td><?= htmlspecialchars($permiso['observaciones'] ?? '') ?></td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="6">No hay permisos registrados.</td>
                </tr>
            <?php endif; ?>
        </table>
    </div>

    <!-- Resumen -->
    <div class="section">
        <table class="summary-table">
            <tr>
                <td colspan="2">Vacaciones Correspondientes (Jul 2024 - Jul 2025)</td>
                <td><?= number_format($vacaciones_correspondientes, 1) ?></td>
            </tr>
            <tr>
                <td colspan="2">Total DÃ­as</td>
                <td><?= number_format($vacaciones_correspondientes, 1) ?></td>
            </tr>
            <tr>
                <td colspan="2">Vacaciones Tomadas</td>
                <td><?= number_format($dias_tomados, 1) ?></td>
            </tr>
            <tr>
                <td colspan="2" class="highlight">Pendientes</td>
                <td class="highlight"><?= number_format($dias_pendientes, 1) ?></td>
            </tr>
        </table>
        <div class="buttons" style="display: flex; gap: 10px;">
            <button class="back-button" onclick="window.location.href='dashboard_usuario.php'">AtrÃ¡s</button>
            <button onclick="window.print()">Imprimir Perfil</button>
        </div>
    </div>
</div>
</body>
</html>
<?php $conn->close(); ?>
