<?php
include 'conexion.php';

$stmt = $conexion->query("
    SELECT 
        e.id_usuario, e.nombre_empleado,
        COALESCE(SUM(vp.dias_generados), 0) AS asignados,
        COALESCE(SUM(vp.dias_utilizados), 0) AS utilizados,
        COALESCE(SUM(vp.dias_generados) - SUM(vp.dias_utilizados), 0) AS disponibles
    FROM empleados e
    LEFT JOIN vacaciones_periodos vp 
        ON vp.empleado_id = e.id_usuario AND vp.estado = 'activo'
    GROUP BY e.id_usuario, e.nombre_empleado
    ORDER BY e.nombre_empleado
");

$data = $stmt->fetchAll(PDO::FETCH_ASSOC);
echo json_encode($data);
?>
