<?php
include 'conexion.php';
session_start();

if (!isset($_SESSION['id'])) {
    echo json_encode(['error' => 'Usuario no autenticado']);
    exit;
}

$id = $_SESSION['id'];

$stmt = $conexion->prepare("
    SELECT 
        SUM(dias_generados) AS asignados,
        SUM(dias_utilizados) AS utilizados
    FROM vacaciones_periodos 
    WHERE empleado_id = ? AND estado = 'activo'
");
$stmt->execute([$id]);
$result = $stmt->fetch(PDO::FETCH_ASSOC);

$asignados = (int)($result['asignados'] ?? 0);
$utilizados = (int)($result['utilizados'] ?? 0);
$disponibles = max(0, $asignados - $utilizados);

echo json_encode([
    'asignados' => $asignados,
    'utilizados' => $utilizados,
    'disponibles' => $disponibles
]);
?>
