<?php
session_start();
require 'conexion.php';
mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

// Verificar sesión y rol RRHH (9)
if (!isset($_SESSION['user_id']) || $_SESSION['role'] != 9) {
    header("Location: login.php");
    exit;
}

// Validar parámetro id
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    die("<h2 style='color:red; text-align:center;'>Error: ID no válido.<br><a href='gestionar_solicitudes_rrhh.php'>Volver al listado</a></h2>");
}
$solicitud_id = (int)$_GET['id'];

// Obtener datos de la solicitud
$sql = "SELECT id_usuario, tipo_permiso, fecha_solicitud, fecha_salida, descripcion_motivo, estado,
               unidad, puesto, horario_permiso, nombre_jefe_inmediato,
               firma_funcionario, firma_jefe, firma_rrhh,
               fecha_aprobacion_jefe, fecha_aprobacion_rrhh, nombre_funcionario_firma, nombre_jefe_firma, nombre_rrhh_firma
        FROM solicitudes
        WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param('i', $solicitud_id);
$stmt->execute();
$solicitud = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$solicitud) {
    die("<h2 style='color:red; text-align:center;'>Error: solicitud no encontrada.<br><a href='gestionar_solicitudes_rrhh.php'>Volver al listado</a></h2>");
}

$datos_vacaciones = null;

if ($solicitud['tipo_permiso'] === 'Vacaciones') {
    $sql_vacaciones = "SELECT fecha_inicio, fecha_fin, dias 
                       FROM vacaciones 
                       WHERE id_solicitud = ?";
    if ($stmt = $conn->prepare($sql_vacaciones)) {
        $stmt->bind_param('i', $solicitud_id);
        $stmt->execute();
        $result = $stmt->get_result();
        $datos_vacaciones = $result->fetch_assoc();
        $stmt->close();
    }
}

// Obtener nombre completo del solicitante
$sql2 = "SELECT Nom, Nom2, Ape, Ape2 FROM accounts WHERE ID = ?";
$stmt2 = $conn->prepare($sql2);
$stmt2->bind_param('i', $solicitud['id_usuario']);
$stmt2->execute();
$stmt2->bind_result($nom, $nom2, $ape, $ape2);
$stmt2->fetch();
$nombre_completo = trim(implode(' ', array_filter([$nom, $nom2, $ape, $ape2])));
$stmt2->close();

// Formatear fechas
$fecha_solicitud_fmt = date('Y-m-d\TH:i', strtotime($solicitud['fecha_solicitud']));
$fecha_salida_fmt    = date('Y-m-d\TH:i', strtotime($solicitud['fecha_salida']));
$horario_permiso     = $solicitud['horario_permiso'] ?? "N/A";

$conn->close();
?>

<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Detalle de Solicitud - Pase de Salida RRHH</title>
<style>
    body { font-family: Arial, sans-serif; background-color: #f5f5f5; margin:0; padding:0; }
    .container { max-width:800px; margin:20px auto; background-color:#fff; padding:20px; border:1px solid #ccc; box-shadow:0 0 10px rgba(0,0,0,0.1); position:relative; }
    .ribbon { position:absolute; top:0; left:0; width:10px; height:100%; background-color:#68c8d8; }
    header { display:flex; justify-content:space-between; align-items:center; margin-bottom:20px; }
    header h1 { font-size:24px; color:#333; }
    .form-group { margin-bottom:15px; }
    .form-group label { display:block; font-weight:bold; margin-bottom:5px; }
    .form-group input, textarea { width:100%; padding:8px; border:1px solid #ccc; border-radius:4px; box-sizing:border-box; background:#f9f9f9; }
    .form-group.inline { display:flex; gap:20px; }
    .form-group.inline > div { flex:1; }
    .form-group.inline .motivo { display:flex; align-items:center; gap:10px; }
    .signatures { display:flex; gap:40px; justify-content:space-around; margin-top:20px; }
    .signature-block { flex:1; display:flex; flex-direction:column; align-items:center; padding:15px; border:1px solid #ddd; border-radius:8px; background:#f9f9f9; min-width:180px; box-shadow:0 2px 5px rgba(0,0,0,0.1); }
    .signature-block label { font-size:1rem; margin-bottom:5px; }
    .signature-block .name { font-weight:bold; margin-bottom:5px; }
    .signature-block .date { font-size:0.9rem; color:#555; }
    .print-button { display:block; margin:20px auto; padding:10px 20px; background:#68c8d8; color:white; border:none; border-radius:5px; font-size:16px; cursor:pointer; }
    .print-button:hover { background:#56b0c0; }
    footer { text-align:center; margin-top:30px; font-size:12px; color:#666; }
    @media (max-width: 767px) {
        .container { margin:10px; padding:15px; max-width:100%; box-shadow:none; border:none; }
        header { flex-direction:column; align-items:center; gap:15px; text-align:center; }
        .logo-left img, .logo-right img { width:80px; height:auto; }
        header h1 { font-size:20px; }
        .form-group.inline { flex-direction:column; gap:10px; }
        .form-group.inline > div { flex:none; width:100%; }
        .form-group.inline .motivo { justify-content:center; gap:15px; flex-wrap:wrap; }
        .signatures { flex-direction:column; gap:20px; align-items:center; }
        .signature-block { min-width:auto; width:80%; }
        .print-button { width:100%; padding:12px; font-size:18px; }
    }
</style>
</head>
<body>
<div class="container">
    <div class="ribbon"></div>
    <header>
        <div class="logo-left"><img src="logo-proasol.png" alt="Logo PROASOL" width="100"></div>
        <h1>Detalle Solicitud</h1>
        <div class="logo-right"><img src="gobierno-logo.png" alt="Logo Gobierno" width="150"></div>
    </header>

    <div class="form-group">
        <label>Nombre del Funcionario</label>
        <input type="text" value="<?= htmlspecialchars($nombre_completo) ?>" readonly>
    </div>

    <div class="form-group inline">
        <div><label>Unidad</label><input type="text" value="<?= htmlspecialchars($solicitud['unidad']) ?>" readonly></div>
        <div><label>Puesto</label><input type="text" value="<?= htmlspecialchars($solicitud['puesto']) ?>" readonly></div>
    </div>

    <div class="form-group">
        <label>Nombre del Jefe Inmediato</label>
        <input type="text" value="<?= htmlspecialchars($solicitud['nombre_jefe_inmediato'] ?? 'N/A') ?>" readonly>
    </div>

    <div class="form-group inline">
        <div><label>Fecha de Solicitud</label><input type="datetime-local" value="<?= $fecha_solicitud_fmt ?>" readonly></div>
        <div class="motivo">
            <label for="tipo_permiso">Tipo de Permiso:</label>
            <input type="radio" name="tipo_permiso" value="Personal" <?= $solicitud['tipo_permiso'] === 'Personal' ? 'checked' : '' ?> disabled> Personal
            <input type="radio" name="tipo_permiso" value="Oficial" <?= $solicitud['tipo_permiso'] === 'Oficial' ? 'checked' : '' ?> disabled> Oficial
            <input type="radio" name="tipo_permiso" value="Vacaciones" <?= $solicitud['tipo_permiso'] === 'Vacaciones' ? 'checked' : '' ?> disabled> Vacaciones
        </div>
    </div>

    <div class="form-group" id="descripcion-motivo" style="<?= $solicitud['tipo_permiso'] === 'Vacaciones' ? 'display: none;' : '' ?>">
        <label>Descripción del Motivo</label>
        <textarea rows="3" readonly><?= htmlspecialchars($solicitud['descripcion_motivo']) ?></textarea>
    </div>

    <div class="form-group inline" id="fecha-horario" style="<?= $solicitud['tipo_permiso'] === 'Vacaciones' ? 'display: none;' : '' ?>">
        <div><label>Fecha de Salida</label><input type="datetime-local" value="<?= $fecha_salida_fmt ?>" readonly></div>
        <div><label>Horario / Días del Permiso</label><input type="text" value="<?= htmlspecialchars($horario_permiso) ?>" readonly></div>
    </div>

    <div id="campos-vacaciones" style="<?= $solicitud['tipo_permiso'] === 'Vacaciones' ? '' : 'display: none;' ?>">
        <div class="form-group inline">
            <div>
                <label for="fecha_inicio">Fecha Inicio de Vacaciones</label>
                <input type="date" id="fecha_inicio" value="<?= htmlspecialchars($datos_vacaciones['fecha_inicio'] ?? '') ?>" readonly>
            </div>
            <div>
                <label for="fecha_fin">Fecha Final de Vacaciones</label>
                <input type="date" id="fecha_fin" value="<?= htmlspecialchars($datos_vacaciones['fecha_fin'] ?? '') ?>" readonly>
            </div>
        </div>
        <div class="form-group">
            <label for="dias">Días Solicitados</label>
            <input type="number" id="dias" value="<?= htmlspecialchars($datos_vacaciones['dias'] ?? '') ?>" readonly>
        </div>
    </div>

    <div class="signatures">
        <div class="signature-block">
            <label><strong>Solicitante</strong></label><br>
            <span class="name">
                <?= htmlspecialchars($solicitud['nombre_funcionario_firma'] ?? '---') ?>
                (<?= htmlspecialchars($solicitud['firma_funcionario'] ?? '') ?>)
            </span><br>
            <span class="date">Fecha: <?= !empty($solicitud['fecha_solicitud']) ? date('d-m-Y H:i', strtotime($solicitud['fecha_solicitud'])) : '---' ?></span>
        </div>

        <div class="signature-block">
            <label><strong>Jefe Inmediato</strong></label><br>
            <span class="name">
                <?= htmlspecialchars($solicitud['nombre_jefe_firma'] ?? '---') ?>
                (<?= htmlspecialchars($solicitud['firma_jefe'] ?? '') ?>)
            </span><br>
            <span class="date">Fecha: <?= !empty($solicitud['fecha_aprobacion_jefe']) ? date('d-m-Y H:i', strtotime($solicitud['fecha_aprobacion_jefe'])) : '---' ?></span>
        </div>

        <div class="signature-block">
            <label><strong>RRHH</strong></label><br>
            <span class="name">
                <?= htmlspecialchars($solicitud['nombre_rrhh_firma'] ?? '---') ?>
                (<?= htmlspecialchars($solicitud['firma_rrhh'] ?? '') ?>)
            </span><br>
            <span class="date">Fecha: <?= !empty($solicitud['fecha_aprobacion_rrhh']) ? date('d-m-Y H:i', strtotime($solicitud['fecha_aprobacion_rrhh'])) : '---' ?></span>
        </div>
    </div>

    <footer>
        <p>CENTRO CÍVICO GUBERNAMENTAL, TORRE 2, PISO 1, BOULEVARD JUAN PABLO II, TEGUCIGALPA, M.D.C., HONDURAS</p>
        <p>(+504) 2242-7981</p>
    </footer>

    <button class="print-button" onclick="window.print()">Imprimir Pase</button>
</div>

<script>
document.addEventListener("DOMContentLoaded", function () {
    const tipoPermiso = <?= json_encode($solicitud['tipo_permiso']) ?>;
    const descripcionMotivo = document.getElementById('descripcion-motivo');
    const fechaHorario = document.getElementById('fecha-horario');
    const camposVacaciones = document.getElementById('campos-vacaciones');

    if (tipoPermiso === "Vacaciones") {
        descripcionMotivo.style.display = "none";
        fechaHorario.style.display = "none";
        camposVacaciones.style.display = "block";
    } else {
        descripcionMotivo.style.display = "block";
        fechaHorario.style.display = "flex";
        camposVacaciones.style.display = "none";
    }
});
</script>
</body>
</html>