<?php
session_start();
require 'conexion.php';

// Asegurarse de que el usuario esté autenticado
if (!isset($_SESSION['user_id'])) {
    $_SESSION['error'] = 'Debes iniciar sesión para ver las solicitudes.';
    header("Location: login.php");
    exit;
}

// Incluir la configuración de correo
require 'email_config.php';

// Consulta para obtener las solicitudes con los nombres de los usuarios y correos
$sql = "SELECT s.id, s.tipo_solicitud, s.descripcion_motivo, s.fecha_solicitud, s.estado, 
        CONCAT(a.Nom, ' ', COALESCE(a.Nom2, ''), ' ', a.Ape, ' ', COALESCE(a.Ape2, '')) AS nombre_completo, a.CorreoElectronico
        FROM solicitudes s
        JOIN accounts a ON s.id_usuario = a.ID
        WHERE s.tipo_solicitud IN (
            'Constancia de trabajo', 
            'Constancia de trabajo con deducciones', 
            'Constancia para Embajadas', 
            'Declaración de impuestos', 
            'Voucher de pagos'
        )
        ORDER BY s.fecha_solicitud DESC";

$result = $conn->query($sql);

// Función para enviar correo usando la función de email_config.php
function enviarCorreo($to, $nombre, $tipoSolicitud) {
    $subject = "Solicitud Aprobada - Listo para Retiro";
    $body = "<h2>Hola $nombre,</h2>
             <p>Tu solicitud de <strong>$tipoSolicitud</strong> ha sido aprobada por Recursos Humanos. Puedes pasar por nuestras oficinas a retirar el documento solicitado.</p>
             <p>Saludos,<br>Equipo de Recursos Humanos</p>";
    return sendEmail($to, $subject, $body);
}

// Manejar la acción de "Finalizado" si se envía por POST
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['accion']) && $_POST['accion'] === 'finalizar' && isset($_POST['solicitud_id'])) {
    $solicitud_id = $_POST['solicitud_id'];
    $stmt = $conn->prepare("SELECT a.CorreoElectronico, CONCAT(a.Nom, ' ', COALESCE(a.Nom2, ''), ' ', a.Ape, ' ', COALESCE(a.Ape2, '')) AS nombre_completo, s.tipo_solicitud 
                           FROM solicitudes s 
                           JOIN accounts a ON s.id_usuario = a.ID 
                           WHERE s.id = ?");
    $stmt->bind_param("i", $solicitud_id);
    $stmt->execute();
    $result_detalle = $stmt->get_result();
    
    if ($row = $result_detalle->fetch_assoc()) {
        $correo = $row['CorreoElectronico'];
        $nombre = $row['nombre_completo'];
        $tipoSolicitud = $row['tipo_solicitud'];
        
        // Actualizar el estado a "Finalizado" en la tabla solicitudes
        $update_stmt = $conn->prepare("UPDATE solicitudes SET estado = 'Finalizado' WHERE id = ?");
        $update_stmt->bind_param("i", $solicitud_id);
        $update_success = $update_stmt->execute();
        $update_stmt->close();

        if ($update_success && enviarCorreo($correo, $nombre, $tipoSolicitud)) {
            echo json_encode(['success' => true, 'message' => 'Solicitud marcada como finalizada y correo enviado con éxito.']);
        } elseif ($update_success) {
            echo json_encode(['success' => false, 'message' => 'Solicitud marcada como finalizada, pero hubo un error al enviar el correo.']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Error al marcar la solicitud como finalizada.']);
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'Solicitud no encontrada.']);
    }
    $stmt->close();
    $conn->close();
    exit;
}

$conn->close();
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ver Solicitudes</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        /* Estilos generales */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        body {
            background-color: #f4f7fa;
            color: #333;
        }

        .container {
            display: flex;
            min-height: 100vh;
        }

        /* Menú lateral */
        .sidebar {
            width: 250px;
            background: linear-gradient(135deg, #2c3e50, #34495e);
            color: white;
            padding: 20px 15px;
            position: fixed;
            height: 100%;
            box-shadow: 2px 0 5px rgba(0, 0, 0, 0.1);
            transition: transform 0.3s ease;
            z-index: 1000;
        }

        .sidebar.collapsed {
            transform: translateX(-250px);
            width: 0;
        }

        .sidebar h2 {
            font-size: 24px;
            margin-bottom: 30px;
            text-align: center;
            color: #68c8d8;
            font-weight: 700;
        }

        .sidebar ul {
            list-style: none;
            padding: 0;
        }

        .sidebar ul li {
            margin-bottom: 15px;
        }

        .sidebar ul li a {
            color: #ecf0f1;
            text-decoration: none;
            font-size: 16px;
            display: flex;
            align-items: center;
            padding: 10px 15px;
            border-radius: 5px;
            transition: background 0.3s, color 0.3s;
        }

        .sidebar ul li a:hover {
            background: #465c71;
            color: #68c8d8;
        }

        .sidebar ul li a i {
            margin-right: 10px;
            font-size: 16px;
        }

        .toggle-btn {
            display: none;
            position: fixed;
            left: 10px;
            top: 10px;
            background: #68c8d8;
            color: white;
            border: none;
            padding: 10px;
            border-radius: 5px;
            cursor: pointer;
            z-index: 1001;
            transition: background 0.3s;
        }

        .toggle-btn:hover {
            background: #5dade2;
        }

        .main-content {
            flex-grow: 1;
            padding: 40px;
            margin-left: 250px;
            transition: margin-left 0.3s ease;
            width: calc(100% - 250px);
        }

        h1 {
            color: #2c3e50;
            text-align: center;
            margin-bottom: 20px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            background-color: white;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            overflow-x: auto; /* Permite desplazamiento horizontal en pantallas pequeñas */
        }

        th, td {
            padding: 12px;
            text-align: left;
            border-bottom: 1px solid #ddd;
            white-space: nowrap; /* Evita que el texto se divida */
        }

        th {
            background-color: #2c3e50;
            color: white;
            position: sticky;
            top: 0;
            z-index: 1;
        }

        tr:nth-child(even) {
            background-color: #f9f9f9;
        }

        tr:hover {
            background-color: #f1f1f1;
        }

        .action-btn {
            padding: 6px 12px;
            background-color: #2ecc71;
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            text-decoration: none;
            font-size: 14px;
            transition: background-color 0.3s;
        }

        .action-btn:hover {
            background-color: #27ae60;
        }

        .processed {
            color: green;
            font-weight: bold;
        }

        /* Responsive */
        @media (max-width: 1024px) {
            .sidebar {
                width: 220px;
            }
            .main-content {
                margin-left: 220px;
                width: calc(100% - 220px);
                padding: 25px;
            }
        }

        @media (max-width: 768px) {
            .toggle-btn {
                display: block;
            }
            .sidebar {
                transform: translateX(-250px);
                width: 250px;
            }
            .sidebar.open {
                transform: translateX(0);
            }
            .main-content {
                margin-left: 0;
                width: 100%;
                padding: 20px;
            }
            th, td {
                padding: 8px;
                font-size: 14px;
            }
            .action-btn {
                padding: 4px 8px;
                font-size: 12px;
            }
        }

        @media (max-width: 480px) {
            .main-content {
                padding: 15px;
            }
            h1 {
                font-size: 18px;
            }
            th, td {
                padding: 6px;
                font-size: 12px;
            }
            .action-btn {
                padding: 3px 6px;
                font-size: 10px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
       <div class="sidebar" id="sidebar">
    <h2>Panel RRHH</h2>
     <ul>
        <li><a href="dashboard_rrhh.php"><i class="fas fa-home"></i> Inicio</a></li>
        <?php if ($_SESSION['role'] != 11): ?>
            <li><a href="gestionar_solicitudes_rrhh.php"><i class="fas fa-tasks"></i> Gestionar Solicitudes</a></li>
        <?php endif; ?>
        <li><a href="panel_jefe_rrhh.php"><i class="fas fa-chart-bar"></i>Solicitudes Unidad RRHH</a></li>
         <li><a href="panel_rrhh_vacaciones.php"><i class="fas fa-chart-bar"></i>Solicitudes Vacaciones RRHH</a></li>
        <li><a href="estadisticas_rrhh.php"><i class="fas fa-chart-bar"></i> Estadísticas</a></li>
        <li><a href="solicitudes_aprobadas_rrhh.php"><i class="fas fa-check"></i> Historial de Solicitudes Aprobadas</a></li>
        <li><a href="ver_solicitudes.php"><i class="fas fa-eye"></i> Más Solicitudes</a></li>
        <?php if ($_SESSION['role'] != 11): ?>
            <li><a href="gestionar_empleados.php"><i class="fas fa-users"></i> Gestión de Empleados</a></li>
        <?php endif; ?>
        <li><a href="panel_vacaciones_rrhh.php"><i class="fas fa-umbrella-beach"></i> Gestión de Vacaciones</a></li>
        <?php if ($_SESSION['role'] != 11): ?>
            <li><a href="gestionar_unidades_puestos.php"><i class="fas fa-building"></i> Unidades y Puestos</a></li>
            <li><a href="asignar_privilegios_rrhh.php"><i class="fas fa-user-shield"></i> Asignar Rol</a></li>
        <?php endif; ?>

        <!-- ✅ NUEVO: acceso directo al Portal de Denuncias -->
        <li>
            <a href="https://sistemas.proasol.gob.hn/denuncias_proasol/index.html?src=rrhh_sidebar"
               target="_blank" rel="noopener">
               <i class="fas fa-shield-alt"></i> Denuncia-CPEP
            </a>
        </li>

        <li><a href="panel_rrhh_user.php"><i class="fas fa-user"></i> Perfil</a></li>
        <li><a href="logout.php"><i class="fas fa-sign-out-alt"></i> Cerrar Sesión</a></li>
    </ul>
</div>


        <!-- Contenido principal -->
        <div class="main-content">
            <h1>Lista de Solicitudes</h1>
            <?php if ($result->num_rows > 0): ?>
                <table>
                    <thead>
                        <tr>
                            <th>Tipo de Solicitud</th>
                            <th>Comentarios</th>
                            <th>Fecha de Solicitud</th>
                            <th>Estado</th>
                            <th>Solicitante</th>
                            <th>Acción</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while ($row = $result->fetch_assoc()): ?>
                            <tr>
                                <td><?= htmlspecialchars($row['tipo_solicitud'] ?? '') ?></td>
                                <td><?= htmlspecialchars($row['descripcion_motivo'] ?? '') ?></td>
                                <td><?= htmlspecialchars($row['fecha_solicitud'] ?? '') ?></td>
                                <td><?= htmlspecialchars($row['estado'] ?? '') ?></td>
                                <td><?= htmlspecialchars($row['nombre_completo'] ?? '') ?></td>
                                <td>
                                    <button class="action-btn" data-solicitud-id="<?= $row['id'] ?>" onclick="finalizarSolicitud(this, '<?= htmlspecialchars($row['CorreoElectronico']) ?>', '<?= htmlspecialchars($row['nombre_completo']) ?>', '<?= htmlspecialchars($row['tipo_solicitud']) ?>')">Finalizado</button>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            <?php else: ?>
                <p>No hay solicitudes registradas.</p>
            <?php endif; ?>
        </div>
    </div>

    <script>
        function finalizarSolicitud(button, correo, nombre, tipoSolicitud) {
            if (confirm('¿Estás seguro de marcar esta solicitud como finalizada y enviar un correo al solicitante?')) {
                const solicitudId = button.getAttribute('data-solicitud-id');
                fetch('ver_solicitudes.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded',
                    },
                    body: 'accion=finalizar&solicitud_id=' + encodeURIComponent(solicitudId)
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        alert(data.message);
                        // Actualizar la fila en la tabla
                        const row = button.closest('tr');
                        if (row) {
                            row.cells[3].textContent = 'Finalizado'; // Actualizar el estado
                            row.cells[5].innerHTML = '<span class="processed">Procesado</span>'; // Indicar que fue procesado
                        } else {
                            console.warn('No se encontró la fila para actualizar.');
                        }
                    } else {
                        alert('Error: ' + data.message);
                    }
                })
                .catch(error => {
                    alert('Ocurrió un error al procesar la solicitud.');
                    console.error('Error:', error);
                });
            }
        }

        function toggleSidebar() {
            const sidebar = document.getElementById('sidebar');
            sidebar.classList.toggle('open');
            const mainContent = document.querySelector('.main-content');
            if (sidebar.classList.contains('open')) {
                mainContent.style.marginLeft = '250px';
            } else {
                mainContent.style.marginLeft = '0';
            }
        }
    </script>
</body>
</html>